/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.layoutmanager;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public final class PercentLayout
implements LayoutManager,
Serializable {
    static final long serialVersionUID = 8698917393571711634L;
    private Vector<Component> comps = new Vector();
    private Vector<Rectangle> params = new Vector();

    @Override
    public void addLayoutComponent(String s, Component component) {
        StringTokenizer stringtokenizer = new StringTokenizer(s, " ,");
        int y = -1;
        int h = -1;
        int x = -1;
        int w = -1;
        while (stringtokenizer.hasMoreTokens()) {
            StringTokenizer stringtokenizer1 = new StringTokenizer(stringtokenizer.nextToken(), "=");
            if (stringtokenizer1.countTokens() < 2) {
                throw new IllegalArgumentException("Bad constraints");
            }
            String s1 = stringtokenizer1.nextToken();
            String s2 = stringtokenizer1.nextToken();
            if (s1.equals("right") || s1.equals("r")) {
                w = Integer.valueOf(s2);
                continue;
            }
            if (s1.equals("left") || s1.equals("l")) {
                x = Integer.valueOf(s2);
                continue;
            }
            if (s1.equals("top") || s1.equals("t")) {
                y = Integer.valueOf(s2);
                continue;
            }
            if (s1.equals("bottom") || s1.equals("b")) {
                h = Integer.valueOf(s2);
                continue;
            }
            throw new IllegalArgumentException("Missing constraints");
        }
        this.comps.addElement(component);
        this.params.addElement(new Rectangle(x, y, w, h));
    }

    @Override
    public void removeLayoutComponent(Component component) {
        int i = this.comps.lastIndexOf(component);
        if (i != -1) {
            this.comps.removeElementAt(i);
            this.params.removeElementAt(i);
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        Enumeration<Component> enumeration = this.comps.elements();
        Enumeration<Rectangle> enumeration1 = this.params.elements();
        while (enumeration.hasMoreElements()) {
            Dimension dimension1 = enumeration.nextElement().getPreferredSize();
            Rectangle rectangle = enumeration1.nextElement();
            int i = rectangle.x == -1 ? (rectangle.width == -1 ? 100 : rectangle.width) : (rectangle.width == -1 ? 100 - rectangle.x : rectangle.width - rectangle.x);
            if (dimension.width < dimension1.width * 100 / i) {
                dimension.width = dimension1.width * 100 / i;
            }
            int j = rectangle.y == -1 ? (rectangle.height == -1 ? 100 : rectangle.height) : (rectangle.height == -1 ? 100 - rectangle.y : rectangle.height - rectangle.y);
            if (dimension.height >= dimension1.height * 100 / j) continue;
            dimension.height = dimension1.height * 100 / j;
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        Enumeration<Component> enumeration = this.comps.elements();
        Enumeration<Rectangle> enumeration1 = this.params.elements();
        while (enumeration.hasMoreElements()) {
            Dimension dimension1 = enumeration.nextElement().getMinimumSize();
            Rectangle rectangle = enumeration1.nextElement();
            int i = rectangle.x == -1 ? (rectangle.width == -1 ? 100 : rectangle.width) : (rectangle.width == -1 ? 100 - rectangle.x : rectangle.width - rectangle.x);
            if (dimension.width < dimension1.width * 100 / i) {
                dimension.width = dimension1.width * 100 / i;
            }
            int j = rectangle.y == -1 ? (rectangle.height == -1 ? 100 : rectangle.height) : (rectangle.height == -1 ? 100 - rectangle.y : rectangle.height - rectangle.y);
            if (dimension.height >= dimension1.height * 100 / j) continue;
            dimension.height = dimension1.height * 100 / j;
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    @Override
    public void layoutContainer(Container container) {
        Dimension dimension = new Dimension(0, 0);
        Enumeration<Component> cnumeration = this.comps.elements();
        Enumeration<Rectangle> pnumeration = this.params.elements();
        while (cnumeration.hasMoreElements()) {
            Dimension dimension1 = container.getSize();
            int i = dimension1.width;
            int j = dimension1.height;
            int k = i;
            int l = j;
            int i1 = 0;
            int j1 = 0;
            Insets insets = container.getInsets();
            i -= insets.left + insets.right;
            j -= insets.top + insets.bottom;
            k -= insets.right;
            l -= insets.bottom;
            i1 = insets.left;
            j1 = insets.top;
            Component component = cnumeration.nextElement();
            Rectangle rectangle = pnumeration.nextElement();
            dimension1 = component.getPreferredSize();
            if (rectangle.width == -1) {
                if (rectangle.x == -1) {
                    i1 += (i - dimension1.width) / 2;
                    i = dimension1.width;
                } else {
                    i1 += i * rectangle.x / 100;
                    i = dimension1.width;
                }
                if (i1 + i > k) {
                    i = k - i1;
                }
            } else if (rectangle.x == -1) {
                if (i * rectangle.width / 100 > dimension1.width) {
                    i1 += i * rectangle.width / 100 - dimension1.width;
                    i = dimension1.width;
                } else {
                    i = i * rectangle.width / 100;
                }
            } else {
                i1 += i * rectangle.x / 100;
                i = i * rectangle.width / 100 - i1;
            }
            if (rectangle.height == -1) {
                if (rectangle.y == -1) {
                    j1 += (j - dimension1.height) / 2;
                    j = dimension1.height;
                } else {
                    j1 += j * rectangle.y / 100;
                    j = dimension1.height;
                }
                if (j1 + j > l) {
                    j = l - j1;
                }
            } else if (rectangle.y == -1) {
                if (j * rectangle.height / 100 > dimension1.height) {
                    j1 += j * rectangle.height / 100 - dimension1.height;
                    j = dimension1.height;
                } else {
                    j = j * rectangle.height / 100;
                }
            } else {
                j1 += j * rectangle.y / 100;
                j = j * rectangle.height / 100 - j1;
            }
            component.setBounds(i1, j1, i, j);
        }
    }

    public String toString() {
        return this.getClass().getName();
    }
}

