/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RepaintManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import prospektservice.LoginForm;
import prospektservice.PSEnvironment;
import prospektservice.PSUser;
import prospektservice.base.PamDialog;

public class frmHelp
extends PamDialog
implements Printable {
    private static final long serialVersionUID = 3256444715803883059L;
    private static frmHelp helpInstance = null;
    private static String currentHelpfile = "";
    public static boolean isAccept = false;
    private int WIDTH;
    private int HEIGHT;
    private int scrollboxdiffheight;
    private static ResourceBundle localProperty;
    private JPanel panelHelp;
    private JPanel panelCommand;
    private static JEditorPane txtHelp;
    private JScrollPane helpscroller;

    public static frmHelp getInstance(String helpfile) {
        if (helpInstance != null) {
            if (helpfile.equals(currentHelpfile)) {
                helpInstance.setVisible(true);
                return helpInstance;
            }
            helpInstance.disposeHelpInstance();
        }
        helpInstance = new frmHelp(helpfile);
        return helpInstance;
    }

    public static frmHelp getInstance(String helpfile, JDialog owner) {
        if (helpInstance != null) {
            if (helpfile.equals(currentHelpfile)) {
                helpInstance.setVisible(true);
                return helpInstance;
            }
            helpInstance.disposeHelpInstance();
        }
        helpInstance = new frmHelp(helpfile, owner);
        return helpInstance;
    }

    public static frmHelp getInstance(String helpfile, JFrame owner) {
        if (helpInstance != null) {
            if (helpfile.equals(currentHelpfile)) {
                helpInstance.setVisible(true);
                return helpInstance;
            }
            helpInstance.disposeHelpInstance();
        }
        helpInstance = new frmHelp(helpfile, owner);
        return helpInstance;
    }

    private frmHelp(String helpfile) {
        this.WIDTH = 520;
        this.HEIGHT = 365;
        this.scrollboxdiffheight = 60;
        new frmHelp(helpfile, null);
    }

    private frmHelp(String helpfile, JDialog owner) {
        super(owner, false);
        this.WIDTH = 520;
        this.HEIGHT = 365;
        this.scrollboxdiffheight = 60;
        this.initForm(helpfile);
    }

    private frmHelp(String helpfile, JFrame owner) {
        super((Frame)owner, false);
        this.WIDTH = 520;
        this.HEIGHT = 365;
        this.scrollboxdiffheight = 60;
        this.initForm(helpfile);
    }

    private void initForm(String helpfile) {
        localProperty = ResourceBundle.getBundle("properties.frmHelp", PSUser.getLanguage());
        this.getContentPane().setLayout(new BorderLayout());
        this.setTitle("POSTAKTUELL MANAGER " + localProperty.getString("Title"));
        this.setDefaultCloseOperation(2);
        this.setSize(this.WIDTH + 10, this.HEIGHT + 10);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                frmHelp.this.disposeHelpInstance();
            }
        });
        txtHelp = new JEditorPane();
        txtHelp.setEditable(false);
        txtHelp.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                block5: {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        try {
                            txtHelp.setPage(e.getURL());
                        }
                        catch (IOException ex) {
                            txtHelp.setText(String.valueOf(localProperty.getString("ErrorPage")) + " " + e.getURL().toString());
                            if (!PSEnvironment.DEBUG) break block5;
                            System.out.println(ex.getMessage());
                        }
                    }
                }
                if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    txtHelp.setCursor(Cursor.getPredefinedCursor(12));
                }
                if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    txtHelp.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        frmHelp.setHelpContent(helpfile);
        this.helpscroller = new JScrollPane();
        this.helpscroller.setBounds(5, 5, this.WIDTH - 5, this.HEIGHT - this.scrollboxdiffheight);
        this.helpscroller.getViewport().add(txtHelp);
        this.getContentPane().add(this.helpscroller);
        JPanel panelCommand = new JPanel();
        panelCommand.setLayout(new FlowLayout(2));
        ActionListener AgreementActionListerner = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("cmdPrint")) {
                    String tmp = currentHelpfile;
                    try {
                        PrinterJob pj = PrinterJob.getPrinterJob();
                        pj.setPrintable(helpInstance);
                        if (pj.printDialog()) {
                            pj.print();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        };
        JButton cmdPrint = this.makeButton("cmdPrint", 100, 120, 90, 25);
        cmdPrint.addActionListener(AgreementActionListerner);
        panelCommand.add(cmdPrint);
        this.getContentPane().add((Component)panelCommand, "South");
        helpInstance = this;
        this.setVisible(true);
    }

    public frmHelp(LoginForm parentForm) {
        JEditorPane agreementText;
        JPanel panelAgreement;
        block2: {
            super((Frame)parentForm, true);
            this.WIDTH = 520;
            this.HEIGHT = 365;
            this.scrollboxdiffheight = 60;
            localProperty = ResourceBundle.getBundle("properties.frmHelp", PSEnvironment.getEnvironmentLanguage());
            this.getContentPane().setLayout(new BorderLayout());
            this.setTitle("POSTAKTUELL MANAGER " + localProperty.getString("TitleAgreement"));
            this.setDefaultCloseOperation(2);
            this.setSize(this.WIDTH + 10, this.HEIGHT + 10);
            this.setResizable(false);
            panelAgreement = new JPanel();
            panelAgreement.setLayout(null);
            this.getContentPane().add((Component)panelAgreement, "Center");
            agreementText = new JEditorPane();
            agreementText.setEditable(false);
            try {
                agreementText.setPage(PSEnvironment.getPSURL("hilfe/license.html"));
            }
            catch (IOException ex) {
                agreementText.setText(String.valueOf(localProperty.getString("ErrorPage")) + " " + PSEnvironment.getPSStdPath() + "hilfe/license.html");
                if (!PSEnvironment.DEBUG) break block2;
                System.out.println(ex.getMessage());
            }
        }
        JScrollPane agreementScroller = new JScrollPane();
        agreementScroller.setBounds(5, 5, this.WIDTH - 5, this.HEIGHT - this.scrollboxdiffheight);
        agreementScroller.getViewport().add(agreementText);
        panelAgreement.add(agreementScroller);
        JPanel panelCommand = new JPanel();
        panelCommand.setLayout(new FlowLayout(2));
        ActionListener AgreementActionListerner = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("cmdAccept")) {
                    isAccept = true;
                }
                if (e.getActionCommand().equals("cmdDecline")) {
                    isAccept = false;
                }
                frmHelp.this.setVisible(false);
            }
        };
        JButton cmdAccept = this.makeButton("cmdAccept", 100, 120, 90, 25);
        cmdAccept.addActionListener(AgreementActionListerner);
        JButton cmdDecline = this.makeButton("cmdDecline", 100, 120, 90, 25);
        cmdDecline.addActionListener(AgreementActionListerner);
        panelCommand.add(cmdAccept);
        panelCommand.add(cmdDecline);
        this.getContentPane().add((Component)panelCommand, "South");
        this.setVisible(true);
    }

    private JButton makeButton(String buttonName, int x, int y, int w, int h) {
        char shortkey = localProperty.getString(String.valueOf(buttonName) + "Key").charAt(0);
        JButton myButton = new JButton(localProperty.getString(buttonName));
        myButton.setActionCommand(buttonName);
        if (shortkey != ' ') {
            myButton.setMnemonic(shortkey);
        }
        myButton.setBounds(x, y, w, h);
        myButton.setPreferredSize(new Dimension(w, h));
        return myButton;
    }

    private static void setHelpContent(String newHelpFile) {
        block3: {
            currentHelpfile = newHelpFile;
            try {
                if (newHelpFile.trim().length() > 0) {
                    txtHelp.setPage(PSEnvironment.getPSURL(newHelpFile));
                }
            }
            catch (IOException ex) {
                txtHelp.setText(String.valueOf(localProperty.getString("ErrorPage")) + " " + PSEnvironment.getPSPath() + newHelpFile);
                if (!PSEnvironment.DEBUG) break block3;
                System.out.println(ex.getMessage());
            }
        }
    }

    public void disposeLicenseInstance() {
        isAccept = false;
        super.dispose();
    }

    public void disposeHelpInstance() {
        helpInstance = null;
        currentHelpfile = "";
        super.dispose();
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) {
        int response = 1;
        Graphics2D g2 = (Graphics2D)g;
        RepaintManager currentManager = RepaintManager.currentManager(txtHelp);
        currentManager.setDoubleBufferingEnabled(false);
        Dimension d = txtHelp.getSize();
        double panelWidth = d.width;
        double panelHeight = d.height;
        double pageHeight = pf.getImageableHeight();
        double pageWidth = pf.getImageableWidth();
        double scale = pageWidth / panelWidth;
        int totalNumPages = (int)Math.ceil(scale * panelHeight / pageHeight);
        if (pageIndex >= totalNumPages) {
            response = 1;
        } else {
            g2.translate(pf.getImageableX(), pf.getImageableY());
            g2.translate(0.0, (double)(-pageIndex) * pageHeight);
            g2.scale(scale, scale);
            txtHelp.paint(g2);
            currentManager.setDoubleBufferingEnabled(true);
            response = 0;
        }
        return response;
    }
}

