/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.PSUser;
import prospektservice.base.PSImageIcon;
import prospektservice.base.PSJTable;
import prospektservice.base.zbnimport.ZbnDataHandler;
import prospektservice.base.zbnimport.ZbnSettings;
import prospektservice.datamodels.PsoDefaultTableModel;
import prospektservice.dialog.DlgTextImport;
import prospektservice.mdbimport.PSJobImporterFactory;

public class PSImportWizard
extends JDialog {
    private static final long serialVersionUID = 3906647496829581367L;
    private static final int WIDTH = 600;
    private static final int HEIGHT = 400;
    private ResourceBundle localProperty;
    private JPanel workPanel;
    private JPanel sidePanel;
    private JLabel lblDPAGLogo;
    private JLabel lblPSOLogo;
    private Object lblPageCnt;
    private JPanel topPanel;
    private JLabel txtExplanation;
    private JLabel lblHeadline;
    private JPanel btnPanel;
    private ActionListener helpActionListener;
    private JButton btnAbort;
    private JButton btnOk;
    private JRadioButton optAddresses;
    private JRadioButton optZustellbezirke;
    private JRadioButton optPLZOrtsteil;
    private JRadioButton optPSImport;
    private ActionListener okActionListener;
    private PSO mainFrame;
    private JScrollPane tablePane;
    private PSJTable previewTable;

    public PSImportWizard(PSO pso) {
        super((Frame)pso, true);
        this.mainFrame = pso;
        this.localProperty = ResourceBundle.getBundle("properties.PSImportWizard", PSUser.getLanguage());
        this.setTitle(this.localProperty.getString("Title"));
        this.setResizable(false);
        this.setSize(600, 400);
        this.setModal(true);
        this.setLocationRelativeTo(pso);
        this.initComponents();
    }

    public void initComponents() {
        this.getContentPane().setLayout(new AbsoluteLayout());
        this.workPanel = new JPanel();
        this.workPanel.setBackground(Color.white);
        this.workPanel.setLayout(new AbsoluteLayout());
        this.sidePanel = new JPanel();
        this.sidePanel.setLayout(new AbsoluteLayout());
        this.sidePanel.setBackground(new Color(247, 197, 0));
        this.lblDPAGLogo = new JLabel();
        this.lblDPAGLogo.setIcon(new PSImageIcon("./images/wizardlogo.gif"));
        this.lblDPAGLogo.setVerticalAlignment(1);
        this.sidePanel.add((Component)this.lblDPAGLogo, new AbsoluteConstraints(0, 0, 140, 60));
        this.lblPSOLogo = new JLabel();
        this.lblPSOLogo.setIcon(new PSImageIcon("./images/pso_logo.gif"));
        this.lblPSOLogo.setVerticalAlignment(1);
        this.sidePanel.add((Component)this.lblPSOLogo, new AbsoluteConstraints(2, 290, 140, 18));
        this.workPanel.add((Component)this.sidePanel, new AbsoluteConstraints(0, 0, 140, 320));
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new AbsoluteLayout());
        this.topPanel.setBackground(new Color(255, 255, 255));
        this.topPanel.setMaximumSize(new Dimension(390, 140));
        this.topPanel.setMinimumSize(new Dimension(390, 140));
        this.topPanel.setPreferredSize(new Dimension(300, 100));
        this.txtExplanation = new JLabel();
        this.txtExplanation.setFont(new Font("Tahoma", 0, 11));
        this.txtExplanation.setBackground(Color.white);
        this.txtExplanation.setText(this.localProperty.getString("txtExplanation"));
        this.topPanel.add((Component)this.txtExplanation, new AbsoluteConstraints(148, 38, 450, -1));
        this.lblHeadline = new JLabel();
        this.lblHeadline.setBackground(Color.white);
        this.lblHeadline.setFont(new Font("Tahoma", 1, 11));
        this.lblHeadline.setText(this.localProperty.getString("lblHeadline"));
        this.topPanel.add((Component)this.lblHeadline, new AbsoluteConstraints(146, 6, 400, -1));
        ButtonGroup bg = new ButtonGroup();
        this.optAddresses = new JRadioButton(this.localProperty.getString("optAddresses"));
        this.optAddresses.setBackground(Color.white);
        this.optAddresses.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PSImportWizard.this.btnOk.setEnabled(true);
            }
        });
        bg.add(this.optAddresses);
        this.topPanel.add((Component)this.optAddresses, new AbsoluteConstraints(148, 88, 400, -1));
        this.optZustellbezirke = new JRadioButton(this.localProperty.getString("optZustellbezirke"));
        this.optZustellbezirke.setBackground(Color.white);
        this.optZustellbezirke.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PSImportWizard.this.btnOk.setEnabled(true);
            }
        });
        bg.add(this.optZustellbezirke);
        this.topPanel.add((Component)this.optZustellbezirke, new AbsoluteConstraints(148, 118, 400, -1));
        this.optPLZOrtsteil = new JRadioButton(this.localProperty.getString("optPLZOrtsteil"));
        this.optPLZOrtsteil.setBackground(Color.white);
        this.optPLZOrtsteil.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PSImportWizard.this.btnOk.setEnabled(true);
            }
        });
        bg.add(this.optPLZOrtsteil);
        this.topPanel.add((Component)this.optPLZOrtsteil, new AbsoluteConstraints(148, 148, 400, -1));
        this.optPSImport = new JRadioButton(this.localProperty.getString("optPSImport"));
        this.optPSImport.setBackground(Color.white);
        this.optPSImport.setEnabled(PSEnvironment.isWindowsPlatform());
        this.optPSImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PSImportWizard.this.btnOk.setEnabled(true);
            }
        });
        this.workPanel.add((Component)this.topPanel, new AbsoluteConstraints(0, 0, 600, 330));
        this.getContentPane().add((Component)this.workPanel, new AbsoluteConstraints(0, 0, 600, 320));
        this.btnPanel = new JPanel();
        this.btnPanel.setLayout(new FlowLayout(1, 10, 5));
        this.btnPanel.setBorder(new EtchedBorder());
        this.btnAbort = new JButton();
        this.btnAbort.setFont(new Font("Tahoma", 0, 11));
        this.btnAbort.setText(this.localProperty.getString("btnAbort"));
        this.btnAbort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PSImportWizard.this.dispose();
            }
        });
        this.btnPanel.add(this.btnAbort);
        this.btnOk = new JButton();
        this.btnOk.setFont(new Font("Tahoma", 0, 11));
        this.btnOk.setText(this.localProperty.getString("btnOk"));
        this.btnOk.setEnabled(false);
        this.okActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PSImportWizard.this.dispose();
                if (PSImportWizard.this.optZustellbezirke.isSelected() || PSImportWizard.this.optAddresses.isSelected()) {
                    if (PSImportWizard.this.mainFrame.switchModus(5) == 0) {
                        ZbnDataHandler zbnHandler = ZbnDataHandler.getInstance(true);
                        ZbnSettings settings = zbnHandler.getSettings();
                        settings.setChkZBFile(PSImportWizard.this.optZustellbezirke.isSelected());
                        settings.setOptDirectModeSelected(false);
                        settings.setOptFileModeSelected(true);
                        settings.setCalledByWizard(true);
                        settings.setChkUmkreisSelected(PSImportWizard.this.optAddresses.isSelected());
                        zbnHandler.showZbnDialog();
                    }
                } else if (PSImportWizard.this.optPLZOrtsteil.isSelected()) {
                    if (PSImportWizard.this.mainFrame.switchModus(0) == 0) {
                        ((PSImportWizard)PSImportWizard.this).mainFrame.dlgTxtImport = new DlgTextImport(PSImportWizard.this.mainFrame);
                        ((PSImportWizard)PSImportWizard.this).mainFrame.dlgTxtImport.setVisible(true);
                    }
                } else if (PSImportWizard.this.optPSImport.isSelected()) {
                    PSJobImporterFactory.importJob();
                }
            }
        };
        this.btnOk.addActionListener(this.okActionListener);
        this.btnPanel.add(this.btnOk);
        this.getContentPane().add((Component)this.btnPanel, new AbsoluteConstraints(2, 325, 592, -1));
    }

    public void buildResultsPanel(Vector<Vector> v) {
        this.topPanel.removeAll();
        this.workPanel.removeAll();
        this.getContentPane().removeAll();
        this.workPanel.add((Component)this.sidePanel, new AbsoluteConstraints(0, 0, 140, 394));
        this.txtExplanation.setText("<html>" + this.localProperty.getString("stepResultsExplanation") + "</html>");
        this.topPanel.add((Component)this.txtExplanation, new AbsoluteConstraints(148, 38, 405, -1));
        this.lblHeadline.setText(this.localProperty.getString("stepResultsHeadline"));
        this.topPanel.add((Component)this.lblHeadline, new AbsoluteConstraints(146, 6, 400, -1));
        this.workPanel.add((Component)this.topPanel, new AbsoluteConstraints(0, 0, 500, 100));
        JPanel panelPreview = new JPanel();
        panelPreview.setLayout(new AbsoluteLayout());
        panelPreview.setBorder(new TitledBorder(this.localProperty.getString("lblNotFound")));
        panelPreview.setBackground(Color.white);
        this.tablePane = new JScrollPane();
        this.previewTable = new PSJTable();
        this.previewTable.getTableHeader().setReorderingAllowed(false);
        this.previewTable.getTableHeader().setResizingAllowed(true);
        PsoDefaultTableModel dtm = new PsoDefaultTableModel();
        dtm.setColumnCount(2);
        int i = 0;
        while (i < v.size()) {
            dtm.addRow(v.elementAt(i));
            ++i;
        }
        this.previewTable.setModel(dtm);
        this.tablePane.getViewport().add(this.previewTable);
        panelPreview.add((Component)this.tablePane, new AbsoluteConstraints(10, 20, 400, 120));
        JButton btnExport = new JButton(this.localProperty.getString("btnExport"));
        btnExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PSImportWizard.this.exportUnresolved();
            }
        });
        panelPreview.add((Component)btnExport, new AbsoluteConstraints(120, 145, 200, 25));
        this.workPanel.setBackground(Color.white);
        this.workPanel.add((Component)panelPreview, new AbsoluteConstraints(144, 100, 420, 180));
        this.getContentPane().add((Component)this.workPanel, new AbsoluteConstraints(0, 0, 600, 320));
        this.btnPanel.remove(this.btnAbort);
        this.btnOk.removeActionListener(this.okActionListener);
        this.btnOk.setText(this.localProperty.getString("stepResultsOKButton"));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PSImportWizard.this.dispose();
            }
        });
        this.getContentPane().add((Component)this.btnPanel, new AbsoluteConstraints(2, 325, 592, -1));
    }

    private void exportUnresolved() {
        try {
            File DataDir = new File(String.valueOf(PSEnvironment.getPSPath()) + "export" + PSEnvironment.FILE_SEPARATOR);
            if (!DataDir.exists()) {
                DataDir.mkdirs();
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(String.valueOf(PSEnvironment.getPSPath()) + "export" + PSEnvironment.FILE_SEPARATOR + "import.log"));
            int i = 0;
            while (i < this.previewTable.getRowCount()) {
                bw.write(this.previewTable.getValueAt(i, 0).toString());
                bw.write(";");
                if (this.previewTable.getValueAt(i, 1) != null) {
                    bw.write(this.previewTable.getValueAt(i, 1).toString());
                }
                bw.newLine();
                ++i;
            }
            bw.flush();
            bw.close();
            JOptionPane.showMessageDialog(this, String.valueOf(this.localProperty.getString("SaveMsgPt1")) + " " + PSEnvironment.getPSPath() + "export" + PSEnvironment.FILE_SEPARATOR + "import.log " + this.localProperty.getString("SaveMsgPt2"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, this.localProperty.getString("ExportErr"), this.localProperty.getString("ExportErrTitle"), 0);
        }
    }
}

