/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import prospektservice.PSEnvironment;
import prospektservice.PSUser;
import prospektservice.base.DirectoryTreeNode;
import prospektservice.base.PSJCheckBox;

public class DlgChooseDirectory
extends JDialog {
    private static final long serialVersionUID = 3258135751786051894L;
    private static final int HPAD1 = 6;
    private static final int VPAD1 = 6;
    private static final int HPAD2 = 10;
    private static final int VPAD2 = 10;
    private static final int WIDTH = 380;
    private static final int HEIGHT = 380;
    private FileSystemView fileSystemView;
    private JTree directoryTree;
    private JButton okButton;
    private File selection;
    private PSJCheckBox chkRememberPath;
    private static ResourceBundle localProperty;
    private static boolean showCheckBox;

    static {
        showCheckBox = false;
    }

    private DlgChooseDirectory(Frame parent, String title) {
        super(parent, title, true);
    }

    public static File chooseDirectory(Component parent) {
        return DlgChooseDirectory.chooseDirectory(parent, false);
    }

    public static File chooseDirectory(Component parent, boolean showCheck) {
        File result = null;
        Frame frame = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        localProperty = ResourceBundle.getBundle("properties.DlgChooseDirectory", PSUser.getLanguage());
        showCheckBox = showCheck;
        DlgChooseDirectory chooser = new DlgChooseDirectory(frame, localProperty.getString("Title"));
        chooser.fileSystemView = FileSystemView.getFileSystemView();
        chooser.open();
        if (chooser.fileSystemView.isFileSystem(chooser.selection)) {
            result = chooser.selection;
        }
        return result;
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private JComponent createButtonBar() {
        JPanel grid = new JPanel(new GridLayout(1, showCheckBox ? 3 : 2, 6, 0));
        if (showCheckBox) {
            grid.add(this.createRememberPathCheckBox());
        }
        this.okButton = this.createOKButton();
        grid.add(this.okButton);
        grid.add(this.createCancelButton());
        JPanel bar = new JPanel(new BorderLayout());
        bar.add((Component)grid, "East");
        return bar;
    }

    private JButton createCancelButton() {
        JButton button = new JButton(localProperty.getString("btnCancel"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgChooseDirectory.this.selection = null;
                DlgChooseDirectory.this.close();
            }
        });
        return button;
    }

    private PSJCheckBox createRememberPathCheckBox() {
        this.chkRememberPath = new PSJCheckBox(localProperty.getString("chkRememberPath"));
        return this.chkRememberPath;
    }

    private JComponent createContent() {
        JPanel content = new JPanel(new BorderLayout(0, 6));
        content.add((Component)this.createDirectoryTreePane(), "Center");
        content.add((Component)this.createButtonBar(), "South");
        this.okButton.setEnabled(false);
        content.setBorder(BorderFactory.createEmptyBorder(12, 10, 10, 10));
        content.setPreferredSize(new Dimension(380, 380));
        return content;
    }

    private JComponent createDirectoryTreePane() {
        DirectoryTreeNode root = new DirectoryTreeNode("Roots", this.getRoots(), this.fileSystemView);
        this.directoryTree = new JTree(root);
        this.directoryTree.setRootVisible(false);
        this.directoryTree.setShowsRootHandles(true);
        this.directoryTree.getSelectionModel().setSelectionMode(1);
        if (root.getChildCount() == 1) {
            this.directoryTree.expandRow(0);
        }
        this.directoryTree.setCellRenderer(this.createDirectoryTreeRenderer());
        this.directoryTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DlgChooseDirectory.this.updateOKButtonEnablement((DirectoryTreeNode)e.getPath().getLastPathComponent());
            }
        });
        this.directoryTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2 && DlgChooseDirectory.this.okButton.isEnabled()) {
                    DlgChooseDirectory.this.doOK();
                }
            }
        });
        this.directoryTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent e) {
                DirectoryTreeNode node = (DirectoryTreeNode)e.getPath().getLastPathComponent();
                try {
                    DlgChooseDirectory.this.setCursor(Cursor.getPredefinedCursor(3));
                    node.ensureChildrenAreLoaded();
                }
                finally {
                    DlgChooseDirectory.this.setCursor(Cursor.getDefaultCursor());
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent e) {
            }
        });
        return new JScrollPane(this.directoryTree);
    }

    private TreeCellRenderer createDirectoryTreeRenderer() {
        return new DefaultTreeCellRenderer(){
            private static final long serialVersionUID = 4049918251318719285L;

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, isSelected, expanded, false, row, hasFocus);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                Object userObject = node.getUserObject();
                if (userObject == null || !(userObject instanceof File)) {
                    return this;
                }
                File directory = (File)userObject;
                this.setText(DlgChooseDirectory.this.getSystemDisplayName(directory));
                this.setIcon(DlgChooseDirectory.this.getSystemIcon(directory, isSelected));
                return this;
            }
        };
    }

    private JButton createOKButton() {
        JButton button = new JButton(localProperty.getString("btnOk"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path;
                if (DlgChooseDirectory.this.chkRememberPath != null && DlgChooseDirectory.this.chkRememberPath.isSelected() && (path = DlgChooseDirectory.this.selection.getAbsolutePath()).length() > 0) {
                    PSEnvironment.setPSClientProperty("PS.ExportPath", path);
                }
                DlgChooseDirectory.this.close();
            }
        });
        return button;
    }

    private void doOK() {
        this.close();
    }

    private File[] getRoots() {
        return this.fileSystemView.getRoots();
    }

    private String getSystemDisplayName(File directory) {
        return this.fileSystemView.getSystemDisplayName(directory);
    }

    private Icon getSystemIcon(File file, boolean isSelected) {
        return this.fileSystemView.getSystemIcon(file);
    }

    private void open() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.createContent(), "Center");
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private void updateOKButtonEnablement(DirectoryTreeNode selectedNode) {
        this.selection = selectedNode.getDirectory();
        this.okButton.setEnabled(this.fileSystemView.isFileSystem(this.selection));
    }
}

