/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.base.zbnimport.log;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.base.zbnimport.ZbnDataHandler;
import prospektservice.base.zbnimport.log.ZbnLogEntry;

public class ZbnLogData {
    private static final long NO_DATA_FOUND = 0L;
    private static final long DATA_FOUND = 1L;
    static final long ALREADY_FOUND = 2L;
    private static final long ALREADY_FOUND_BY_PERIPHERAL = 4L;
    private static final long HH_REQUEST_SEND = 8L;
    static final int BIT_SHIFT_AMOUNT = 4;
    private Hashtable<String, ZbnLogEntry> logEntries = new Hashtable();
    private Vector<String> allImported = new Vector();
    private Vector<String> sortedData = new Vector();
    private long hhSum;
    private boolean useID = false;
    private boolean hasPeripherals;
    private boolean logEntgelt = false;
    private int hhUpdateCnt = 0;

    public ZbnLogData(boolean hasID, boolean withPeripherals) {
        this.useID = hasID;
        this.hasPeripherals = withPeripherals;
        this.hhSum = 0L;
    }

    public void addData(String hhSum, String data) {
        int pos;
        long itemState = 0L;
        long itemStateEx = 0L;
        String itemID = "";
        int dataPos = -1;
        if (this.useID && (dataPos = data.indexOf("\t")) > -1) {
            itemID = data.substring(0, dataPos);
        }
        if ((pos = data.indexOf(ZbnDataHandler.IMPORT_SUCCESS)) == -1) {
            String orgData = data.substring(dataPos > -1 ? dataPos + 1 : 0, data.indexOf(ZbnDataHandler.IMPORT_FAILED)).trim();
            ZbnLogEntry actEntry = new ZbnLogEntry(orgData, itemID);
            actEntry.setState(0L);
            this.logEntries.put(orgData, actEntry);
            return;
        }
        itemState = 1L;
        String orgData = data.substring(dataPos + 1, data.indexOf(ZbnDataHandler.IMPORT_SUCCESS)).trim();
        if (!this.logEntries.containsKey(orgData)) {
            ZbnLogEntry actEntry = new ZbnLogEntry(orgData, itemID);
            String zbns = data.substring(data.indexOf(ZbnDataHandler.IMPORT_SUCCESS) + ZbnDataHandler.IMPORT_SUCCESS.length() + 1, data.length());
            actEntry.setResolvedZbn(zbns);
            try {
                actEntry.setResolvedHHData(Long.parseLong(hhSum));
            }
            catch (NumberFormatException nfEx) {
                PSEnvironment.printDebugMessage(String.valueOf(this.getClass().toString()) + ".addData()", nfEx.getMessage());
            }
            StringTokenizer t = new StringTokenizer(zbns, "\t");
            long counter = 0L;
            long addCount = 0L;
            while (t.hasMoreTokens()) {
                if (counter > 0L) {
                    if (counter < 8L) {
                        itemState += (long)(1 << (int)(4L * counter));
                    } else {
                        itemStateEx += (long)(1 << (int)(4L * (counter - 8L)));
                    }
                }
                String singleZbn = t.nextToken();
                long value = this.checkForDuplicates(singleZbn);
                if (counter < 8L) {
                    itemState += value << (int)(4L * counter++);
                } else {
                    itemStateEx += value << (int)(4L * (counter++ - 8L));
                }
                if (this.allImported.contains(singleZbn)) continue;
                this.allImported.addElement(singleZbn);
                ++addCount;
            }
            if (addCount == 0L) {
                actEntry.setResolvedHHData(0L);
            }
            actEntry.setState(itemState);
            actEntry.setExtendedState(itemStateEx);
            this.logEntries.put(orgData, actEntry);
        } else {
            ZbnDataHandler.getInstance(false).decrementSuccessCount();
        }
    }

    public long getHHSum() {
        return this.hhSum;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long checkForDuplicates(String zbn) {
        try {
            Enumeration<ZbnLogEntry> enumEntries = this.logEntries.elements();
            while (true) {
                if (!enumEntries.hasMoreElements()) {
                    return 0L;
                }
                ZbnLogEntry entry = enumEntries.nextElement();
                long entryState = entry.getState();
                if (entryState <= 0L) continue;
                if (entry.containsResolvedZbn(zbn)) {
                    return 2L;
                }
                if (entry.containsPeripheralZbn(zbn)) break;
            }
            return 4L;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return 0L;
    }

    public ZbnLogEntry findElement(String zbn) {
        Enumeration<ZbnLogEntry> enumEntries = this.logEntries.elements();
        while (enumEntries.hasMoreElements()) {
            ZbnLogEntry entry = enumEntries.nextElement();
            long entryState = entry.getState();
            long entryStateEx = entry.getExtendedState();
            long pos = entry.getZbnPosition(zbn);
            if (!(pos < 8L ? entry.containsResolvedZbn(zbn) && (entryState & 2L << (int)(pos * 4L)) == 0L && (entryState & 4L << (int)(pos * 4L)) == 0L : entry.containsResolvedZbn(zbn) && (entryStateEx & 2L << (int)((pos -= 8L) * 4L)) == 0L && (entryStateEx & 4L << (int)(pos * 4L)) == 0L)) continue;
            return entry;
        }
        return null;
    }

    public void addPeripheralData(Object key, Object data) {
        ZbnLogEntry logEntry;
        String toAdd = "";
        StringTokenizer t = new StringTokenizer(data.toString(), "\t");
        while (t.hasMoreTokens()) {
            String zbn = t.nextToken();
            if (this.allImported.contains(zbn)) continue;
            toAdd = String.valueOf(toAdd) + zbn + "\t";
            this.allImported.addElement(zbn);
        }
        if (key.toString().length() < 7) {
            key = "0" + key;
        }
        if ((logEntry = this.findElement(String.valueOf(key.toString().substring(0, 5)) + "-" + key.toString().substring(5, 7))) != null) {
            int pos;
            if (toAdd.length() > 0) {
                logEntry.setPeripheralData(String.valueOf(key.toString().substring(0, 5)) + "-" + key.toString().substring(5, 7), toAdd);
            }
            if ((pos = logEntry.getZbnPosition(String.valueOf(key.toString().substring(0, 5)) + "-" + key.toString().substring(5, 7))) < 8) {
                if ((logEntry.getState() & 8L << pos * 4) == 0L) {
                    ZbnDataHandler.getInstance(false).addPeripheral();
                    PSO.cc.SendMessage(322, String.valueOf(this.logEntgelt ? "1|" : "0|") + key + "|" + toAdd);
                    logEntry.setState(logEntry.getState() | 8L << pos * 4);
                }
            } else if ((logEntry.getExtendedState() & 8L << (pos -= 8) * 4) == 0L) {
                ZbnDataHandler.getInstance(false).addPeripheral();
                PSO.cc.SendMessage(322, String.valueOf(this.logEntgelt ? "1|" : "0|") + key + "|" + toAdd);
                logEntry.setExtendedState(logEntry.getExtendedState() | 8L << pos * 4);
            }
        } else {
            throw new NullPointerException("Fehler in addPeripheralData -> Ursprungs-Zbn nicht gefunden -> " + key);
        }
    }

    public void setHHSum(String data) {
        ZbnLogEntry logEntry;
        StringTokenizer t = new StringTokenizer(data, "|");
        String zbn = t.nextToken();
        ZbnLogEntry zbnLogEntry = logEntry = zbn.indexOf("-") == -1 ? this.findElement(String.valueOf(zbn.substring(0, 5)) + "-" + zbn.substring(5, 7)) : this.findElement(zbn);
        if (logEntry != null) {
            if (!this.logEntgelt) {
                logEntry.setHouseHoldData(t.nextToken());
            } else {
                logEntry.setHouseHoldsAndEntgelt(t.nextToken(), t.nextToken());
                if (this.hhUpdateCnt > 0) {
                    --this.hhUpdateCnt;
                }
            }
        }
    }

    public String[] getAmbiguousEntries() {
        try {
            Vector<String> ambiguousData = new Vector<String>();
            Vector<String> taboo = new Vector<String>();
            Enumeration<ZbnLogEntry> enumEntries = this.logEntries.elements();
            while (enumEntries.hasMoreElements()) {
                ZbnLogEntry actEntry = enumEntries.nextElement();
                if (actEntry.getState() == 0L) continue;
                StringTokenizer t = new StringTokenizer(actEntry.getResolvedZbn(), "\t");
                int tokenCnt = 0;
                while (t.hasMoreTokens()) {
                    if (tokenCnt < 8) {
                        long itemState = actEntry.getState();
                        String actZbn = t.nextToken();
                        if (this.findElement(actZbn) == null || ((itemState >>= 4 * tokenCnt++) & 2L) == 0L || taboo.contains(actZbn)) continue;
                        ambiguousData.addElement(this.formAmbiguousEntry(actZbn));
                        taboo.addElement(actZbn);
                        continue;
                    }
                    int shifter = tokenCnt++ - 8;
                    long itemStateEx = actEntry.getExtendedState();
                    String actZbn = t.nextToken();
                    if (this.findElement(actZbn) == null || ((itemStateEx >>= 4 * shifter) & 2L) == 0L || taboo.contains(actZbn)) continue;
                    ambiguousData.addElement(this.formAmbiguousEntry(actZbn));
                    taboo.addElement(actZbn);
                }
            }
            taboo.removeAllElements();
            Object[] data = new String[ambiguousData.size()];
            ambiguousData.copyInto(data);
            ambiguousData.removeAllElements();
            return data;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private String formAmbiguousEntry(String orgZB) {
        String result = String.valueOf(orgZB) + ";";
        ZbnLogEntry orgEntry = this.findElement(orgZB);
        Enumeration<ZbnLogEntry> enumEntries = this.logEntries.elements();
        while (enumEntries.hasMoreElements()) {
            ZbnLogEntry actEntry = enumEntries.nextElement();
            if (!actEntry.containsResolvedZbn(orgZB)) continue;
            if (actEntry.equals(orgEntry)) {
                result = String.valueOf(result) + "!";
            }
            result = String.valueOf(result) + actEntry.getOrigin() + ";";
        }
        return result;
    }

    public void reassignZbToSource(String zbn, String source) {
        ZbnLogEntry foundEntry = null;
        ZbnLogEntry actEntry = this.logEntries.get(source);
        try {
            foundEntry = this.findElement(zbn);
            if (foundEntry != null) {
                if (foundEntry.equals(actEntry)) {
                    return;
                }
                if (actEntry.getResolvedZbnCnt() == 1 && foundEntry.getResolvedZbnCnt() == 1) {
                    ZbnLogEntry tmpEntry = actEntry.cloneObject();
                    actEntry = foundEntry.cloneObject();
                    actEntry.reassignOrigin(source);
                    String oldOrg = foundEntry.getOrigin();
                    foundEntry = tmpEntry.cloneObject();
                    foundEntry.reassignOrigin(oldOrg);
                    this.logEntries.put(oldOrg, foundEntry);
                    this.logEntries.put(source, actEntry);
                    if (foundEntry.getID().length() > 0) {
                        PSO.cc.SendMessage(330, String.valueOf(zbn) + "|" + foundEntry.getID());
                    }
                } else {
                    int pos1 = actEntry.getZbnPosition(zbn);
                    int pos2 = foundEntry.getZbnPosition(zbn);
                    if (pos1 < 8) {
                        actEntry.setState(actEntry.getState() & (2L << 4 * pos1 ^ 0xFFFFFFFFFFFFFFFFL));
                    } else {
                        actEntry.setExtendedState(actEntry.getExtendedState() & (2L << 4 * (pos1 - 8) ^ 0xFFFFFFFFFFFFFFFFL));
                    }
                    if (pos2 < 8) {
                        foundEntry.setState(foundEntry.getState() | 2L << 4 * pos2);
                    } else {
                        foundEntry.setState(foundEntry.getState() | 2L << 4 * (pos2 - 8));
                    }
                    if (this.hasPeripherals) {
                        actEntry.setPeripheralData(zbn, foundEntry.getPeripheral(zbn));
                        foundEntry.delPeripherals(zbn);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void recalcHouseholdData() {
        Enumeration<ZbnLogEntry> entries = this.logEntries.elements();
        while (entries.hasMoreElements()) {
            ZbnLogEntry actEntry = entries.nextElement();
            actEntry.resetHouseHoldData(this.logEntgelt);
            ++this.hhUpdateCnt;
        }
    }

    public String[] getFormattedData() {
        ZbnLogEntry logEntry;
        int arrayIndex = 0;
        this.sortEntries();
        String[] formattedData = new String[this.sortedData.size()];
        int i = 0;
        while (i < formattedData.length) {
            logEntry = this.logEntries.get(this.sortedData.elementAt(i));
            if (logEntry.getState() > 0L) {
                formattedData[arrayIndex] = String.valueOf(this.useID ? String.valueOf(logEntry.getID()) + "\t" : "") + logEntry.getOrigin() + " " + ZbnDataHandler.IMPORT_SUCCESS;
                String households = logEntry.getHouseHoldData().length() == 0 ? PSEnvironment.formatLongToGermanLocale(logEntry.getResolvedHHData()) : logEntry.getHouseHoldData();
                int n = arrayIndex;
                formattedData[n] = String.valueOf(formattedData[n]) + "\t" + households;
                if (this.logEntgelt) {
                    String entgelt = PSEnvironment.Format(logEntry.getEntgelt(), "###,###,##0.00");
                    int n2 = arrayIndex;
                    formattedData[n2] = String.valueOf(formattedData[n2]) + "\t" + entgelt;
                }
                StringTokenizer t = new StringTokenizer(logEntry.getResolvedZbn(), "\t");
                int tokenCnt = 0;
                while (t.hasMoreTokens()) {
                    ZbnLogEntry wantedEntry;
                    String actZbn;
                    if (tokenCnt < 8) {
                        actZbn = t.nextToken();
                        int n3 = arrayIndex;
                        formattedData[n3] = String.valueOf(formattedData[n3]) + "\t" + actZbn;
                        long itemState = logEntry.getState();
                        int n4 = tokenCnt++;
                        wantedEntry = this.findElement(actZbn);
                        if (((itemState >>= 4 * n4) & 2L) == 2L) {
                            int n5 = arrayIndex;
                            formattedData[n5] = String.valueOf(formattedData[n5]) + "\t" + ZbnDataHandler.ALREADY_CONTAINED_PT1 + (wantedEntry != null ? wantedEntry.getOrigin() : ZbnDataHandler.ALREADY_CONTAINED_PT3) + " " + ZbnDataHandler.ALREADY_CONTAINED_PT2;
                        }
                        if ((itemState & 4L) != 4L) continue;
                        int n6 = arrayIndex;
                        formattedData[n6] = String.valueOf(formattedData[n6]) + "\t" + ZbnDataHandler.ALREADY_CONTAINED_PT1 + " " + ZbnDataHandler.ALREADY_CONTAINED_PT3 + " " + ZbnDataHandler.ALREADY_CONTAINED_PT2;
                        continue;
                    }
                    actZbn = t.nextToken();
                    int n7 = arrayIndex;
                    formattedData[n7] = String.valueOf(formattedData[n7]) + "\t" + actZbn;
                    long itemStateEx = logEntry.getExtendedState();
                    int n8 = tokenCnt++;
                    wantedEntry = this.findElement(actZbn);
                    if (((itemStateEx >>= 4 * (n8 - 8)) & 2L) == 2L) {
                        int n9 = arrayIndex;
                        formattedData[n9] = String.valueOf(formattedData[n9]) + "\t" + ZbnDataHandler.ALREADY_CONTAINED_PT1 + (wantedEntry != null ? wantedEntry.getOrigin() : ZbnDataHandler.ALREADY_CONTAINED_PT3) + " " + ZbnDataHandler.ALREADY_CONTAINED_PT2;
                    }
                    if ((itemStateEx & 4L) != 4L) continue;
                    int n10 = arrayIndex;
                    formattedData[n10] = String.valueOf(formattedData[n10]) + "\t" + ZbnDataHandler.ALREADY_CONTAINED_PT1 + " " + ZbnDataHandler.ALREADY_CONTAINED_PT3 + " " + ZbnDataHandler.ALREADY_CONTAINED_PT2;
                }
                String peripheralSel = logEntry.getPeripheralData();
                if (peripheralSel.length() > 0) {
                    int n11 = arrayIndex;
                    formattedData[n11] = String.valueOf(formattedData[n11]) + "\t" + ZbnDataHandler.periphery + "\t" + peripheralSel;
                }
                ++arrayIndex;
                this.hhSum += logEntry.getRawHouseHoldData();
            }
            ++i;
        }
        i = 0;
        while (i < this.logEntries.size()) {
            logEntry = this.logEntries.get(this.sortedData.elementAt(i));
            if (logEntry.getState() == 0L) {
                formattedData[arrayIndex++] = String.valueOf(this.useID ? String.valueOf(logEntry.getID()) + "\t" : "") + logEntry.getOrigin() + " " + ZbnDataHandler.IMPORT_FAILED;
            }
            ++i;
        }
        return formattedData;
    }

    private void sortEntries() {
        String[] toSort = new String[this.logEntries.size()];
        try {
            Enumeration<String> enumEntries = this.logEntries.keys();
            int i = 0;
            while (enumEntries.hasMoreElements()) {
                toSort[i++] = enumEntries.nextElement().toString();
            }
            ZbnLogData.QuickSort(toSort, 0, toSort.length - 1);
            i = 0;
            while (i < toSort.length) {
                this.sortedData.addElement(toSort[i]);
                ++i;
            }
            toSort = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void clearPeripherals() {
        Enumeration<ZbnLogEntry> enumEntries = this.logEntries.elements();
        while (enumEntries.hasMoreElements()) {
            ZbnLogEntry actEntry = enumEntries.nextElement();
            actEntry.delPeripheralData();
        }
    }

    void clearAll() {
        this.allImported.removeAllElements();
        this.sortedData.removeAllElements();
        Enumeration<ZbnLogEntry> enumEntries = this.logEntries.elements();
        while (enumEntries.hasMoreElements()) {
            ZbnLogEntry actEntry = enumEntries.nextElement();
            actEntry.discard();
        }
        this.logEntries.clear();
    }

    public int getHHForZb(String zbn) {
        ZbnLogEntry logEntry = this.findElement(String.valueOf(zbn.substring(0, 5)) + "-" + zbn.substring(5, 7));
        return (int)logEntry.getResolvedHHData();
    }

    public int getHhUpdateCnt() {
        return this.hhUpdateCnt;
    }

    public void setLogEntgelt(boolean b) {
        this.logEntgelt = b;
    }

    /*
     * Unable to fully structure code
     */
    public static void QuickSort(String[] a, int lo0, int hi0) throws Exception {
        block5: {
            lo = lo0;
            hi = hi0;
            if (hi0 <= lo0) break block5;
            mid = a[(lo0 + hi0) / 2];
            ** GOTO lbl16
            {
                ++lo;
                do {
                    if (lo < hi0 && a[lo].compareTo(mid) < 0) continue block0;
                    while (hi > lo0 && a[hi].compareTo(mid) > 0) {
                        --hi;
                    }
                    if (lo > hi) continue;
                    ZbnLogData.swap(a, lo, hi);
                    ++lo;
                    --hi;
lbl16:
                    // 3 sources

                } while (lo <= hi);
            }
            if (lo0 < hi) {
                ZbnLogData.QuickSort(a, lo0, hi);
            }
            if (lo < hi0) {
                ZbnLogData.QuickSort(a, lo, hi0);
            }
        }
    }

    private static void swap(String[] a, int i, int j) {
        String T = a[i];
        a[i] = a[j];
        a[j] = T;
    }
}

