/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.base.progress;

import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import prospektservice.base.progress.ProgressDialog;
import prospektservice.base.progress.VolumeProgressPanel;

public abstract class VolumeProgressDialog
extends ProgressDialog {
    VolumeProgressPanel volumeProgressPanel;

    public VolumeProgressDialog(JFrame parentFrame, long progressMaxCount) {
        super(parentFrame, true, true);
        this.createVolumeProgressPanel(parentFrame, progressMaxCount, 1000, true);
    }

    public VolumeProgressDialog(JFrame parentFrame, long progressMaxCount, int stepMillisecondDuration) {
        super(parentFrame, true, true);
        this.createVolumeProgressPanel(parentFrame, progressMaxCount, stepMillisecondDuration, true);
    }

    public VolumeProgressDialog(JFrame parentFrame, boolean isAutoClose, long progressMaxCount, int stepMillisecondDuration) {
        super(parentFrame, true, isAutoClose);
        this.createVolumeProgressPanel(parentFrame, progressMaxCount, stepMillisecondDuration, true);
    }

    public VolumeProgressDialog(JFrame parentFrame, boolean isAutoStart, boolean isAutoClose, long progressMaxCount, int stepMillisecondDuration) {
        super(parentFrame, isAutoStart, isAutoClose);
        this.createVolumeProgressPanel(parentFrame, progressMaxCount, stepMillisecondDuration, true);
    }

    public VolumeProgressDialog(JFrame parentFrame, boolean isAutoStart, boolean isAutoClose, long progressMaxCount, int stepMillisecondDuration, boolean isMessagesVisible) {
        super(parentFrame, isAutoStart, isAutoClose);
        this.createVolumeProgressPanel(parentFrame, progressMaxCount, stepMillisecondDuration, isMessagesVisible);
    }

    private void createVolumeProgressPanel(JFrame parentFrame, long progressMaxCount, int stepMillisecondDuration, boolean isMessagesVisible) {
        this.prgDialog.setTitle(localProperty.getString("VolumeProgressTitle"));
        this.volumeProgressPanel = new VolumeProgressPanel((int)progressMaxCount, stepMillisecondDuration, isMessagesVisible);
        VolumeProgressPanel.DEBUG_MessageEnabled = ProgressDialog.debugMessageEnabled;
        this.volumeProgressPanel.addProgressListener(this.workProgressListener);
        this.progressPanel.add(this.volumeProgressPanel);
        this.workProgressPanel = this.volumeProgressPanel;
        this.prgDialog.pack();
        this.prgDialog.setLocationRelativeTo(parentFrame);
        if (!isMessagesVisible) {
            this.adjustLayout();
        }
    }

    private void adjustLayout() {
        this.prgDialog.setSize(300, 120);
        this.getProgressBar().setPreferredSize(new Dimension(200, 20));
    }

    private JProgressBar getProgressBar() {
        return this.volumeProgressPanel.getProgressBar();
    }

    public long getProgressMaximum() {
        return this.volumeProgressPanel.getProgressMaximum();
    }

    public long getProgressRemainDuration() {
        return (long)this.volumeProgressPanel.remainSecondsDuration * 1000L;
    }

    public void setProgressStepDuration(int millisecondsDuration) {
        this.volumeProgressPanel.changeProgressStepDuration(millisecondsDuration);
    }

    public int getProgressStepDuration() {
        return this.volumeProgressPanel.getProgressStepDuration();
    }

    public void restartProgress(int lastStepMillisecondsDuration) {
        this.volumeProgressPanel.restartVolumeProgress(lastStepMillisecondsDuration);
    }

    public void setPureVolumeProgress(boolean flag) {
        this.volumeProgressPanel.setPureVolumeProgress(flag);
    }

    public boolean isPureVolumeProgress() {
        return this.volumeProgressPanel.isPureVolumeProgress();
    }

    public void setProgressValue(int value) {
        this.getProgressBar().setValue(value);
    }

    public void increaseProgressValue(int value, int calcTime) {
        this.getProgressBar().setValue(value);
        this.volumeProgressPanel.changeProgressStepDuration(calcTime);
        this.volumeProgressPanel.refreshProgressMessages();
    }
}

