/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.base;

import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class ZipUtil {
    private static Deflater compressor = new Deflater();
    private static Inflater decompressor = new Inflater();

    public static byte[] compressBytes(byte[] input) {
        int pos = 0;
        byte[] output = new byte[input.length];
        byte[] buffer = new byte[256];
        compressor.setInput(input);
        compressor.finish();
        while (!compressor.finished()) {
            int read = compressor.deflate(buffer);
            if (output.length < pos + read) {
                output = new byte[pos + read];
            }
            System.arraycopy(buffer, 0, output, pos, read);
            pos += read;
        }
        return ZipUtil.shrinkArray(output, pos);
    }

    public static byte[] decompressBytes(byte[] input) throws DataFormatException {
        int actBytes = 0;
        boolean pos = false;
        byte[] output = new byte[input.length];
        byte[] buffer = new byte[256];
        decompressor.setInput(input);
        while (!decompressor.finished()) {
            output = ZipUtil.resizeArray(buffer, output, actBytes += decompressor.inflate(buffer));
        }
        return output;
    }

    public static byte[] compressIntArray(int[] input) {
        byte[] data = new byte[4 * input.length];
        int i = 0;
        while (i < input.length) {
            byte[] tmp = ZipUtil.intToByteArray(input[i]);
            System.arraycopy(tmp, 0, data, i * 4, 4);
            ++i;
        }
        return ZipUtil.compressBytes(data);
    }

    public static int[] decompressIntArray(byte[] input) throws DataFormatException {
        byte[] decompressed = ZipUtil.decompressBytes(input);
        int[] data = new int[(int)((float)decompressed.length * 0.25f)];
        byte[] tmp = new byte[4];
        int i = 0;
        while (i < decompressed.length) {
            System.arraycopy(decompressed, i, tmp, 0, 4);
            data[(int)((float)i * 0.25f)] = ZipUtil.byteArrayToInt(tmp);
            i += 4;
        }
        return data;
    }

    private static byte[] shrinkArray(byte[] array, int newLength) {
        byte[] out = new byte[newLength];
        System.arraycopy(array, 0, out, 0, newLength);
        return out;
    }

    private static byte[] resizeArray(byte[] newData, byte[] store, int size) {
        byte[] tmp = new byte[size];
        if (size > store.length) {
            System.arraycopy(store, 0, tmp, 0, store.length);
            System.arraycopy(newData, 0, tmp, store.length, size - store.length);
        } else {
            System.arraycopy(newData, 0, tmp, 0, size);
        }
        return tmp;
    }

    private static byte[] intToByteArray(int value) {
        byte[] data = new byte[]{(byte)value, (byte)(value >> 8), (byte)(value >> 16), (byte)(value >> 24)};
        return data;
    }

    private static int byteArrayToInt(byte[] data) {
        int value = (data[0] & 0xFF) + ((data[1] & 0xFF) << 8) + ((data[2] & 0xFF) << 16) + ((data[3] & 0xFF) << 24);
        return value;
    }
}

