/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.base.TreeTable;

import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import prospektservice.PSEnvironment;
import prospektservice.base.PSImageIcon;
import prospektservice.base.TreeTable.AbstractTreeTableModel;
import prospektservice.base.TreeTable.TreeTableModel;

public class PSTreeTableModel
extends AbstractTreeTableModel {
    private boolean discarded = false;
    private int columnCount = 0;
    private String[] columnNames;
    private Class[] columnTypes = new Class[]{TreeTableModel.class, Integer.class, String.class, String.class};

    public PSTreeTableModel(Object rootNode) {
        super(null);
        this.root = new ZBNode(rootNode.toString(), 0, "", "", 0);
    }

    public ZBNode addNode(String zbn, int plz, String town, String street, int level) {
        ZBNode node = (ZBNode)this.root;
        return node.addChild(zbn, plz, town, street, level);
    }

    public void discardAll() {
        if (!this.discarded) {
            int cnt = this.getChildCount(this.root);
            int i = 0;
            while (i < cnt) {
                ZBNode child = (ZBNode)this.getChild(this.root, i);
                if (!child.isLeaf()) {
                    ZBNode[] ancestors = child.getChildren();
                    int j = 0;
                    while (j < ancestors.length) {
                        ancestors[j].discard();
                        ++j;
                    }
                    child.discard();
                }
                this.discarded = true;
                ++i;
            }
        }
    }

    @Override
    public Object getChild(Object obj, int param) {
        if (obj instanceof ZBNode) {
            ZBNode actNode = (ZBNode)obj;
            return actNode.getChildAt(param);
        }
        return null;
    }

    @Override
    public int getChildCount(Object obj) {
        ZBNode node = (ZBNode)obj;
        return node == null ? 0 : node.getChildCount();
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Class getColumnClass(int column) {
        return this.columnTypes[column];
    }

    @Override
    public boolean isLeaf(Object node) {
        return super.isLeaf(node);
    }

    @Override
    public Object getValueAt(Object node, int column) {
        try {
            ZBNode actNode = (ZBNode)node;
            switch (column) {
                case 0: {
                    return actNode.getUserObject();
                }
                case 1: {
                    return actNode.getPLZ();
                }
                case 2: {
                    return actNode.getTown();
                }
                case 3: {
                    return actNode.getStreet();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public void nodesChanged(ZBNode node) {
        TreeModelEvent tme = null;
        Object[] listeners = this.listenerList.getListenerList();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] instanceof TreeModelListener) {
                if (tme == null) {
                    new TreeModelEvent((Object)node, node.getPathFromRoot(this.root));
                }
                ((TreeModelListener)listeners[i]).treeNodesChanged(tme);
            }
            ++i;
        }
    }

    public void setColumnNames(String[] names) {
        this.columnNames = new String[names.length];
        System.arraycopy(names, 0, this.columnNames, 0, names.length);
        this.columnCount = names.length;
    }

    public static class ZBNode {
        private int plz;
        private String town;
        private String street;
        private String zbn;
        private Object uObj;
        private int level;
        private ZBNode parent = null;
        private Vector<ZBNode> children = new Vector();
        public static PSImageIcon stdIcon = new PSImageIcon("./images/box.gif");
        public static PSImageIcon chkIcon = new PSImageIcon("./images/box_check.gif");

        public ZBNode(Object newZbn, int newPlz, String newTown, String newStreet, int nodeLevel, ZBNode daddy) {
            if (newZbn instanceof String) {
                this.zbn = (String)newZbn;
            }
            this.plz = newPlz;
            this.town = newTown;
            this.street = newStreet;
            this.level = nodeLevel;
            this.parent = daddy;
        }

        public ZBNode(Object newZbn, int newPlz, String newTown, String newStreet, int nodeLevel) {
            if (newZbn instanceof String) {
                this.zbn = (String)newZbn;
            }
            this.plz = newPlz;
            this.town = newTown;
            this.street = newStreet;
            this.level = nodeLevel;
        }

        public String getTown() {
            return this.town;
        }

        public String getStreet() {
            return this.street;
        }

        public String getPLZ() {
            return this.isLeaf() ? PSEnvironment.Format(this.plz, "00000") : String.valueOf(this.plz);
        }

        public ZBNode getSelectedNode() {
            int i = 0;
            while (i < this.children.size()) {
                ZBNode actNode = this.children.elementAt(i);
                if (actNode.getUserObject().equals(chkIcon)) {
                    return actNode;
                }
                ++i;
            }
            return null;
        }

        public String toString() {
            return this.isLeaf() ? "" : this.zbn;
        }

        public String getZBN() {
            return this.zbn;
        }

        public int getChildCount() {
            return this.children.size();
        }

        public ZBNode getChildAt(int index) {
            return this.children.elementAt(index);
        }

        public ZBNode addChild(Object orgZbn, int plz, String town, String street, int level) {
            ZBNode child = new ZBNode(orgZbn, plz, town, street, level, this);
            if (level == 2) {
                child.setUserObject(orgZbn);
            }
            this.children.addElement(child);
            return child;
        }

        public void setUserObject(Object obj) {
            this.uObj = obj;
        }

        public Object getUserObject() {
            return this.uObj;
        }

        public boolean isLeaf() {
            return this.level > 1;
        }

        public ZBNode getParent() {
            return this.parent;
        }

        public ZBNode[] getChildren() {
            Object[] actNodes = new ZBNode[this.children.size()];
            this.children.copyInto(actNodes);
            return actNodes;
        }

        public void toggleIcon(ZBNode node, PSTreeTableModel model) {
            if (node.getUserObject().equals(chkIcon)) {
                return;
            }
            int i = 0;
            while (i < this.children.size()) {
                ZBNode actNode;
                actNode.setUserObject((actNode = this.children.elementAt(i)).equals(node) ? chkIcon : stdIcon);
                ++i;
            }
            model.nodesChanged(node.getParent());
        }

        public Object[] getPathFromRoot(Object root) {
            Object[] path = new Object[]{root.toString(), this.toString()};
            return path;
        }

        public void discard() {
            if (PSEnvironment.DEBUG) {
                System.out.println("discarding a treetable child object!");
            }
            this.children.removeAllElements();
            this.children = null;
        }
    }
}

