/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.base;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import prospektservice.PSEnvironment;
import prospektservice.base.PSJobTreeNode;

public class PSTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 3833466227610630448L;
    private Color releaseColor = new Color(0, 127, 0);
    private boolean deleteMode = false;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value instanceof PSJobTreeNode) {
            PSJobTreeNode jtn = (PSJobTreeNode)value;
            int locked = PSEnvironment.getIntValue(jtn.getJobRelease());
            if (locked == 1) {
                this.setForeground(this.releaseColor);
            } else if (locked == -1) {
                this.setForeground(Color.red);
            } else {
                this.setForeground(Color.black);
            }
            if (this.deleteMode) {
                this.setBackgroundSelectionColor(Color.orange);
            }
        }
        return this;
    }

    public boolean isDeleteMode() {
        return this.deleteMode;
    }

    public void setDeleteMode(boolean deleteMode) {
        this.deleteMode = deleteMode;
    }
}

