/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.base;

import java.util.Vector;
import javax.swing.JComboBox;
import prospektservice.base.PSComboBoxModel;
import prospektservice.base.PSComboBoxUI;

public class PSComboBox
extends JComboBox {
    private static final long serialVersionUID = 3979271352123406647L;
    private int comboPackageSize = 256;
    private String dummyItemText = "";
    private String additionalMsg = "";
    private PSComboBoxUI cboUI = new PSComboBoxUI();
    private PSComboBoxModel cboModel = null;
    private int dataMsg = 0;

    public PSComboBox() {
        super.setUI(this.cboUI);
    }

    @Override
    public void setMaximumRowCount(int maxRows) {
        super.setMaximumRowCount(maxRows);
        this.comboPackageSize = maxRows * 32;
    }

    public void setModel(Vector data, int maxCount) {
        int foundRecords = data.size();
        this.cboModel = new PSComboBoxModel(data);
        super.setModel(this.cboModel);
        this.cboModel.setDummyItemText(this.dummyItemText);
        this.cboModel.setItemCount(maxCount);
        this.cboModel.setPackageSize(this.comboPackageSize);
        if (this.dataMsg > 0) {
            this.cboModel.setMessageType(this.dataMsg);
        }
        if (!this.additionalMsg.equals("")) {
            this.cboModel.setAdditionalMsg(this.additionalMsg);
        }
        this.cboUI.setDataModel(this.cboModel);
        this.cboUI.adjustVisibleIndex(this.comboPackageSize - foundRecords);
    }

    public void setAdditionalData(Vector<String> data) {
        int actIndex = this.cboUI.getListBox().getLastVisibleIndex();
        this.cboUI.adjustVisibleIndex(this.comboPackageSize - data.size());
        this.cboModel.setAdditionalData(data);
        if (actIndex > -1 && this.cboUI.getListBox().getFirstVisibleIndex() != actIndex) {
            this.cboUI.getListBox().ensureIndexIsVisible(actIndex);
        }
    }

    public void setDummyItemText(String itemText) {
        this.dummyItemText = itemText;
    }

    public void setDataMsg(int msg) {
        this.dataMsg = msg;
    }

    public int getDataMsg() {
        return this.dataMsg;
    }

    public void setAdditionalMsg(String msg) {
        this.additionalMsg = msg;
    }

    public String getAdditionalMsg() {
        return this.additionalMsg;
    }

    public void fireScrollEvent() {
        this.cboUI.fireScrollEvent();
    }

    public PSComboBoxModel getPSComboModel() {
        return this.cboModel;
    }
}

