/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.base;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Window;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;

public class ManualFocusPolicy
extends FocusTraversalPolicy
implements Serializable {
    private static final long serialVersionUID = 3258415014804141881L;
    private HashMap<Container, Component> firstComponents = new HashMap();
    private HashMap<Component, Component> forwardMap = new HashMap();
    private HashMap<Component, Component> backwardMap = new HashMap();

    public void setFirstComponent(Container focusCycleRoot, Component firstComponent) {
        this.firstComponents.put(focusCycleRoot, firstComponent);
    }

    public void setNextFocusableComponent(Component left, Component right) {
        this.forwardMap.put(left, right);
        this.backwardMap.put(right, left);
    }

    public void unsetNextFocusableComponent(Component left, Component right) {
        this.forwardMap.remove(left);
        this.backwardMap.remove(right);
    }

    @Override
    public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
        Component hardCoded = aComponent;
        HashSet<Component> sanity = new HashSet<Component>();
        do {
            Component prevHardCoded = hardCoded;
            if ((hardCoded = this.forwardMap.get(hardCoded)) == null) {
                return null;
            }
            if (sanity.contains(hardCoded)) {
                return null;
            }
            sanity.add(hardCoded);
        } while (!this.accept(hardCoded));
        return hardCoded;
    }

    @Override
    public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
        Component hardCoded = aComponent;
        HashSet<Component> sanity = new HashSet<Component>();
        do {
            Component prevHardCoded = hardCoded;
            if ((hardCoded = this.backwardMap.get(hardCoded)) == null) {
                return null;
            }
            if (sanity.contains(hardCoded)) {
                return null;
            }
            sanity.add(hardCoded);
        } while (!this.accept(hardCoded));
        return hardCoded;
    }

    @Override
    public Component getFirstComponent(Container focusCycleRoot) {
        Component obj = this.firstComponents.get(focusCycleRoot);
        if (obj != null) {
            return obj;
        }
        return null;
    }

    @Override
    public Component getLastComponent(Container focusCycleRoot) {
        return null;
    }

    @Override
    public Component getDefaultComponent(Container focusCycleRoot) {
        return this.getFirstComponent(focusCycleRoot);
    }

    private boolean accept(Component aComponent) {
        if (!(aComponent.isVisible() && aComponent.isDisplayable() && aComponent.isFocusable() && aComponent.isEnabled())) {
            return false;
        }
        if (!(aComponent instanceof Window)) {
            Container enableTest = aComponent.getParent();
            while (enableTest != null) {
                if (!enableTest.isEnabled() && !enableTest.isLightweight()) {
                    return false;
                }
                if (enableTest instanceof Window) break;
                enableTest = enableTest.getParent();
            }
        }
        return true;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }
}

