/*
 * Decompiled with CFR 0.152.
 */
package prospektservice;

import de.codesolutions.pam.map.WebMapPanel;
import java.awt.Component;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.swing.SwingUtilities;
import org.apache.xerces.parsers.DOMParser;
import org.bouncycastle.util.encoders.Base64;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import prospektservice.AKManager;
import prospektservice.AddressManager;
import prospektservice.AutoProxyHelper;
import prospektservice.Feedback;
import prospektservice.PSAuftrag;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.PSOConstants;
import prospektservice.PSUser;
import prospektservice.PsoXmlBuilder;
import prospektservice.RegForm;
import prospektservice.base.BrowserLauncher;
import prospektservice.base.Crypt;
import prospektservice.base.zbnimport.ZbnDataHandler;
import prospektservice.dialog.DlgUnconvertableBankData;
import prospektservice.dialog.PSOProgramOptions;
import prospektservice.dialog.frmPalettenoptimierung;
import prospektservice.mdbimport.PSJobImporterFactory;
import prospektservice.printj2.PrintPaletteStorage;

public class ServerConnection
extends Thread
implements PSOConstants {
    private static final int HISTORY_SIZE = 1000;
    private static final int MAX_LOGIN = 3;
    private static final int SSL_STD_PORT = 443;
    private Hashtable<String, Calendar> startActionTimeTable = new Hashtable();
    private String adressProxy = PSEnvironment.getPSClientProperty("PS.Proxy.URL");
    private String portProxy = PSEnvironment.getPSClientProperty("PS.Proxy.Port");
    private static Properties prpConversion = null;
    private static File fileConversion = null;
    private volatile boolean Running = false;
    private Vector<String> toSend = new Vector(10);
    private PSO pso;
    private URL url;
    private String UrlString;
    private URLConnection urlcon;
    private int QueryIndex = 0;
    private int[] History = new int[1000];
    private BufferedReader in;
    private PrintWriter out;
    private int versuchzahl = 0;
    private boolean useSSL = PSEnvironment.getIntValue(PSEnvironment.getPSClientProperty("PS.SSL")) == 1;
    String Data;
    private static Hashtable<String, String> actionsOut;
    private int maxpage_vs = 0;
    private int actpage_vs = 0;
    private int maxpage_zg = 0;
    private int actpage_zg = 0;
    RegForm regform;
    StringTokenizer t;
    private String lerror = "";
    private String sessionID = "";
    private String encodedLogin = "";

    public ServerConnection(String IP, String Port, String servlet, PSO value) {
        this.initActionTable();
        this.pso = value;
        try {
            this.createConnection(IP, Port, servlet);
        }
        catch (MalformedURLException mfe) {
            mfe.getMessage();
        }
        catch (Exception ioe) {
            ioe.getMessage();
            Logger logger = Logger.getLogger("ServerConntection");
            logger.log(Level.WARNING, "Error in constructor", ioe);
            if (PSEnvironment.isMacOSPlatform()) {
                PSO.intro.dispose();
            }
            PSOProgramOptions ppo = new PSOProgramOptions((Frame)this.pso, true, true);
            ppo.setVisible(true);
        }
        this.History[1] = -1;
        this.setName("SocketListener");
        PSO.logoAnimation.startAnim(value);
        this.start();
    }

    private void createConnection(String IP, String Port, String servlet) throws MalformedURLException, IOException {
        boolean useProxy = false;
        boolean useBlowfish = PSEnvironment.getPSClientProperty("PS.UseBF", "0").equals("1");
        if (PSEnvironment.getPSClientProperty("PS.UseProxy", "0").equals("1")) {
            String autoProxyUrl = PSEnvironment.getPSClientProperty("PS.Proxy.AutoScriptURL", "");
            if (autoProxyUrl.length() == 0) {
                Properties prop = System.getProperties();
                prop.put("http.proxyHost", this.adressProxy);
                prop.put("http.proxyPort", this.portProxy);
                prop.put("http.proxySet", "true");
                prop.put("https.proxyHost", this.adressProxy);
                prop.put("https.proxyPort", this.portProxy);
                prop.put("https.proxySet", "true");
                useProxy = true;
                if (PSEnvironment.getIntValue(PSEnvironment.getPSClientProperty("PS.UseProxyAuth")) == 1) {
                    String proxyLogin = String.valueOf(Crypt.simpleTextDecryption(PSEnvironment.getPSClientProperty("PS.Proxy.Auth.Login"))) + ":" + Crypt.simpleTextDecryption(PSEnvironment.getPSClientProperty("PS.Proxy.Auth.Pass"));
                    this.encodedLogin = new String(Base64.encode((byte[])proxyLogin.getBytes("ISO8859_1")), "ISO8859_1");
                }
            } else {
                AutoProxyHelper.getAutomaticProxy(autoProxyUrl);
            }
        }
        if (this.useSSL) {
            Properties sysProps = System.getProperties();
            System.setProperties(sysProps);
            this.UrlString = "https://" + IP + ":" + 443 + "/" + servlet;
            HostnameVerifier hv = new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostName, SSLSession session) {
                    if (!urlHostName.equals(session.getPeerHost()) && PSEnvironment.DEBUG) {
                        System.out.println("Warning: URL Host: " + urlHostName + " vs. " + session.getPeerHost());
                    }
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
        } else {
            this.UrlString = "http://" + IP + ":" + Port + "/" + servlet;
        }
        this.url = new URL(this.UrlString);
        this.urlcon = this.url.openConnection();
        if (this.encodedLogin.length() > 0) {
            this.urlcon.setRequestProperty("Proxy-Authorization", "Basic " + this.encodedLogin);
        }
        this.in = new BufferedReader(new InputStreamReader(this.urlcon.getInputStream()));
        if (!this.useSSL && useBlowfish) {
            this.SendMessage(10001, "");
        } else {
            this.SendMessage(239, " ");
            this.SendMessage(45, PSEnvironment.getPSVersionProperty("PS.Client.Version"));
        }
    }

    public synchronized void getOrderData() {
        this.SendMessage(212, " ");
        this.SendMessage(278, " ");
        if (this.pso.AE.getGewicht() >= 0) {
            this.SendMessage(213, " ");
        }
    }

    public int getPendingRequestCnt() {
        return this.toSend.size() + 1;
    }

    public synchronized void getOrderInfo() {
        this.SendMessage(214, " ");
        this.SendMessage(215, " ");
        this.SendMessage(211, " ");
        this.SendMessage(260, " ");
    }

    public synchronized void getAMInfos() {
        this.SendMessage(357, " ");
        this.SendMessage(361, " ");
    }

    public synchronized void SendMessage(int objcode, String value) {
        this.pso.restartSessionTimeoutTimer();
        if (PSO.ConnTimer != null) {
            PSO.ConnTimer.restart();
        }
        ++this.QueryIndex;
        if (this.QueryIndex > 999) {
            this.QueryIndex = 1;
            this.resetStartActionTable(-1);
        }
        this.History[this.QueryIndex] = objcode;
        String plaintext = "";
        if (objcode == 239) {
            this.startActionTimeTable.put("" + objcode, Calendar.getInstance());
        }
        if (objcode == 10) {
            this.startActionTimeTable.put("" + objcode, Calendar.getInstance());
        }
        if (objcode == 78) {
            this.startActionTimeTable.put("" + objcode, Calendar.getInstance());
        }
        this.pso.AuftragAutoSaved = objcode == 321 || objcode == 997;
        PsoXmlBuilder xmlRequest = new PsoXmlBuilder();
        xmlRequest.setAction(objcode);
        xmlRequest.setActionType(actionsOut.get("" + objcode));
        xmlRequest.setActionIndex(this.QueryIndex);
        xmlRequest.setDatenCoded(false);
        xmlRequest.setResponse(1001);
        xmlRequest.setCurrentRow(0);
        xmlRequest.setFetchSize(0);
        switch (objcode) {
            case 46: 
            case 55: 
            case 73: 
            case 74: 
            case 293: 
            case 334: {
                xmlRequest.setDatenCoded(true);
                try {
                    plaintext = Crypt.encode(value.getBytes("ISO8859_1"));
                }
                catch (UnsupportedEncodingException uee) {
                    plaintext = Crypt.encode(value.getBytes());
                }
                if (!PSEnvironment.DEBUG) break;
                System.out.println(String.valueOf(String.valueOf(objcode)) + " Encryption aktiv");
                break;
            }
            default: {
                plaintext = value;
            }
        }
        xmlRequest.setActionDaten(plaintext);
        if (PSEnvironment.DEBUG) {
            System.out.println("Send Request : ");
        }
        if (PSEnvironment.DEBUG) {
            System.out.println(" Action =" + xmlRequest.getAction());
        }
        if (PSEnvironment.DEBUG) {
            System.out.println(" ActionIndex =" + xmlRequest.getActionIndex());
        }
        if (PSEnvironment.DEBUG) {
            System.out.println(" ActionType =" + actionsOut.get("" + objcode));
        }
        if (PSEnvironment.DEBUG) {
            System.out.println(" ActionDaten =" + xmlRequest.getActionDaten());
        }
        try {
            plaintext = xmlRequest.createXmlDoc();
        }
        catch (Exception exp) {
            plaintext = " xmlRequest wurde nicht erzeugt";
        }
        this.toSend.addElement(plaintext);
        if (PSEnvironment.DEBUG) {
            System.out.println("toSend add : -> " + this.debugXML(xmlRequest));
        }
        if (!this.Running) {
            if (PSEnvironment.DEBUG) {
                System.out.println("running : -> " + this.debugXML(xmlRequest));
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PSO.logoAnimation.restart();
                    ServerConnection.this.pso.setWaitCursorVisible(true);
                    if (((ServerConnection)ServerConnection.this).pso.progress_bar7 != null) {
                        ((ServerConnection)ServerConnection.this).pso.progress_bar7.setValue(0);
                    }
                }
            });
            this.Running = true;
            PSEnvironment.ServerActive = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (true) {
                Document line;
                try {
                    ServerConnection serverConnection = this;
                    synchronized (serverConnection) {
                        if (this.toSend.size() == 0) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    PSO.logoAnimation.stop();
                                    ServerConnection.this.pso.setWaitCursorVisible(false);
                                    if (((ServerConnection)ServerConnection.this).pso.progress_bar7 != null) {
                                        ((ServerConnection)ServerConnection.this).pso.progress_bar7.setValue(0);
                                    }
                                }
                            });
                            PSEnvironment.ServerActive = false;
                            this.Running = false;
                            if (PSEnvironment.DEBUG) {
                                System.out.println("angehalten");
                            }
                            while (!this.Running) {
                                try {
                                    if (PSEnvironment.DEBUG) {
                                        System.out.println("communication thread waiting for new requests...");
                                    }
                                    this.wait();
                                }
                                catch (InterruptedException iEx) {
                                    iEx.printStackTrace();
                                }
                                if (!PSEnvironment.DEBUG) continue;
                                System.out.println("leaving wait loop...");
                            }
                        }
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
                if (PSEnvironment.DEBUG) {
                    System.out.println("gesendet");
                }
                String sender = this.toSend.elementAt(0);
                this.toSend.removeElementAt(0);
                if (PSEnvironment.DEBUG) {
                    System.out.println("-->Server (Remaining: " + (this.toSend.size() + 1) + "): ");
                }
                if ((line = this.sendRequest(sender)) == null) {
                    throw new IOException("Exception in http connection");
                }
                PsoXmlBuilder xmlResponse = new PsoXmlBuilder(line);
                int ResponseID = xmlResponse.getAction();
                int Response = xmlResponse.getResponse();
                int ActionIndex = xmlResponse.getActionIndex();
                this.Data = xmlResponse.getActionDaten();
                if (PSEnvironment.DEBUG) {
                    System.out.println(" Action =" + ResponseID);
                }
                if (PSEnvironment.DEBUG) {
                    System.out.println(" Action Type =" + xmlResponse.getActionType());
                }
                if (PSEnvironment.DEBUG) {
                    System.out.println(" Response =" + Response);
                }
                if (PSEnvironment.DEBUG) {
                    System.out.println(" Action Data =" + this.Data);
                }
                if (this.startActionTimeTable.get("" + ResponseID) != null) {
                    PSEnvironment.setActionDuration(ResponseID, this.startActionTimeTable.get("" + ResponseID), Calendar.getInstance());
                    this.startActionTimeTable.remove("" + ResponseID);
                    if (PSEnvironment.DEBUG) {
                        System.out.println(" Action " + ResponseID + " Dauer =" + PSEnvironment.getActionDuration(ResponseID) + " Millisekunden");
                    }
                }
                if (Response != 1000) {
                    if (this.pso.progress_bar7 != null) {
                        this.pso.progress_bar7.setValue(100);
                    }
                    switch (ResponseID) {
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection.this.pso.InitTabSelection(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 10001: {
                            if (!this.useSSL) {
                                Crypt.init(this.Data);
                                this.SendMessage(239, " ");
                                this.SendMessage(45, PSEnvironment.getPSVersionProperty("PS.Client.Version"));
                                break;
                            }
                            Crypt.storeNewCert(this.Data);
                            this.createConnection(PSEnvironment.getPSClientProperty("PS.Server.IP"), PSEnvironment.getPSClientProperty("PS.Server.Port"), PSEnvironment.getPSClientProperty("PS.Server.Servlet"));
                            break;
                        }
                        case 329: {
                            String[] strArray = PSEnvironment.tokenStringToStringArray(this.Data, "|");
                            this.pso.AE.ekpVerified(PSEnvironment.getIntValue(strArray[0], 0) == 1, PSEnvironment.getIntValue(strArray[1], 0));
                            break;
                        }
                        case 66: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.auftragsManager.YoCheckName(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 73: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    if (ServerConnection.this.Data.trim().length() > 0 && PSEnvironment.getIntValue(ServerConnection.this.Data) == 2000) {
                                        Feedback.showMessage(ServerConnection.this.pso, 2000);
                                        PSUser.setVollversion(true);
                                        ServerConnection.this.pso.setAuswahlModusEnabled(0, true);
                                        ServerConnection.this.pso.setAuswahlModusEnabled(1, true);
                                        ServerConnection.this.pso.setAuswahlModusEnabled(5, true);
                                    }
                                    ServerConnection.this.regform.enableRightButton();
                                }
                            });
                            break;
                        }
                        case 44: {
                            this.maxpage_vs = 0;
                            this.actpage_vs = 0;
                            break;
                        }
                        case 53: {
                            this.maxpage_zg = 0;
                            this.actpage_zg = 0;
                            break;
                        }
                        case 67: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.auftragsManager.YoDeleteAuftrag(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 999: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection.this.pso.disposeValidated();
                                }
                            });
                            break;
                        }
                        case 71: 
                        case 72: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection.this.pso.YoChangeSelection(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 346: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection.this.pso.YoRelease(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 347: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection.this.pso.YoInvitation(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 202: 
                        case 207: 
                        case 208: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection.this.pso.YoTableAuswahl(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 284: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.txtBezeichnung.setText(ServerConnection.this.Data.trim());
                                    PSAuftrag.setJobName(ServerConnection.this.Data.trim());
                                    ServerConnection.this.pso.setWindowTitle(ServerConnection.this.Data.trim());
                                }
                            });
                            break;
                        }
                        case 270: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    if (ServerConnection.this.Data.trim().equals("1")) {
                                        ((ServerConnection)ServerConnection.this).pso.AE.abs_gleich.setSelected(true);
                                    } else {
                                        ((ServerConnection)ServerConnection.this).pso.AE.abs_gleich.setSelected(false);
                                        ServerConnection.this.SendMessage(225, " ");
                                    }
                                }
                            });
                            break;
                        }
                        case 216: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.setAbsender(ServerConnection.this.Data.trim());
                                }
                            });
                            break;
                        }
                        case 225: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.setEinlieferer(ServerConnection.this.Data.trim());
                                }
                            });
                            break;
                        }
                        case 332: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.setAbwZahlungspflichtiger(ServerConnection.this.Data.trim());
                                }
                            });
                            break;
                        }
                        case 2221: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.setOrtByPLZ(ServerConnection.this.Data.trim());
                                }
                            });
                            break;
                        }
                        case 2311: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.setEinliefererOrt(ServerConnection.this.Data.trim());
                                }
                            });
                            break;
                        }
                        case 255: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    AKManager.YoAK(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 257: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.mapOptions.YoAKData(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 256: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    AKManager.YoAKInfo(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 276: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    AKManager.YoAKVersion(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 272: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.setAnnahmestelle(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 278: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.YoAnnahmeInfo(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 271: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.YoAnnahmeModus(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 203: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.TAnnahme.setData(ServerConnection.this.Data);
                                    ((ServerConnection)ServerConnection.this).pso.AE.selectFirstAnnahmestelle();
                                }
                            });
                            break;
                        }
                        case 371: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.setAbholung(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 268: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection.this.pso.InitTabSelection(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 205: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.setAnzahlVE(ServerConnection.this.Data);
                                    ((ServerConnection)ServerConnection.this).pso.AE.checkKKAuftrag();
                                }
                            });
                            break;
                        }
                        case 211: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.setVerteilstellen(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 251: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.alleform.druckenproperty.YoAnzDruckAZVH(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 264: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.auftragsManager.YoJobs(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 465: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.auftragsManager.YoFilterChains(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 467: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.auftragsManager.YoLoadChain(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 470: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.setAbFragmentaion(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 288: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.auftragsManager.YoHistory(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 210: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection.this.pso.YoAuswahl(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 210001: 
                        case 210002: 
                        case 210003: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection.this.pso.YoDataForFrameDetails(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 275: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.detailform.YoDetail(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 201: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.setEinzelEntgelt(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 204: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.setGewicht(ServerConnection.this.Data);
                                    ((ServerConnection)ServerConnection.this).pso.AE.checkKKAuftrag();
                                }
                            });
                            break;
                        }
                        case 336: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    int val = PSEnvironment.getIntValue(ServerConnection.this.Data);
                                    if (val > 1) {
                                        PSEnvironment.setMwstValue(val);
                                        ((ServerConnection)ServerConnection.this).pso.AE.setUseNewMwSt(ServerConnection.this.Data);
                                        ServerConnection.this.SendMessage(455, " ");
                                    }
                                }
                            });
                            break;
                        }
                        case 344: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.setFullZbnOption(Boolean.valueOf(ServerConnection.this.Data));
                                }
                            });
                            break;
                        }
                        case 392: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    boolean flag = ServerConnection.this.Data.trim().equals("1");
                                    PSAuftrag.setZspPackaging(flag);
                                    ((ServerConnection)ServerConnection.this).pso.AE.setZspPackaging(flag);
                                }
                            });
                            break;
                        }
                        case 396: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    boolean flag = ServerConnection.this.Data.trim().equals("1");
                                    PSEnvironment.setGpwsClient(flag);
                                    if (flag) {
                                        PSO.mainpanel.AE.enableGpwsMode();
                                    }
                                }
                            });
                            break;
                        }
                        case 398: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    int value = PSEnvironment.getIntValue(ServerConnection.this.Data.trim());
                                    PSAuftrag.setSalesJobState(value);
                                    if (PSAuftrag.getSalesJobState() == 1 || PSAuftrag.getSalesJobState() == 4) {
                                        int dlgResult = Feedback.showQuestion((Component)ServerConnection.this.pso, 21);
                                        if (dlgResult == 1 || dlgResult == -1) {
                                            ServerConnection.this.pso.newJob();
                                        } else {
                                            if (PSAuftrag.getSalesJobState() == 1) {
                                                ServerConnection.this.SendMessage(452, " ");
                                            }
                                            ServerConnection.this.SendMessage(398, " ");
                                        }
                                    }
                                }
                            });
                            break;
                        }
                        case 450: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    int value = PSEnvironment.getIntValue(ServerConnection.this.Data.trim());
                                    if (value == 1) {
                                        Feedback.showMessage(ServerConnection.this.pso, 59);
                                        ServerConnection.this.pso.newJob();
                                    }
                                }
                            });
                            break;
                        }
                        case 451: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    int value = PSEnvironment.getIntValue(ServerConnection.this.Data.trim());
                                    if (value == 1) {
                                        Feedback.showMessage(ServerConnection.this.pso, 63);
                                        ServerConnection.this.pso.newJob();
                                    }
                                }
                            });
                            break;
                        }
                        case 213: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    StringTokenizer t1 = new StringTokenizer(ServerConnection.this.Data, "|");
                                    ((ServerConnection)ServerConnection.this).pso.l_bar5.setText(t1.nextToken());
                                    if (t1.hasMoreTokens()) {
                                        String bla = t1.nextToken();
                                        PSAuftrag.setAufzahlungAktiv(!bla.equals("0,00"));
                                    }
                                    ServerConnection.this.t = null;
                                }
                            });
                            break;
                        }
                        case 215: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.setEntgeltInfo(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 260: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.setAnzahlGebinde(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 239: {
                            this.pso.updman.Yo_GetInfobox(this.useSSL ? this.Data : Crypt.decode(this.Data));
                            break;
                        }
                        case 374: {
                            boolean enable = PSEnvironment.getIntValue(this.Data, 0) == 1;
                            this.pso.setUndoAvailable(enable);
                            break;
                        }
                        case 361: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.setAM_State(PSEnvironment.getIntValue(ServerConnection.this.Data));
                                }
                            });
                            break;
                        }
                        case 357: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.setAM_ID(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 359: {
                            if (this.Data.trim().length() <= 0) break;
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.setUseAMCertification(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 348: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.setAMError("1| " + ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 349: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.setAMError("2| " + ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 353: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.setAbholTermin(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 390: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.setDeliveryOffset(ServerConnection.this.Data);
                                    ServerConnection.this.SendMessage(454, " ");
                                }
                            });
                        }
                        case 454: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.setStorageEndDate(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 355: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.setZustellTermin(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 367: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    int cnt = PSEnvironment.getIntValue(ServerConnection.this.Data);
                                    boolean flag = cnt > 0;
                                    PSAuftrag.setPaletteDone(flag);
                                    if (flag) {
                                        PSAuftrag.setPaletteCnt(cnt);
                                    }
                                }
                            });
                            break;
                        }
                        case 368: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    if (PSEnvironment.isNumeric(ServerConnection.this.Data)) {
                                        int pageCount = PSEnvironment.getIntValue(ServerConnection.this.Data);
                                        ServerConnection.this.pso.getPsc().newPrintJob(14, pageCount);
                                        int i = 1;
                                        while (i <= pageCount) {
                                            ServerConnection.this.SendMessage(368, String.valueOf(i) + "|90");
                                            ++i;
                                        }
                                    } else {
                                        int page = PSEnvironment.getIntValue(ServerConnection.this.Data.substring(0, ServerConnection.this.Data.indexOf("|")));
                                        if (page == ((ServerConnection)ServerConnection.this).pso.getPsc().getCurrentJob().pageCnt && PSAuftrag.getStorageEnd() != null) {
                                            ServerConnection.this.pso.getPsc().addJobData(ServerConnection.this.Data, 14);
                                            ServerConnection.this.pso.getPsc().newPrintJob(15, 1);
                                            ServerConnection.this.pso.getPsc().addJobData("", 15);
                                            ServerConnection.this.pso.getPsc().newPrintJob(16, 1);
                                            ServerConnection.this.pso.getPsc().addJobData("", 16);
                                            ServerConnection.this.pso.getPsc().newPrintJob(17, 1);
                                            ServerConnection.this.pso.getPsc().addJobData("", 17);
                                            ServerConnection.this.pso.getPsc().newPrintJob(18, 1);
                                            ServerConnection.this.pso.getPsc().addJobData("", 18);
                                            ServerConnection.this.pso.getPsc().newPrintJob(19, 1);
                                            ServerConnection.this.pso.getPsc().addJobData("", 19);
                                        } else {
                                            ServerConnection.this.pso.getPsc().addJobData(ServerConnection.this.Data, 14);
                                        }
                                    }
                                }
                            });
                            break;
                        }
                        case 455: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        double price = Double.parseDouble(ServerConnection.this.Data);
                                        PrintPaletteStorage.setStoragePrice(price);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                }
                            });
                            break;
                        }
                        case 373: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    AddressManager.loadRecordsServerSide(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 244: 
                        case 245: 
                        case 249: 
                        case 250: 
                        case 254: 
                        case 281: 
                        case 287: 
                        case 312: 
                        case 313: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.infofensterform.YoInformationData(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 238: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.setKontoverbindung(ServerConnection.this.Data.trim());
                                }
                            });
                            break;
                        }
                        case 326: {
                            this.pso.exportDialog.YoRequestData(this.Data);
                            break;
                        }
                        case 274: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection.this.pso.YoMitbenutzer(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 263: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    StringTokenizer t2 = new StringTokenizer(ServerConnection.this.Data, "|");
                                    ((ServerConnection)ServerConnection.this).pso.AE.gesamtentgelt_mwst = t2.nextToken();
                                    ((ServerConnection)ServerConnection.this).pso.AE.gesamtentgelt_dm = t2.nextToken();
                                    ((ServerConnection)ServerConnection.this).pso.AE.gesamtentgelt_euro = t2.nextToken();
                                    t2 = null;
                                }
                            });
                            break;
                        }
                        case 269: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    int result = PSEnvironment.getIntValue(ServerConnection.this.Data);
                                    ServerConnection.this.pso.setModus(result);
                                    if (result != 6) {
                                        ServerConnection.this.SendMessage(268, " ");
                                    }
                                    if (result == 5 || result < 3) {
                                        ServerConnection.this.SendMessage(323, "");
                                    }
                                }
                            });
                            break;
                        }
                        case 323: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    PSAuftrag.setZbnImportWithID(ServerConnection.this.Data.equals("1"));
                                }
                            });
                            break;
                        }
                        case 277: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.frmPalette.YoPalette(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 325: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    if (((ServerConnection)ServerConnection.this).pso.frmPalette == null) {
                                        ((ServerConnection)ServerConnection.this).pso.frmPalette = new frmPalettenoptimierung(ServerConnection.this.pso, PSEnvironment.mainframe, true);
                                    }
                                    ((ServerConnection)ServerConnection.this).pso.frmPalette.YoPrintPalette(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 327: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    if (ServerConnection.this.Data.indexOf("|") == -1) {
                                        int pageCount = PSEnvironment.getIntValue(ServerConnection.this.Data);
                                        ServerConnection.this.pso.getPsc().newPrintJob(12, pageCount);
                                        int i = 1;
                                        while (i <= pageCount) {
                                            ServerConnection.this.SendMessage(327, String.valueOf(i) + "|39");
                                            ++i;
                                        }
                                    } else {
                                        int page = PSEnvironment.getIntValue(ServerConnection.this.Data.substring(0, ServerConnection.this.Data.indexOf("|")));
                                        if (page == ((ServerConnection)ServerConnection.this).pso.getPsc().getCurrentJob().pageCnt && frmPalettenoptimierung.isPrintPalNotificationWhenDone()) {
                                            PSO.cc.SendMessage(368, "0|90");
                                            frmPalettenoptimierung.setPrintPalNotificationWhenDone(false);
                                        }
                                        ServerConnection.this.pso.getPsc().addJobData(ServerConnection.this.Data, 12);
                                    }
                                }
                            });
                            break;
                        }
                        case 460: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    if (ServerConnection.this.Data.indexOf(";") == -1) {
                                        ((ServerConnection)ServerConnection.this).pso.DF.initPaletteDetailsExport(ServerConnection.this.Data);
                                    } else {
                                        ((ServerConnection)ServerConnection.this).pso.DF.addPaletteDetailsData(ServerConnection.this.Data);
                                    }
                                }
                            });
                            break;
                        }
                        case 266: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    int result = PSEnvironment.getIntValue(ServerConnection.this.Data);
                                    ((ServerConnection)ServerConnection.this).pso.AE.optPostwurfAn[result].setSelected(true);
                                    ((ServerConnection)ServerConnection.this).pso.AE.setPostwurfAn(result);
                                }
                            });
                            break;
                        }
                        case 261: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    if (ServerConnection.this.Data.trim().length() > 0) {
                                        if (PSO.Modus == 5 || !PSAuftrag.isZspPackaging() && PSO.Modus < 3) {
                                            ServerConnection.this.pso.getPsc().addJobData(ServerConnection.this.Data, 9);
                                        } else {
                                            ServerConnection.this.pso.getPsc().addJobData(ServerConnection.this.Data, 4);
                                        }
                                    }
                                }
                            });
                            break;
                        }
                        case 262: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.einzelnform.YoPrintEinzeln(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 253: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    if (ServerConnection.this.Data.trim().length() > 0) {
                                        ServerConnection.this.pso.getPsc().addJobData(ServerConnection.this.Data, 5);
                                    }
                                }
                            });
                            break;
                        }
                        case 241: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection serverConnection = ServerConnection.this;
                                    serverConnection.actpage_vs = serverConnection.actpage_vs + 1;
                                    ServerConnection.this.pso.getPsc().addJobData(ServerConnection.this.Data, 2);
                                }
                            });
                            break;
                        }
                        case 252: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection serverConnection = ServerConnection.this;
                                    serverConnection.actpage_zg = serverConnection.actpage_zg + 1;
                                    ServerConnection.this.pso.getPsc().addJobData(ServerConnection.this.Data, 3);
                                }
                            });
                            break;
                        }
                        case 286: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.DiD.YoPrintToFile(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 328: {
                            this.pso.DiD.YoMailSent(this.Data);
                            break;
                        }
                        case 267: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.YoReloadAuftrag(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 265: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.setRundung(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 258: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection.this.pso.YoSelection(ServerConnection.this.Data.trim());
                                }
                            });
                            break;
                        }
                        case 317: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection.this.pso.YoStandorte(ServerConnection.this.Data.trim());
                                }
                            });
                            break;
                        }
                        case 212: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection.this.pso.checkKKZielwahl(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 279: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection.this.pso.getPsc().addJobData(ServerConnection.this.Data, 0);
                                }
                            });
                            break;
                        }
                        case 280: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection.this.pso.getPsc().addJobData(ServerConnection.this.Data, 1);
                                }
                            });
                            break;
                        }
                        case 273: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection.this.pso.getPsc().addJobData(ServerConnection.this.Data, 6);
                                }
                            });
                            break;
                        }
                        case 283: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection.this.pso.getPsc().addJobData(ServerConnection.this.Data, 8);
                                }
                            });
                            break;
                        }
                        case 285: 
                        case 289: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection.this.pso.YoZSPSelection(ServerConnection.this.Data.trim());
                                }
                            });
                            break;
                        }
                        case 214: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.setSumSdgInfo(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 247: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.alleform.YoAlle(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 248: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.alleform.YoAlleV(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 246: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.einzelnform.YoEinzeln(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 206: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.setToleranz(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 209: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection.this.pso.YoTableUnterAuswahl(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 259: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    if (ServerConnection.this.regform != null) {
                                        ServerConnection.this.regform.setData(Crypt.decode(ServerConnection.this.Data));
                                    }
                                }
                            });
                            break;
                        }
                        case 291: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    if (ServerConnection.this.regform != null) {
                                        ServerConnection.this.regform.setMessageCount(PSEnvironment.getIntValue(ServerConnection.this.Data));
                                        ServerConnection.this.regform.setVisible(true);
                                        ServerConnection.this.regform.setFocus();
                                    }
                                }
                            });
                            break;
                        }
                        case 292: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.msgform.setPSOUser(Crypt.decode(ServerConnection.this.Data));
                                }
                            });
                            break;
                        }
                        case 294: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.msgform.FetchMails(Crypt.decode(ServerConnection.this.Data));
                                }
                            });
                            break;
                        }
                        case 296: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.releaseform.setInvitedPSOUser(Crypt.decode(ServerConnection.this.Data));
                                }
                            });
                            break;
                        }
                        case 297: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.releaseform.setJobsforUser(Crypt.decode(ServerConnection.this.Data));
                                }
                            });
                            break;
                        }
                        case 305: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    if (ServerConnection.this.Data.trim().equals("0")) {
                                        ((ServerConnection)ServerConnection.this).pso.AE.setZahlungspflichtiger(0, false);
                                    } else if (ServerConnection.this.Data.trim().equals("1")) {
                                        ((ServerConnection)ServerConnection.this).pso.AE.setZahlungspflichtiger(1, false);
                                    } else if (ServerConnection.this.Data.trim().equals("2")) {
                                        ((ServerConnection)ServerConnection.this).pso.AE.setZahlungspflichtiger(2, false);
                                        ServerConnection.this.SendMessage(332, "");
                                    }
                                }
                            });
                            break;
                        }
                        case 234: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    if (ServerConnection.this.Data.trim().equals("0")) {
                                        ((ServerConnection)ServerConnection.this).pso.AE.setZahlungsweise(0, false);
                                    } else if (ServerConnection.this.Data.trim().equals("1")) {
                                        ((ServerConnection)ServerConnection.this).pso.AE.setZahlungsweise(1, false);
                                    } else if (ServerConnection.this.Data.trim().equals("2")) {
                                        ((ServerConnection)ServerConnection.this).pso.AE.setZahlungsweise(2, false);
                                    }
                                }
                            });
                            break;
                        }
                        case 484: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    PSAuftrag.setActFreiText(ServerConnection.this.Data.trim());
                                }
                            });
                            break;
                        }
                        case 486: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    PSAuftrag.setActFreiTextPalette(ServerConnection.this.Data.trim());
                                }
                            });
                            break;
                        }
                        case 68: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.detailform.InitTableDetail(PSEnvironment.getIntValue(ServerConnection.this.Data));
                                }
                            });
                            break;
                        }
                        case 333: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    if (((ServerConnection)ServerConnection.this).pso.loginform != null) {
                                        ServerConnection.this.regform = ((ServerConnection)ServerConnection.this).pso.loginform.regform;
                                    }
                                    ServerConnection.this.regform.setBranchesAndCountries(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 334: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection.this.regform.yoChangePassword(Crypt.decode(ServerConnection.this.Data));
                                }
                            });
                            break;
                        }
                        case 46: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection.this.t = new StringTokenizer(Crypt.decode(ServerConnection.this.Data), "|");
                                    boolean submitterData = ServerConnection.this.t.countTokens() > 12;
                                    PSUser.setUserID(Long.parseLong(ServerConnection.this.t.nextToken()));
                                    String sErr = PSEnvironment.checkForExitError();
                                    if (sErr != null) {
                                        String[] errValues = PSEnvironment.tokenStringToStringArray(sErr, "|");
                                        ServerConnection.this.SendMessage(95, errValues[0]);
                                        PSEnvironment.printDebugMessage("PSEnvironment", "Message Sent!!");
                                        if (PSEnvironment.getIntValue(errValues[1]) == 1) {
                                            ((ServerConnection)ServerConnection.this).pso.lastSessionError = true;
                                        }
                                    }
                                    PSEnvironment.logExitError(PSEnvironment.PS_EXITERROR_FILE_ENTRY);
                                    try {
                                        ServerConnection.this.url = new URL(String.valueOf(ServerConnection.this.UrlString) + "?uid=" + PSUser.getUserID());
                                    }
                                    catch (MalformedURLException errValues) {
                                        // empty catch block
                                    }
                                    if (PSEnvironment.getIntValue(ServerConnection.this.t.nextToken()) == 0) {
                                        PSUser.setVollversion(false);
                                        ServerConnection.this.pso.setAuswahlModusEnabled(0, false);
                                        ServerConnection.this.pso.setAuswahlModusEnabled(1, false);
                                        ServerConnection.this.pso.setAuswahlModusEnabled(5, false);
                                        if (((ServerConnection)ServerConnection.this).pso.jMenuOnline.getItemCount() == 2) {
                                            ((ServerConnection)ServerConnection.this).pso.jMenuOnline.remove(((ServerConnection)ServerConnection.this).pso.jMenuItemShareJob);
                                        }
                                    } else {
                                        PSUser.setVollversion(true);
                                        ServerConnection.this.pso.setAuswahlModusEnabled(0, true);
                                        ServerConnection.this.pso.setAuswahlModusEnabled(1, true);
                                        ServerConnection.this.pso.setAuswahlModusEnabled(5, true);
                                        if (((ServerConnection)ServerConnection.this).pso.jMenuOnline.getItemCount() == 1) {
                                            ((ServerConnection)ServerConnection.this).pso.jMenuOnline.insert(((ServerConnection)ServerConnection.this).pso.jMenuItemShareJob, 2);
                                        }
                                    }
                                    if (PSEnvironment.getIntValue(ServerConnection.this.t.nextToken()) == 0) {
                                        PSUser.setSaemtlicheHHAktiv(false);
                                        ((ServerConnection)ServerConnection.this).pso.AE.optPostwurfAn[3].setVisible(false);
                                        ((ServerConnection)ServerConnection.this).pso.AE.optPostwurfAn[1].setLocation(20, 40);
                                    } else {
                                        PSUser.setSaemtlicheHHAktiv(true);
                                        ((ServerConnection)ServerConnection.this).pso.AE.optPostwurfAn[3].setVisible(true);
                                        ((ServerConnection)ServerConnection.this).pso.AE.optPostwurfAn[1].setLocation(20, 60);
                                    }
                                    if (PSEnvironment.getIntValue(ServerConnection.this.t.nextToken()) == 0) {
                                        PSUser.setFreitextAktiv(false);
                                    } else {
                                        PSUser.setFreitextAktiv(true);
                                    }
                                    PSUser.setDetailUebersichtAktiv(true);
                                    if (((ServerConnection)ServerConnection.this).pso.jMenuAuftrag.getItemCount() < 5) {
                                        ((ServerConnection)ServerConnection.this).pso.jMenuAuftrag.insertSeparator(4);
                                        ((ServerConnection)ServerConnection.this).pso.jMenuAuftrag.insert(((ServerConnection)ServerConnection.this).pso.jMenuItemDetailuebersicht, 5);
                                    }
                                    ((ServerConnection)ServerConnection.this).pso.cmdDetail.setVisible(true);
                                    if (PSEnvironment.getIntValue(ServerConnection.this.t.nextToken()) == 0) {
                                        PSUser.setStrassenmodusAktiv(false);
                                        ((ServerConnection)ServerConnection.this).pso.cmdModus[2].setVisible(false);
                                        ((ServerConnection)ServerConnection.this).pso.jMenuBearbeiten.remove(((ServerConnection)ServerConnection.this).pso.mnuModus[2]);
                                    } else {
                                        PSUser.setStrassenmodusAktiv(false);
                                        ((ServerConnection)ServerConnection.this).pso.cmdModus[2].setVisible(false);
                                        ((ServerConnection)ServerConnection.this).pso.jMenuBearbeiten.remove(((ServerConnection)ServerConnection.this).pso.mnuModus[2]);
                                    }
                                    if (PSEnvironment.getIntValue(ServerConnection.this.t.nextToken()) != 0) {
                                        PSUser.setDruckInDateiAktiv(true);
                                    } else {
                                        if (((ServerConnection)ServerConnection.this).pso.jMenuDatei.isMenuComponent(((ServerConnection)ServerConnection.this).pso.jMenuItemDiD)) {
                                            ((ServerConnection)ServerConnection.this).pso.jMenuDatei.remove(((ServerConnection)ServerConnection.this).pso.jMenuItemDiD);
                                        }
                                        PSUser.setDruckInDateiAktiv(false);
                                    }
                                    if (PSEnvironment.getIntValue(ServerConnection.this.t.nextToken()) != 0) {
                                        PSUser.setExportTablesAktiv(true);
                                    } else {
                                        if (((ServerConnection)ServerConnection.this).pso.jMenuDatei.isMenuComponent(((ServerConnection)ServerConnection.this).pso.jMenuItemExport)) {
                                            ((ServerConnection)ServerConnection.this).pso.jMenuDatei.remove(((ServerConnection)ServerConnection.this).pso.jMenuItemExport);
                                        }
                                        PSUser.setExportTablesAktiv(false);
                                    }
                                    if (PSEnvironment.getIntValue(ServerConnection.this.t.nextToken()) == 0) {
                                        PSUser.setEAUser(false);
                                        if (((ServerConnection)ServerConnection.this).pso.jMenuDatei.isMenuComponent(((ServerConnection)ServerConnection.this).pso.jmenuItemEAPWS)) {
                                            ((ServerConnection)ServerConnection.this).pso.jMenuDatei.remove(((ServerConnection)ServerConnection.this).pso.jmenuItemEAPWS);
                                        }
                                    }
                                    if (ServerConnection.this.t.hasMoreTokens()) {
                                        if (PSEnvironment.getIntValue(ServerConnection.this.t.nextToken()) != 0) {
                                            ServerConnection.this.pso.setMailActive(true);
                                        } else {
                                            ServerConnection.this.pso.setMailActive(false);
                                        }
                                    }
                                    if (ServerConnection.this.t.hasMoreTokens()) {
                                        if (PSEnvironment.getIntValue(ServerConnection.this.t.nextToken()) == 0) {
                                            ((ServerConnection)ServerConnection.this).pso.AE.enableAMOptions(false);
                                            PSUser.setAMUser(false);
                                            ((ServerConnection)ServerConnection.this).pso.jMenuItemKKAM.setVisible(false);
                                            ((ServerConnection)ServerConnection.this).pso.tbJButtonKKAM.setVisible(false);
                                        } else {
                                            RegForm.disallowEditing(true);
                                        }
                                    }
                                    if (submitterData) {
                                        String submitter = "";
                                        if (ServerConnection.this.t.hasMoreTokens()) {
                                            submitter = String.valueOf(submitter) + ServerConnection.this.t.nextToken() + "|";
                                        }
                                        if (ServerConnection.this.t.hasMoreTokens()) {
                                            submitter = String.valueOf(submitter) + ServerConnection.this.t.nextToken() + "|";
                                        }
                                        if (ServerConnection.this.t.hasMoreTokens()) {
                                            submitter = String.valueOf(submitter) + ServerConnection.this.t.nextToken() + "|";
                                        }
                                        if (ServerConnection.this.t.hasMoreTokens()) {
                                            submitter = String.valueOf(submitter) + ServerConnection.this.t.nextToken() + "|";
                                        }
                                        if (ServerConnection.this.t.hasMoreTokens()) {
                                            submitter = String.valueOf(submitter) + ServerConnection.this.t.nextToken() + "|";
                                        }
                                        if (ServerConnection.this.t.hasMoreTokens()) {
                                            submitter = String.valueOf(submitter) + ServerConnection.this.t.nextToken() + "| |";
                                        }
                                        if (ServerConnection.this.t.hasMoreTokens()) {
                                            submitter = String.valueOf(submitter) + ServerConnection.this.t.nextToken() + "| |";
                                        }
                                        if (ServerConnection.this.t.hasMoreTokens()) {
                                            PSUser.setsubmitterEKP(ServerConnection.this.t.nextToken());
                                            submitter = String.valueOf(submitter) + PSUser.getsubmitterEKP() + "| | |";
                                        }
                                        if (ServerConnection.this.t.hasMoreTokens()) {
                                            PSUser.setsubmitterName(ServerConnection.this.t.nextToken());
                                            submitter = String.valueOf(submitter) + PSUser.getsubmitterName() + "|";
                                        }
                                        if (ServerConnection.this.t.hasMoreTokens()) {
                                            PSUser.setsubmitterPassword(ServerConnection.this.t.nextToken());
                                            submitter = String.valueOf(submitter) + PSUser.getsubmitterPassword() + "|";
                                        }
                                        ServerConnection.this.SendMessage(350, submitter);
                                        ServerConnection.this.SendMessage(359, " ");
                                        ServerConnection.this.SendMessage(394, " ");
                                        if (!PSEnvironment.isGpwsClient()) {
                                            ServerConnection.this.SendMessage(396, " ");
                                        }
                                    }
                                    if (ServerConnection.this.t.hasMoreTokens()) {
                                        int currSessionTimeout = PSEnvironment.getIntValue(ServerConnection.this.t.nextToken());
                                        if (currSessionTimeout > 0) {
                                            ServerConnection.this.pso.setSessionTimeout(currSessionTimeout);
                                        }
                                        if (PSEnvironment.DEBUG) {
                                            System.out.println(" Session-timeout = " + currSessionTimeout);
                                        }
                                    }
                                    if (ServerConnection.this.t.hasMoreTokens()) {
                                        int currRestSessionTimeout = PSEnvironment.getIntValue(ServerConnection.this.t.nextToken());
                                        if (currRestSessionTimeout > 0) {
                                            ServerConnection.this.pso.setRestSessionTimeout(currRestSessionTimeout);
                                        }
                                        if (PSEnvironment.DEBUG) {
                                            System.out.println(" RestSession-timeout = " + currRestSessionTimeout);
                                        }
                                    }
                                    if (ServerConnection.this.t.hasMoreTokens()) {
                                        WebMapPanel.setMapAccessKey(ServerConnection.this.t.nextToken());
                                    }
                                    ServerConnection.this.SendMessage(336, " ");
                                    String packOption = PSEnvironment.getPSClientProperty("PS.ZSPP", "0");
                                    ((ServerConnection)ServerConnection.this).pso.AE.setZspPackaging(packOption.equals("1"));
                                    PSO.cc.SendMessage(391, packOption);
                                    ServerConnection.this.t = null;
                                    ((ServerConnection)ServerConnection.this).pso.loginform.dispose();
                                    ((ServerConnection)ServerConnection.this).pso.loginform = null;
                                    ServerConnection.this.regform = new RegForm(ServerConnection.this.pso, 1);
                                }
                            });
                            break;
                        }
                        case 394: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    String[] values = ServerConnection.this.Data.split("\\|");
                                    PSUser.setsubmitterEKP(values[0]);
                                    if (values.length == 3) {
                                        PSUser.setsubmitterName(values[1]);
                                        PSUser.setsubmitterPassword(values[2]);
                                    }
                                }
                            });
                            break;
                        }
                        case 75: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.frmPalette.YoInitPalette(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 54: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.alleform.InitTableAlle(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 50: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.einzelnform.InitTableEinzeln(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 43: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection.this.maxpage_vs = PSEnvironment.getIntValue(ServerConnection.this.Data);
                                    ServerConnection.this.pso.getPsc().newPrintJob(2, ServerConnection.this.maxpage_vs);
                                    ServerConnection.this.actpage_vs = 0;
                                    int i = 0;
                                    while (i < ServerConnection.this.maxpage_vs) {
                                        ServerConnection.this.SendMessage(241, String.valueOf(i + 1));
                                        ++i;
                                    }
                                    ServerConnection.this.SendMessage(44, " ");
                                }
                            });
                            break;
                        }
                        case 52: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection.this.maxpage_zg = PSEnvironment.getIntValue(ServerConnection.this.Data);
                                    ServerConnection.this.pso.getPsc().newPrintJob(3, ServerConnection.this.maxpage_zg);
                                    ServerConnection.this.actpage_zg = 0;
                                    int i = 0;
                                    while (i < ServerConnection.this.maxpage_zg) {
                                        ServerConnection.this.SendMessage(252, String.valueOf(i + 1));
                                        ++i;
                                    }
                                    ServerConnection.this.SendMessage(53, " ");
                                }
                            });
                            break;
                        }
                        case 541: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.alleform.InitTableAlle(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 45: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.updman.setDownloadModus(false, ServerConnection.this.useSSL ? ServerConnection.this.Data : Crypt.decode(ServerConnection.this.Data));
                                }
                            });
                            break;
                        }
                        case 9: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.InitAnnahmeStellen(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 376: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.DF.yoDepots(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 8: 
                        case 10: 
                        case 11: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection.this.pso.InitTabAuswahl(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 13: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection.this.pso.InitTabUnterAuswahl(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 337: {
                            if (RegForm.dlgStartup == null) break;
                            RegForm.dlgStartup.setLastJobProperties(this.Data);
                            break;
                        }
                        case 369: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.DF.updateJobStats(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 64: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.txtAnzahlVE.setTag(0);
                                    ServerConnection.this.SendMessage(284, " ");
                                    ServerConnection.this.SendMessage(204, " ");
                                    ServerConnection.this.SendMessage(201, " ");
                                    ServerConnection.this.SendMessage(205, " ");
                                    ServerConnection.this.SendMessage(206, " ");
                                    ServerConnection.this.SendMessage(265, " ");
                                    ServerConnection.this.SendMessage(266, " ");
                                    ServerConnection.this.SendMessage(267, " ");
                                    ServerConnection.this.SendMessage(216, " ");
                                    ServerConnection.this.SendMessage(270, " ");
                                    ServerConnection.this.SendMessage(305, " ");
                                    ServerConnection.this.SendMessage(234, " ");
                                    ServerConnection.this.SendMessage(238, " ");
                                    ServerConnection.this.SendMessage(269, " ");
                                    ServerConnection.this.SendMessage(271, " ");
                                    ServerConnection.this.SendMessage(274, " ");
                                    ServerConnection.this.SendMessage(272, " ");
                                    ServerConnection.this.SendMessage(371, " ");
                                    ServerConnection.this.SendMessage(484, " ");
                                    ServerConnection.this.SendMessage(486, " ");
                                    ServerConnection.this.SendMessage(336, " ");
                                    ServerConnection.this.SendMessage(385, " ");
                                    ServerConnection.this.SendMessage(388, " ");
                                    PSO.workTabs.setSelectedIndex(0);
                                    ((ServerConnection)ServerConnection.this).pso.AE.setInitializationState();
                                    ServerConnection.this.SendMessage(344, " ");
                                    ServerConnection.this.SendMessage(392, " ");
                                    ServerConnection.this.getAMInfos();
                                    ServerConnection.this.SendMessage(353, " ");
                                    ServerConnection.this.SendMessage(390, " ");
                                    ServerConnection.this.SendMessage(470, "");
                                    ServerConnection.this.SendMessage(290, "1");
                                }
                            });
                            break;
                        }
                        case 362: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    StringTokenizer t = new StringTokenizer(ServerConnection.this.Data, "|");
                                    if (t.countTokens() > 1) {
                                        PSAuftrag.addTA(t.nextToken());
                                        ServerConnection.this.Data = t.nextToken();
                                    }
                                    PSAuftrag.setCurrentJobID(ServerConnection.this.Data);
                                    PSAuftrag.addTA(ServerConnection.this.Data);
                                    ServerConnection.this.pso.setActuellFilename(String.valueOf(PSAuftrag.getMainJobName()) + " " + PSEnvironment.Format(PSAuftrag.getNumTAs(), "00") + ". Teilauftrag");
                                    ServerConnection.this.pso.setModus(PSO.Modus);
                                    ServerConnection.this.pso.restartSubModus();
                                    ServerConnection.this.pso.updateTAButton();
                                }
                            });
                            break;
                        }
                        case 290: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    if (ServerConnection.this.Data.equals("1")) {
                                        ServerConnection.this.pso.YoAuftragLoaded();
                                    }
                                    if (PSEnvironment.isGpwsClient()) {
                                        ServerConnection.this.SendMessage(398, " ");
                                    }
                                }
                            });
                            break;
                        }
                        case 77: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection.this.pso.stopSessionTimeoutTimer();
                                    ServerConnection.this.pso.doInit();
                                }
                            });
                            break;
                        }
                        case 78: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    if (PSEnvironment.DEBUG) {
                                        System.out.println("Version OK!");
                                    }
                                    String versions = ServerConnection.this.useSSL ? ServerConnection.this.Data : Crypt.decode(ServerConnection.this.Data);
                                    PSEnvironment.DB_HOUSEHOLDS = PSEnvironment.getToken(versions, 1);
                                    PSEnvironment.DB_POBOXES = PSEnvironment.getToken(versions, 2);
                                    PSEnvironment.DB_POSTAL_REGULATIONS = PSEnvironment.getToken(versions, 3);
                                    PSEnvironment.DB_ACCEPTANCE_OFFICES = PSEnvironment.getToken(versions, 4);
                                    ServerConnection.this.pso.startSessionTimeoutTimer();
                                    ((ServerConnection)ServerConnection.this).pso.AuftragSaved = true;
                                }
                            });
                            break;
                        }
                        case 306: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection.this.SendMessage(999, " ");
                                }
                            });
                            break;
                        }
                        case 55: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    Feedback.showMessage(ServerConnection.this.pso, 18);
                                    ((ServerConnection)ServerConnection.this).pso.loginform.regform.dispose();
                                    ((ServerConnection)ServerConnection.this).pso.loginform.cmdReg.setEnabled(true);
                                    ((ServerConnection)ServerConnection.this).pso.loginform.setVisible(true);
                                    ((ServerConnection)ServerConnection.this).pso.loginform.toFront();
                                    ((ServerConnection)ServerConnection.this).pso.loginform.txtName.requestFocus();
                                }
                            });
                            break;
                        }
                        case 314: {
                            if (this.Data.trim().length() <= 0) break;
                            this.startActionTimeTable.put("314", Calendar.getInstance());
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ZbnDataHandler.getInstance(false).addZBNDirect(ServerConnection.this.Data, true);
                                }
                            });
                            break;
                        }
                        case 79: 
                        case 318: {
                            if (this.Data.trim().length() <= 0) break;
                            this.startActionTimeTable.put("79", Calendar.getInstance());
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ZbnDataHandler.getInstance(false).addData(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 341: 
                        case 342: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    if (((ServerConnection)ServerConnection.this).pso.dlgTxtImport != null) {
                                        ((ServerConnection)ServerConnection.this).pso.dlgTxtImport.addErrors(ServerConnection.this.Data);
                                    } else {
                                        PSJobImporterFactory.incrementProgress(ServerConnection.this.Data);
                                    }
                                }
                            });
                            break;
                        }
                        case 363: 
                        case 364: 
                        case 365: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    PSJobImporterFactory.incrementProgress(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 366: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection.this.pso.markSearchedOrt(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 63: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AuftragSaved = true;
                                    if (ServerConnection.this.Data.trim().length() > 0) {
                                        PSAuftrag.setCurrentJobID(ServerConnection.this.Data.trim());
                                    }
                                }
                            });
                            break;
                        }
                        case 65: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AuftragSaved = true;
                                    ServerConnection.this.SendMessage(357, " ");
                                    ServerConnection.this.SendMessage(361, " ");
                                    if (ServerConnection.this.Data.trim().length() > 0) {
                                        PSAuftrag.setCurrentJobID(ServerConnection.this.Data.trim());
                                    }
                                }
                            });
                            break;
                        }
                        case 321: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AuftragAutoSaved = true;
                                }
                            });
                            break;
                        }
                        case 81: {
                            PSO.cc.SendMessage(264, " ");
                            this.pso.auftragsManager.toggleButtons();
                            break;
                        }
                        case 5: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AuftragSaved = false;
                                    ((ServerConnection)ServerConnection.this).pso.AE.checkKKAnnahme();
                                }
                            });
                            break;
                        }
                        case 4: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AuftragSaved = false;
                                    ((ServerConnection)ServerConnection.this).pso.AE.checkKKAuftrag();
                                    ServerConnection.this.getOrderData();
                                }
                            });
                            break;
                        }
                        case 3: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AuftragSaved = false;
                                    ((ServerConnection)ServerConnection.this).pso.AE.checkKKAuftrag();
                                    ServerConnection.this.SendMessage(201, " ");
                                    ServerConnection.this.getOrderData();
                                }
                            });
                            break;
                        }
                        case 70: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection.this.pso.YoSetMitbenutzer();
                                }
                            });
                            break;
                        }
                        case 6: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection.this.getOrderData();
                                }
                            });
                            break;
                        }
                        case 1: 
                        case 7: 
                        case 57: 
                        case 58: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AuftragSaved = false;
                                    ServerConnection.this.getOrderData();
                                }
                            });
                            break;
                        }
                        case 49: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                }
                            });
                            break;
                        }
                        case 481: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.alleform.initHintereindander();
                                }
                            });
                            break;
                        }
                        case 482: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.alleform.initStapel();
                                }
                            });
                            break;
                        }
                        case 998: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection.this.resetServerCon();
                                }
                            });
                            break;
                        }
                        case 322: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    if (ServerConnection.this.Data.trim().length() > 0) {
                                        ZbnDataHandler.getInstance(false).setZbnHHSum(ServerConnection.this.Data);
                                    }
                                }
                            });
                            break;
                        }
                        case 343: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConnection.this.SendMessage(212, " ");
                                    ServerConnection.this.SendMessage(213, " ");
                                }
                            });
                            break;
                        }
                        case 74: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.loginform.mailRecieved();
                                }
                            });
                            break;
                        }
                        case 997: {
                            if (!PSEnvironment.DEBUG) break;
                            Calendar rightNow = Calendar.getInstance();
                            if (!PSEnvironment.DEBUG) break;
                            System.out.println("keeping Connection " + rightNow.getTime().toString());
                            break;
                        }
                        case 319: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    if (ServerConnection.this.Data.trim().length() > 0) {
                                        ((ServerConnection)ServerConnection.this).pso.mergeJobs.fillSourceList(ServerConnection.this.Data);
                                    }
                                }
                            });
                            break;
                        }
                        case 320: {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ((ServerConnection)ServerConnection.this).pso.AE.txtAnzahlVE.setTag(0);
                                    PSAuftrag.setCurrentJobID(ServerConnection.this.Data);
                                    ServerConnection.this.SendMessage(204, " ");
                                    ServerConnection.this.SendMessage(201, " ");
                                    ServerConnection.this.SendMessage(205, " ");
                                    ServerConnection.this.SendMessage(206, " ");
                                    ServerConnection.this.SendMessage(265, " ");
                                    ServerConnection.this.SendMessage(385, "");
                                    ServerConnection.this.SendMessage(266, " ");
                                    ServerConnection.this.SendMessage(267, " ");
                                    ServerConnection.this.SendMessage(392, " ");
                                    ServerConnection.this.SendMessage(216, " ");
                                    ServerConnection.this.SendMessage(270, " ");
                                    ServerConnection.this.SendMessage(305, " ");
                                    ServerConnection.this.SendMessage(234, " ");
                                    ServerConnection.this.SendMessage(238, " ");
                                    ServerConnection.this.SendMessage(269, " ");
                                    ServerConnection.this.SendMessage(271, " ");
                                    ServerConnection.this.SendMessage(274, " ");
                                    ServerConnection.this.SendMessage(272, " ");
                                    ServerConnection.this.SendMessage(371, " ");
                                    ServerConnection.this.getAMInfos();
                                    ServerConnection.this.SendMessage(353, " ");
                                    ServerConnection.this.SendMessage(284, " ");
                                    PSO.workTabs.setSelectedIndex(0);
                                    ((ServerConnection)ServerConnection.this).pso.AE.setInitializationState();
                                }
                            });
                            break;
                        }
                        case 379: {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (ServerConnection.this.Data.trim().length() > 0) {
                                        System.out.println("boolean: " + ServerConnection.this.Data);
                                        PSEnvironment.setSepaActive(Boolean.parseBoolean(ServerConnection.this.Data));
                                    }
                                }
                            });
                            break;
                        }
                        case 381: {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    PSO.mainpanel.AE.processSEPAConversionResponse(ServerConnection.this.Data, false);
                                }
                            });
                            break;
                        }
                        case 380: {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    PSO.mainpanel.AE.processSEPAConversionResponse(ServerConnection.this.Data, true);
                                }
                            });
                            break;
                        }
                        case 382: {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    PSO.mainpanel.AE.getDlgBS().setSearchResponse(ServerConnection.this.Data);
                                }
                            });
                            break;
                        }
                        case 383: {
                            final String unconvertable = this.Data;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (!unconvertable.equals("shown")) {
                                        DlgUnconvertableBankData dlgUbd = new DlgUnconvertableBankData();
                                        dlgUbd.setResponse(unconvertable);
                                        dlgUbd.setVisible(true);
                                    }
                                }
                            });
                            break;
                        }
                        case 462: {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    PSEnvironment.setAmMandatoryLimit(PSEnvironment.getIntValue(ServerConnection.this.Data));
                                    ((ServerConnection)ServerConnection.this).pso.AE.updateAmMandatoryLabel();
                                }
                            });
                            break;
                        }
                        case 463: {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    boolean error = ServerConnection.this.Data.equals("1");
                                    PSEnvironment.setAmIoError(error);
                                    if (error) {
                                        Feedback.showMessage(ServerConnection.this.pso, 71);
                                    }
                                }
                            });
                            break;
                        }
                        case 464: {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    boolean cost = ServerConnection.this.Data.equals("1");
                                    PSEnvironment.setHasAbholCost(cost);
                                }
                            });
                        }
                    }
                    continue;
                }
                switch (ResponseID) {
                    case 777: {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                ServerConnection.this.pso.noDbConnection();
                            }
                        });
                        break;
                    }
                    case 18: {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                if (PSEnvironment.getIntValue(ServerConnection.this.Data) > 0) {
                                    ServerConnection.this.pso.InitTabSelection(ServerConnection.this.Data);
                                }
                                Feedback.showMessage(ServerConnection.this.pso, 5004);
                            }
                        });
                        break;
                    }
                    case 78: {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                block4: {
                                    String versions = ServerConnection.this.useSSL ? ServerConnection.this.Data : Crypt.decode(ServerConnection.this.Data);
                                    PSEnvironment.DB_HOUSEHOLDS = PSEnvironment.getToken(versions, 1);
                                    PSEnvironment.DB_POBOXES = PSEnvironment.getToken(versions, 2);
                                    PSEnvironment.DB_POSTAL_REGULATIONS = PSEnvironment.getToken(versions, 3);
                                    PSEnvironment.DB_ACCEPTANCE_OFFICES = PSEnvironment.getToken(versions, 4);
                                    if (Feedback.showQuestion((Component)ServerConnection.this.pso, 24) == 0) {
                                        try {
                                            String url = PSEnvironment.getToken(versions, 5);
                                            if (url.trim().length() == 0) {
                                                url = "https://www.deutschepost.de/de/p/print-mailing/postaktuell-manager.html";
                                            }
                                            BrowserLauncher.openURL(url);
                                        }
                                        catch (IOException e) {
                                            if (!PSEnvironment.DEBUG) break block4;
                                            e.printStackTrace();
                                        }
                                    }
                                }
                            }
                        });
                        break;
                    }
                    case 326: {
                        this.pso.exportDialog.YoRequestData(this.Data);
                        break;
                    }
                    case 328: {
                        this.pso.DiD.YoMailSent(this.Data);
                        break;
                    }
                    case 73: {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                Feedback.showMessage(ServerConnection.this.pso, PSEnvironment.getIntValue(ServerConnection.this.Data));
                                ServerConnection.this.SendMessage(259, " ");
                                ServerConnection.this.regform.enableRightButton();
                            }
                        });
                        break;
                    }
                    case 45: {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                ((ServerConnection)ServerConnection.this).pso.updman.setDownloadModus(true, ServerConnection.this.useSSL ? ServerConnection.this.Data : Crypt.decode(ServerConnection.this.Data));
                            }
                        });
                        break;
                    }
                    case 68: {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                Feedback.showMessage(ServerConnection.this.pso, PSEnvironment.getIntValue(ServerConnection.this.Data));
                                ((ServerConnection)ServerConnection.this).pso.detailform.InitTableDetail(200);
                            }
                        });
                        break;
                    }
                    case 46: {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                int retVal = PSEnvironment.getIntValue(ServerConnection.this.Data, 0);
                                if (retVal > 0) {
                                    Feedback.showMessage(ServerConnection.this.pso, retVal);
                                    PSEnvironment.ServerActive = false;
                                    ((ServerConnection)ServerConnection.this).pso.loginform.dispose();
                                    ServerConnection.this.pso.dispose();
                                    System.exit(0);
                                }
                                ServerConnection serverConnection = ServerConnection.this;
                                serverConnection.versuchzahl = serverConnection.versuchzahl + 1;
                                if (ServerConnection.this.versuchzahl >= 3) {
                                    Feedback.showMessage(ServerConnection.this.pso, 11);
                                    PSEnvironment.ServerActive = false;
                                    ((ServerConnection)ServerConnection.this).pso.loginform.dispose();
                                    ServerConnection.this.pso.dispose();
                                    System.exit(0);
                                } else {
                                    Feedback.showMessage(ServerConnection.this.pso, 1);
                                    ((ServerConnection)ServerConnection.this).pso.loginform.enableLogin();
                                }
                            }
                        });
                        break;
                    }
                    case 64: {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                Feedback.showMessage(ServerConnection.this.pso, PSEnvironment.getIntValue(ServerConnection.this.Data));
                            }
                        });
                        break;
                    }
                    case 81: {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                Feedback.showMessage(ServerConnection.this.pso, 32);
                            }
                        });
                        break;
                    }
                    case 264: {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                ((ServerConnection)ServerConnection.this).pso.auftragsManager.YoJobs("");
                            }
                        });
                        break;
                    }
                    case 55: {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                Feedback.showMessage(ServerConnection.this.pso, PSEnvironment.getIntValue(ServerConnection.this.Data));
                                ((ServerConnection)ServerConnection.this).pso.loginform.regform.restsetCancelBtn();
                            }
                        });
                        break;
                    }
                    case 74: {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                ((ServerConnection)ServerConnection.this).pso.loginform.mailNotRecieved();
                            }
                        });
                        break;
                    }
                    case -2: {
                        PSEnvironment.printDebugMessage(String.valueOf(this.getClass().getName()) + ".run()", "Error while parsing RequestXML on Server");
                    }
                }
            }
        }
        catch (IOException e) {
            System.err.println("#ERROR_LISTENING::" + e);
            this.ExitOnError(e.getMessage());
        }
        catch (Exception e) {
            System.err.println("Allgemeiner Fehler:" + e);
            e.printStackTrace();
            Feedback.showMessage(this.pso, 45);
            System.exit(0);
        }
    }

    private Document sendRequest(String value) {
        Document result = null;
        try {
            this.urlcon = this.url.openConnection();
            if (Crypt.isUseBlowfish() && this.sessionID.length() > 0) {
                this.urlcon.setRequestProperty("PSOSession", this.sessionID);
            }
            this.urlcon.setRequestProperty("Content-Type", "text/xml");
            this.urlcon.setDoOutput(true);
            this.urlcon.setDoInput(true);
            this.urlcon.setUseCaches(false);
            this.urlcon.setDefaultUseCaches(false);
            String accessKey = WebMapPanel.getMapAccessKey();
            if (accessKey != null) {
                this.urlcon.setRequestProperty("MAK", accessKey);
            }
            if (this.encodedLogin.length() > 0) {
                this.urlcon.setRequestProperty("Proxy-Authorization", "Basic " + this.encodedLogin);
            }
            StringWriter stringOut = new StringWriter();
            stringOut.write(value);
            PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter(this.urlcon.getOutputStream(), "UTF-8"), true);
            out.println(stringOut.toString());
            DOMParser parser = new DOMParser();
            if (this.urlcon.getContentType().equals("deflate")) {
                parser.parse(new InputSource(new BufferedReader(new InputStreamReader((InputStream)new InflaterInputStream(this.urlcon.getInputStream()), "UTF-8"))));
            } else {
                parser.parse(new InputSource(new BufferedReader(new InputStreamReader(this.urlcon.getInputStream(), "UTF-8"))));
            }
            result = parser.getDocument();
            if (Crypt.isUseBlowfish() && this.sessionID.equals("")) {
                this.sessionID = this.urlcon.getHeaderField("PSOSession");
                if (this.sessionID == null) {
                    this.sessionID = "";
                }
            }
            out.close();
        }
        catch (SAXException accessKey) {
        }
        catch (IOException ioe) {
            this.ExitOnError(ioe.getMessage());
            return null;
        }
        return result;
    }

    public int sendDataPackages(int sendCommand, String allDataString, int dataElementLength) {
        int packageLength = (dataElementLength + 1) * 50;
        int packageCount = allDataString.length() % packageLength == 0 ? allDataString.length() / packageLength : allDataString.length() / packageLength + 1;
        PSEnvironment.printDebugMessage(String.valueOf(this.getClass().getName()) + ".senDataPackages()", "-> dataElementLength=" + dataElementLength);
        PSEnvironment.printDebugMessage(String.valueOf(this.getClass().getName()) + ".senDataPackages()", "-> packageLength=" + packageLength);
        PSEnvironment.printDebugMessage(String.valueOf(this.getClass().getName()) + ".senDataPackages()", "-> packageCount=" + packageCount);
        int pc = 0;
        while (pc < packageCount) {
            String sendPackage;
            int firstIndex = pc * packageLength;
            int lastIndex = firstIndex + packageLength - 1;
            if (lastIndex > allDataString.length()) {
                lastIndex = allDataString.length();
            }
            if ((sendPackage = allDataString.substring(firstIndex, lastIndex)).length() > dataElementLength) {
                this.SendMessage(sendCommand, sendPackage);
            }
            PSEnvironment.printDebugMessage(String.valueOf(this.getClass().getName()) + ".senDataPackages()", "-> packageData = " + sendPackage);
            ++pc;
        }
        return packageCount;
    }

    private String debugXML(PsoXmlBuilder currXmlRequest) {
        try {
            return currXmlRequest.createXmlDoc();
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public int getSendSize() {
        return this.toSend.size();
    }

    public void resetStartActionTable(int value) {
        if (value == -1) {
            this.startActionTimeTable.clear();
        } else {
            this.startActionTimeTable.remove("" + value);
        }
    }

    public void resetServerCon() {
        this.toSend.removeAllElements();
        this.toSend.setSize(0);
        this.Running = false;
        PSEnvironment.ServerActive = false;
        PSO.logoAnimation.stop();
        this.pso.setWaitCursorVisible(false);
        if (this.pso.progress_bar7 != null) {
            this.pso.progress_bar7.setValue(0);
        }
    }

    public void ExitOnError(String error) {
        if (!this.lerror.equals("")) {
            return;
        }
        this.lerror = error;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ServerConnection.this.lerror.trim().length() > 0) {
                    Feedback.showMessage((Component)ServerConnection.this.pso, 23, "\"" + ServerConnection.this.lerror + "\"");
                } else {
                    Feedback.showMessage(ServerConnection.this.pso, 23);
                }
                ((ServerConnection)ServerConnection.this).pso.AuftragSaved = true;
                PSEnvironment.ServerActive = false;
                PSEnvironment.logExitError(ServerConnection.this.lerror);
                ServerConnection.this.pso.disposeValidated();
            }
        });
    }

    public void dispose() {
        try {
            if (this.out != null) {
                this.out.close();
            }
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initActionTable() {
        actionsOut = new Hashtable();
        actionsOut.put("1", "SET_TOLERANZ");
        actionsOut.put("2", "SET_AUFTRAGSBEZEICHNUNG");
        actionsOut.put("3", "SET_EINZELGEWICHT");
        actionsOut.put("4", "SET_ANZAHL_SDG_VERPACK");
        actionsOut.put("5", "SET_ANNAHMESTELLE");
        actionsOut.put("6", "SET_MODUS");
        actionsOut.put("7", "SET_POSTWURFAN");
        actionsOut.put("8", "INIT_TABORTE");
        actionsOut.put("9", "INIT_ANNAHMESTELLEN");
        actionsOut.put("10", "INIT_TABZUSTELL");
        actionsOut.put("11", "INIT_TABABHOL");
        actionsOut.put("12", "SET_ABS_EIN_LAND");
        actionsOut.put("13", "INIT_TABUNTERAUSWAHL");
        actionsOut.put("14", "ADD_ZSP");
        actionsOut.put("15", "ADD_BFAH");
        actionsOut.put("16", "DEL_AUSWAHL ");
        actionsOut.put("17", "ADD_ORTE");
        actionsOut.put("18", "ADD_ORTSTEILE");
        actionsOut.put("314", "ADD_ZBN");
        actionsOut.put("315", "ADD_STANDORT");
        actionsOut.put("316", "DEL_STANDORT");
        actionsOut.put("19", "SET_ABSENDER");
        actionsOut.put("20", "SET_ABS_STRASSE");
        actionsOut.put("21", "SET_ABS_LAND");
        actionsOut.put("22", "SET_ABS_SPLZ");
        actionsOut.put("23", "SET_ABS_PPLZ");
        actionsOut.put("24", "SET_ABS_PNR");
        actionsOut.put("25", "SET_ABS_ORT");
        actionsOut.put("26", "SET_ABS_KDNR");
        actionsOut.put("27", "SET_ABS_TELEFON");
        actionsOut.put("300", "SET_ABS_ERGNR");
        actionsOut.put("28", "SET_EINLIEFERER");
        actionsOut.put("29", "SET_EIN_STRASSE");
        actionsOut.put("30", "SET_EIN_LAND");
        actionsOut.put("31", "SET_EIN_SPLZ");
        actionsOut.put("32", "SET_EIN_PPLZ");
        actionsOut.put("33", "SET_EIN_PNR");
        actionsOut.put("34", "SET_EIN_ORT");
        actionsOut.put("35", "SET_EIN_KDNR");
        actionsOut.put("36", "SET_EIN_TELEFON");
        actionsOut.put("301", "SET_EIN_ERGNR");
        actionsOut.put("331", "SET_ABW_ZAHLUNGSPFLICHTIGER");
        actionsOut.put("332", "GET_ABW_ZAHLUNGSPFLICHTIGER");
        actionsOut.put("333", "GET_BRANCHES_AND_COUNTRIES");
        actionsOut.put("334", "CHANGE_PASSWORD");
        actionsOut.put("37", "SET_ABSEIN");
        actionsOut.put("38", "SET_ZAHLUNGSWEISE");
        actionsOut.put("304", "SET_ZAHLUNGSPFLICHTIGER");
        actionsOut.put("39", "SET_GELDINSTITUT");
        actionsOut.put("40", "SET_KONTOBEZEICHNUNG");
        actionsOut.put("41", "SET_BANKLEITZAHL");
        actionsOut.put("42", "SET_KONTONUMMER");
        actionsOut.put("43", "INIT_PRINT_VS");
        actionsOut.put("44", "CLOSE_PRINT_VS");
        actionsOut.put("45", "INIT_VERSION");
        actionsOut.put("46", "INIT_LOGIN");
        actionsOut.put("47", "SET_AUFTRAGSBEZEICHNUNG_AS");
        actionsOut.put("48", "SET_DRUCKEINFACH");
        actionsOut.put("481", "SET_DRUCKHINTEREINANDER");
        actionsOut.put("482", "SET_DRUCKSTAPEL");
        actionsOut.put("483", "SET_DRUCKFREITEXT");
        actionsOut.put("485", "SET_DRUCKFREITEXTPALETTE");
        actionsOut.put("49", "SET_WAHRUNG");
        actionsOut.put("50", "INIT_PRINTE");
        actionsOut.put("51", "CLOSE_PRINT");
        actionsOut.put("52", "INIT_PRINT_ZG");
        actionsOut.put("53", "CLOSE_PRINT_ZG");
        actionsOut.put("54", "INIT_PRINTA");
        actionsOut.put("541", "INIT_PRINTASTAPEL");
        actionsOut.put("55", "REGISTER");
        actionsOut.put("56", "SET_ENTGELTIN");
        actionsOut.put("57", "SET_RUNDUNGAUF");
        actionsOut.put("58", "SET_GEBINDEMODUS");
        actionsOut.put("59", "NEUER_AUFTRAG");
        actionsOut.put("60", "SET_OPT_TZ");
        actionsOut.put("61", "SET_OPT_AUSWAHL");
        actionsOut.put("62", "SET_OPT_BUNDESLAND");
        actionsOut.put("80", "SET_AKTZONE");
        actionsOut.put("63", "SAVE_AUFTRAG");
        actionsOut.put("64", "LOAD_AUFTRAG");
        actionsOut.put("65", "SAVEAS_AUFTRAG");
        actionsOut.put("66", "CHECK_NAME");
        actionsOut.put("67", "DELETE_AUFTRAG");
        actionsOut.put("81", "RENAME_AUFTRAG");
        actionsOut.put("321", "SAVE_AUFTRAG_AUTO");
        actionsOut.put("68", "INIT_DETAIL");
        actionsOut.put("69", "CLOSE_DETAIL");
        actionsOut.put("70", "SET_MITBENUTZER");
        actionsOut.put("71", "CHG_SELEKTION_ADD");
        actionsOut.put("72", "CHG_SELEKTION_DEL");
        actionsOut.put("73", "CHG_USERINFO");
        actionsOut.put("74", "SEND_PASSWD");
        actionsOut.put("77", "LOGOUT");
        actionsOut.put("78", "CHECK_VERSION");
        actionsOut.put("75", "INIT_PALETTE");
        actionsOut.put("76", "CLOSE_PALETTE");
        actionsOut.put("79", "RESOLVE_ZBN");
        actionsOut.put("318", "RESOLVE_ZBN_FLAG");
        actionsOut.put("201", "GET_EINZELENTGELT");
        actionsOut.put("202", "GET_ORTE");
        actionsOut.put("203", "GET_ANNAHMESTELLEN");
        actionsOut.put("204", "GET_EINZELGEWICHT ");
        actionsOut.put("205", "GET_ANZAHL_SDG_VERPACK");
        actionsOut.put("206", "GET_TOLERANZ ");
        actionsOut.put("207", "GET_ZUSTELL");
        actionsOut.put("208", "GET_ABHOL");
        actionsOut.put("209", "GET_UNTERAUSWAHL");
        actionsOut.put("210", "GET_AUSWAHL");
        actionsOut.put("210001", "GET_AUSWAHL_DETAILS");
        actionsOut.put("210002", "GET_UNTERAUSWAHL_DETAILS");
        actionsOut.put("210003", "GET_SELECTION_DETAILS");
        actionsOut.put("317", "GET_STANDORTE");
        actionsOut.put("211", "GET_ANZAHLVERTEILSTELLEN");
        actionsOut.put("212", "GET_SUMSDG");
        actionsOut.put("213", "GET_ENTGELT");
        actionsOut.put("214", "GET_SUMSDGINFO");
        actionsOut.put("215", "GET_ENTGELTINFO");
        actionsOut.put("216", "GET_ABSENDER");
        actionsOut.put("225", "GET_EINLIEFERER");
        actionsOut.put("217", "GET_ABS_STRASSE");
        actionsOut.put("218", "GET_ABS_LAND");
        actionsOut.put("219", "GET_ABS_SPLZ");
        actionsOut.put("220", "GET_ABS_PPLZ");
        actionsOut.put("221", "GET_ABS_PNR");
        actionsOut.put("222", "GET_ABS_ORT");
        actionsOut.put("2221", "GET_ABS_ORT_BYPLZ");
        actionsOut.put("223", "GET_ABS_KDNR");
        actionsOut.put("224", "GET_ABS_TELEFON");
        actionsOut.put("302", "GET_ABS_ERGNR");
        actionsOut.put("226", "GET_EIN_STRASSE");
        actionsOut.put("227", "GET_EIN_LAND");
        actionsOut.put("228", "GET_EIN_SPLZ");
        actionsOut.put("229", "GET_EIN_PPLZ");
        actionsOut.put("230", "GET_EIN_PNR");
        actionsOut.put("231", "GET_EIN_ORT");
        actionsOut.put("2311", "GET_EIN_ORT_BYPLZ");
        actionsOut.put("232", "GET_EIN_KDNR");
        actionsOut.put("233", "GET_EIN_TELEFON");
        actionsOut.put("303", "GET_EIN_ERGNR");
        actionsOut.put("234", "GET_ZAHLUNGSWEISE");
        actionsOut.put("305", "GET_ZAHLUNGSPFLICHTIGER");
        actionsOut.put("235", "GET_GELDINSTITUT");
        actionsOut.put("236", "GET_KONTOBEZEICHNUNG");
        actionsOut.put("237", "GET_BANKLEITZAHL");
        actionsOut.put("238", "GET_KONTONUMMER");
        actionsOut.put("239", "GET_INFOBOX");
        actionsOut.put("484", "GET_FREITEXT");
        actionsOut.put("486", "GET_FREITEXTPALETTE");
        actionsOut.put("241", "GET_PP_VS");
        actionsOut.put("242", "GET_AUFTRAGSBEZEICHNUNG_AS");
        actionsOut.put("243", "GET_DRUCKEINFACH");
        actionsOut.put("244", "GET_INFOBFAH");
        actionsOut.put("245", "GET_INFOKGSOZ");
        actionsOut.put("246", "GET_TABLEEINZELN");
        actionsOut.put("247", "GET_TABLEALLE");
        actionsOut.put("248", "GET_TABLEALLEV");
        actionsOut.put("249", "GET_INFOZSP");
        actionsOut.put("312", "GET_INFOZBN");
        actionsOut.put("313", "GET_INFO_KARTEZBN");
        actionsOut.put("250", "GET_INFOORTSTEILE");
        actionsOut.put("251", "GET_ANZDRUCK_ASVH");
        actionsOut.put("252", "GET_PP_ZG");
        actionsOut.put("253", "GET_PP_VH");
        actionsOut.put("254", "GET_INFOPLZ");
        actionsOut.put("255", "GET_AK");
        actionsOut.put("256", "GET_AK_INFO");
        actionsOut.put("257", "GET_AK_DATA");
        actionsOut.put("258", "GET_SELEKTION");
        actionsOut.put("259", "GET_USERDATA");
        actionsOut.put("260", "GET_GEBINDE");
        actionsOut.put("261", "GET_PP_AS");
        actionsOut.put("262", "GET_PP_EINZEL");
        actionsOut.put("263", "GET_MWST_DM_EURO");
        actionsOut.put("264", "GET_AUFTRAGE");
        actionsOut.put("265", "GET_RUNDUNGAUF");
        actionsOut.put("266", "GET_POSTWURFAN");
        actionsOut.put("267", "GET_RUNDUNGSART");
        actionsOut.put("268", "GET_ANZSELECTION");
        actionsOut.put("269", "GET_MODUS");
        actionsOut.put("270", "GET_ABSEIN");
        actionsOut.put("271", "GET_ANNAHMEMODUS");
        actionsOut.put("272", "GET_ANNAHME");
        actionsOut.put("273", "GET_BFAH_LEITREGION");
        actionsOut.put("274", "GET_MITBENUTZER");
        actionsOut.put("275", "GET_DETAIL");
        actionsOut.put("276", "GET_AK_VERSION");
        actionsOut.put("277", "GET_PALETTE");
        actionsOut.put("278", "GET_ANNAHMEINFO");
        actionsOut.put("279", "GET_PRINT_KASSENBELEG");
        actionsOut.put("280", "GET_PRINT_AUFTRAGGEBER");
        actionsOut.put("281", "GET_INFOSELECTION");
        actionsOut.put("282", "SET_DETAILINFO");
        actionsOut.put("283", "GET_PP_DETAIL");
        actionsOut.put("284", "GET_AUFTRAGSBEZEICHNUNG");
        actionsOut.put("285", "GET_ZSP_PLZ");
        actionsOut.put("286", "GET_PP_PRINTFILE");
        actionsOut.put("287", "GET_INFOKREIS");
        actionsOut.put("288", "GET_HISTORY");
        actionsOut.put("289", "GET_LEITREGION_PLZ");
        actionsOut.put("290", "ACTION_FINISHED");
        actionsOut.put("306", "CANCEL_REGISTER");
        actionsOut.put("307", "SET_MESSAGERIGHT");
        actionsOut.put("291", "GET_MESSAGE");
        actionsOut.put("292", "GET_PSOUSER");
        actionsOut.put("293", "SEND_MESSAGE");
        actionsOut.put("294", "FETCH_MESSAGE");
        actionsOut.put("295", "SET_INVITATION");
        actionsOut.put("296", "GET_INVPSOUSER");
        actionsOut.put("297", "GET_SHAREDJOBS");
        actionsOut.put("298", "SET_SHAREDJOBS");
        actionsOut.put("299", "DEL_MESSAGE");
        actionsOut.put("888", "INIT_CRC");
        actionsOut.put("666", "GET_NULL");
        actionsOut.put("997", "GET_CONNECTION");
        actionsOut.put("998", "ABORT");
        actionsOut.put("999", "EXIT");
        actionsOut.put("319", "GET_MERGEABLE_JOBS");
        actionsOut.put("320", "SET_JOBS_TO_MERGE");
        actionsOut.put("322", "GET_ZBN_HHSUM");
        actionsOut.put("95", "LAST_SESSION_ERROR");
        actionsOut.put("325", "GET_PRINT_PALETTE");
        actionsOut.put("327", "GET_PRINT_PALETTE_LIST");
        actionsOut.put("323", "GET_ZBN_ZUSATZ_USED");
        actionsOut.put("324", "SET_PRINT_IN_PAL_ORDER");
        actionsOut.put("399", "SET_PRINT_SORT_BY_PAL");
        actionsOut.put("326", "REQUEST_EXPORT_DATA");
        actionsOut.put("328", "SEND_PRINTFILES");
        actionsOut.put("10001", "GET_CERTIFICATE");
        actionsOut.put("10000", "SET_SESSION_KEY");
        actionsOut.put("329", "VERIFY_EKP");
        actionsOut.put("330", "REASSIGN_ZBN");
        actionsOut.put("335", "SET_USE_NEW_MWST");
        actionsOut.put("336", "GET_USE_NEW_MWST");
        actionsOut.put("337", "GET_LAST_JOB_DATA");
        actionsOut.put("338", "UPDATE_EA_AK");
        actionsOut.put("339", "GET_UPDATED_EA_AK");
        actionsOut.put("340", "GET_ORG_EA_AK");
        actionsOut.put("341", "RESOLVE_PLZ");
        actionsOut.put("342", "RESOLVE_OT");
        actionsOut.put("363", "RESOLVE_ORT");
        actionsOut.put("364", "RESOLVE_ZSP");
        actionsOut.put("365", "RESOLVE_BFAH");
        actionsOut.put("345", "ADD_STD_REGIONS");
        actionsOut.put("346", "ADD_RELEASE");
        actionsOut.put("347", "ADD_INVITATION");
        actionsOut.put("343", "SET_FULLZBNMODE");
        actionsOut.put("344", "GET_FULLZBNMODE");
        actionsOut.put("366", "GET_PLZ_FOR_ORT");
        actionsOut.put("367", "GET_PALETTE_DONE");
        actionsOut.put("368", "GET_PALETTE_NOTIFICATION");
        actionsOut.put("369", "GET_JOB_STATS");
        actionsOut.put("370", "SET_PRINT_SPITZGEBINDE");
        actionsOut.put("348", "CREATE_ORDER");
        actionsOut.put("349", "CANCEL_ORDER");
        actionsOut.put("350", "SET_ERSTELLER");
        actionsOut.put("351", "SET_ABHOLUNG");
        actionsOut.put("371", "GET_ABHOLUNG");
        actionsOut.put("352", "SET_ABHOLTERMIN");
        actionsOut.put("353", "GET_ABHOLTERMIN");
        actionsOut.put("354", "SET_ZUSTELLTERMIN");
        actionsOut.put("355", "GETZUSTELLTERMIN");
        actionsOut.put("356", "SET_AM_ID");
        actionsOut.put("357", "GET_AM_ID");
        actionsOut.put("358", "SET_USECERTIFICATION");
        actionsOut.put("359", "GET_USECERTIFICATION");
        actionsOut.put("360", "SET_CHANGELEVEL");
        actionsOut.put("361", "GET_CHANGELEVEL");
        actionsOut.put("362", "NEUER_TEILAUFTRAG");
        actionsOut.put("372", "STORE_ADRESS_RECORDS");
        actionsOut.put("373", "LOAD_ADRESS_RECORDS");
        actionsOut.put("374", "UNDO_LAST_SELECTIONCHG");
        actionsOut.put("375", "BEGIN_SELECTION_CHG");
        actionsOut.put("376", "INIT_DEPOTS");
        actionsOut.put("379", "IS_SEPA_ENABLED");
        actionsOut.put("380", "CONVERT_TO_SEPA");
        actionsOut.put("381", "CONVERT_FROM_SEPA");
        actionsOut.put("382", "SEARCH_BIC");
        actionsOut.put("383", "QUERY_UNCONVERTABLE");
        actionsOut.put("384", "SET_PA_IND");
        actionsOut.put("385", "GET_PA_IND");
        actionsOut.put("387", "SET_BASEPRODUCT_SELECTED");
        actionsOut.put("388", "GET_BASEPRODUCT_SELECTED");
        actionsOut.put("386", "CHG_USER_LANGUAGE");
        actionsOut.put("389", "SET_DELIVERY_WEEK");
        actionsOut.put("390", "GET_DELIVERY_WEEK");
        actionsOut.put("391", "SET_ZSP_PACKAGING");
        actionsOut.put("392", "GET_ZSP_PACKAGING");
        actionsOut.put("393", "SET_AM_CREDENTIALS");
        actionsOut.put("394", "GET_AM_CREDENTIALS");
        actionsOut.put("395", "SET_IS_GPWS_USER");
        actionsOut.put("396", "GET_IS_GPWS_USER");
        actionsOut.put("398", "GET_SALES_JOB_STATE");
        actionsOut.put("450", "REQUEST_JOB_APPROVAL");
        actionsOut.put("451", "REQUEST_JOB_CANCELATION");
        actionsOut.put("452", "REVOKE_JOB_APPROVAL_REQUEST");
        actionsOut.put("453", "SET_STORAGE_END_DATE");
        actionsOut.put("454", "GET_STORAGE_END_DATE");
        actionsOut.put("455", "GET_PAL_STORAGE_PRICE");
        actionsOut.put("456", "SET_PRINT_ORDER_BY_ID");
        actionsOut.put("457", "ADD_JOB_FILTER");
        actionsOut.put("458", "REMOVE_JOB_FILTER");
        actionsOut.put("459", "RESET_JOB_FILTERS");
        actionsOut.put("465", "GET_JOB_FILTER_CHAINS");
        actionsOut.put("466", "SAVE_JOB_FILTER_CHAIN");
        actionsOut.put("467", "LOAD_JOB_FILTER_CHAIN");
        actionsOut.put("468", "DEL_JOB_FILTER_CHAIN");
        actionsOut.put("461", "SET_SORT_OPTION");
        actionsOut.put("460", "GET_PALETTE_DETAILS");
        actionsOut.put("462", "GET_AM_OBLIGATORY_LIMIT");
        actionsOut.put("463", "GET_AM_IO_ERROR");
        actionsOut.put("464", "GET_ABHOL_COST");
        actionsOut.put("469", "SET_AB_FRAGMENTATION");
        actionsOut.put("470", "GET_AB_FRAGMENTATION");
    }

    public boolean isRunning() {
        return this.Running;
    }

    public String getEncodedLogin() {
        return this.encodedLogin;
    }
}

