/*
 * Decompiled with CFR 0.152.
 */
package prospektservice;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import prospektservice.PSEnvironment;

public class PsoDataXmlBuilder {
    private Document xmlDoc = null;
    private Element rootElement = null;
    private Element elementOfpsodaten = null;
    public static String ROOT_ELEMENT_TAG = "psodaten";
    public static String ELEMENT_IN_ROOT_TAG = "ElementOfpsodaten";
    public static final String ATTR_CURR_ROW = "currentrow";

    public PsoDataXmlBuilder() {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = docFactory.newDocumentBuilder();
            this.xmlDoc = builder.newDocument();
            this.rootElement = this.xmlDoc.createElement(ROOT_ELEMENT_TAG);
            this.xmlDoc.appendChild(this.rootElement);
        }
        catch (Exception e) {
            System.out.println(" PsoDataXmlBuilder-Konstruktor ->" + e.getMessage());
        }
    }

    public PsoDataXmlBuilder(Document doc) {
        this.xmlDoc = doc;
    }

    public PsoDataXmlBuilder(String xmlStringData) {
        try {
            Document doc = null;
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(new StringReader(xmlStringData)));
            this.xmlDoc = doc = parser.getDocument();
        }
        catch (Exception e) {
            System.out.println(" PsoDataXmlBuilder-Konstruktor ->" + e.getMessage());
        }
    }

    public void setXmlDoc(Document doc) throws Exception {
        if (PSEnvironment.DEBUG) {
            System.out.println("assigning new doc...");
        }
        this.xmlDoc = doc;
    }

    public String createXmlDoc() throws Exception {
        String result = "";
        OutputFormat format = new OutputFormat(this.xmlDoc, "iso-8859-1", true);
        StringWriter stringOut = new StringWriter();
        XMLSerializer serial = new XMLSerializer((Writer)stringOut, format);
        serial.asDOMSerializer();
        serial.serialize(this.xmlDoc);
        result = stringOut.toString();
        return result;
    }

    public void setCurrentRow(int currentRow) {
        Attr attribute = null;
        attribute = this.xmlDoc.createAttribute(ATTR_CURR_ROW);
        attribute.setValue("" + currentRow);
        this.rootElement.setAttributeNode(attribute);
    }

    public int getCurrentRow() {
        int currentRow = 0;
        String attrValue = "";
        attrValue = this.getRootAttributeValue(ATTR_CURR_ROW);
        if (attrValue != null && !attrValue.equals("")) {
            currentRow = PSEnvironment.getIntValue(attrValue);
        }
        return currentRow;
    }

    public int getDataCount() {
        NodeList rows = this.xmlDoc.getDocumentElement().getElementsByTagName(ELEMENT_IN_ROOT_TAG);
        return rows.getLength();
    }

    public void addPsoDatenElement(String[] colNames, String[] colValues) {
        Attr attribute = null;
        Element elementOfpsodaten = this.xmlDoc.createElement(ELEMENT_IN_ROOT_TAG);
        int i = 0;
        while (i < colNames.length) {
            attribute = this.xmlDoc.createAttribute(colNames[i]);
            attribute.setValue(colValues[i]);
            elementOfpsodaten.setAttributeNode(attribute);
            ++i;
        }
        this.xmlDoc.getDocumentElement().appendChild(elementOfpsodaten);
    }

    public String getRootAttributeValue(String attributeName) {
        Element ourElement = this.xmlDoc.getDocumentElement();
        return ourElement.getAttribute(attributeName);
    }

    public void setRootAttributeValue(String atributeName, String atributeValue) {
        Attr attribute = null;
        attribute = this.xmlDoc.createAttribute(atributeName);
        attribute.setValue(atributeValue);
        this.rootElement.setAttributeNode(attribute);
    }

    public void delRootAttributeValue(String attributeName) {
        Element ourElement = this.xmlDoc.getDocumentElement();
        ourElement.removeAttribute(attributeName);
    }
}

