/*
 * Decompiled with CFR 0.152.
 */
package de.codesolutions.pam.map;

import java.util.Vector;
import prospektservice.PSEnvironment;
import prospektservice.PSO;

public class MapPartialSelectionObj {
    private Vector<String> selection;
    private Vector<String> initialSelection;
    private String area;
    private String objId = "";
    private double percentSelected;
    private boolean needUpdate = false;
    private int cntOrtsteile = 0;
    private int selectedCnt = 0;

    public MapPartialSelectionObj(String key, int cnt, double percent, boolean doRefresh) {
        this.area = key;
        this.objId = "PartialSelection" + cnt;
        this.selection = new Vector();
        this.initialSelection = new Vector();
        this.percentSelected = percent;
    }

    public MapPartialSelectionObj(String key, int cnt, double percent) {
        this(key, cnt, percent, true);
    }

    public void setOrtsteileCount(int cnt) {
        this.cntOrtsteile = cnt;
    }

    public int getOrtsteileCount() {
        return this.cntOrtsteile;
    }

    public void setSelectionCount(int cnt) {
        this.selectedCnt = cnt;
    }

    public int getSelectionCount() {
        return this.selectedCnt;
    }

    public void setSelection(Vector<String> ids) {
        this.initialSelection.addAll(this.selection);
        this.selection.removeAllElements();
        this.selection.addAll(ids);
        this.needUpdate = false;
    }

    public void updateInitialSelection() {
        this.initialSelection.removeAllElements();
        this.initialSelection.addAll(this.selection);
    }

    public Vector<String> getSelection() {
        return this.selection;
    }

    public Object[] getDeletableIDs() {
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < this.initialSelection.size()) {
            String id = this.initialSelection.elementAt(i);
            if (!this.selection.contains(id)) {
                v.addElement(id.toString());
            }
            ++i;
        }
        return v.toArray();
    }

    public Object[] getAddableIDs() {
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < this.selection.size()) {
            String id = this.selection.elementAt(i);
            v.addElement(id.toString());
            ++i;
        }
        return v.toArray();
    }

    public void updatePercent(double p) {
        this.needUpdate = p != this.percentSelected && !PSO.mainpanel.isKarteSelectionChanged();
        this.percentSelected = p;
    }

    public double getPercent() {
        return this.percentSelected;
    }

    public void removePartialSelectionObj() {
        this.removePartialSelectionObj(true);
    }

    public void removePartialSelectionObj(boolean removeSelection) {
        if (PSEnvironment.DEBUG) {
            System.out.println("remove is called for area " + this.area.toString());
        }
        this.selection.removeAllElements();
        this.initialSelection.removeAllElements();
    }

    public String getArea() {
        return this.area;
    }

    public boolean isNeedUpdate() {
        return this.needUpdate;
    }

    public void setNeedUpdate(boolean needUpdate) {
        this.needUpdate = needUpdate;
    }
}

