/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.OptionArgument;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class Handouts
extends AbstractTool {
    static {
        Handouts.addVersion("$Id: Handouts.java 3271 2008-04-18 20:39:42Z xlv $");
    }

    public Handouts() {
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to convert", false, new PdfFilter()));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the Handout has to be written", true, new PdfFilter()));
        OptionArgument oa = new OptionArgument(this, "pages", "The number of pages you want on one handout page");
        oa.addOption("2 pages on 1", "2");
        oa.addOption("3 pages on 1", "3");
        oa.addOption("4 pages on 1", "4");
        oa.addOption("5 pages on 1", "5");
        oa.addOption("6 pages on 1", "6");
        oa.addOption("7 pages on 1", "7");
        oa.addOption("8 pages on 1", "8");
        this.arguments.add(oa);
    }

    @Override
    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Handouts", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Handouts OPENED ===");
    }

    @Override
    public void execute() {
        try {
            int pages;
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File src = (File)this.getValue("srcfile");
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            File dest = (File)this.getValue("destfile");
            try {
                pages = Integer.parseInt((String)this.getValue("pages"));
            }
            catch (Exception e) {
                pages = 4;
            }
            float x1 = 30.0f;
            float x2 = 280.0f;
            float x3 = 320.0f;
            float x4 = 565.0f;
            float[] y1 = new float[pages];
            float[] y2 = new float[pages];
            float height = (778.0f - 20.0f * (float)(pages - 1)) / (float)pages;
            y1[0] = 812.0f;
            y2[0] = 812.0f - height;
            int i = 1;
            while (i < pages) {
                y1[i] = y2[i - 1] - 20.0f;
                y2[i] = y1[i] - height;
                ++i;
            }
            PdfReader reader = new PdfReader(src.getAbsolutePath());
            int n = reader.getNumberOfPages();
            System.out.println("There are " + n + " pages in the original file.");
            Document document = new Document(PageSize.A4);
            PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(dest));
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            int i2 = 0;
            int p = 0;
            while (i2 < n) {
                float factory;
                Rectangle rect;
                float factorx;
                float factor = (factorx = (x2 - x1) / (rect = reader.getPageSizeWithRotation(++i2)).getWidth()) < (factory = (y1[p] - y2[p]) / rect.getHeight()) ? factorx : factory;
                float dx = factorx == factor ? 0.0f : (x2 - x1 - rect.getWidth() * factor) / 2.0f;
                float dy = factory == factor ? 0.0f : (y1[p] - y2[p] - rect.getHeight() * factor) / 2.0f;
                PdfImportedPage page = writer.getImportedPage(reader, i2);
                int rotation = reader.getPageRotation(i2);
                if (rotation == 90 || rotation == 270) {
                    cb.addTemplate(page, 0.0f, -factor, factor, 0.0f, x1 + dx, y2[p] + dy + rect.getHeight() * factor);
                } else {
                    cb.addTemplate(page, factor, 0.0f, 0.0f, factor, x1 + dx, y2[p] + dy);
                }
                cb.setRGBColorStroke(192, 192, 192);
                cb.rectangle(x3 - 5.0f, y2[p] - 5.0f, x4 - x3 + 10.0f, y1[p] - y2[p] + 10.0f);
                float l = y1[p] - 19.0f;
                while (l > y2[p]) {
                    cb.moveTo(x3, l);
                    cb.lineTo(x4, l);
                    l -= 16.0f;
                }
                cb.rectangle(x1 + dx, y2[p] + dy, rect.getWidth() * factor, rect.getHeight() * factor);
                cb.stroke();
                System.out.println("Processed page " + i2);
                if (++p != pages) continue;
                p = 0;
                document.newPage();
            }
            document.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.internalFrame, e.getMessage(), e.getClass().getName(), 0);
            System.err.println(e.getMessage());
        }
    }

    @Override
    public void valueHasChanged(AbstractArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] args) {
        Handouts tool = new Handouts();
        if (args.length < 2) {
            System.err.println(tool.getUsage());
        }
        tool.setMainArguments(args);
        tool.execute();
    }

    @Override
    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }
}

