/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.arguments;

import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.filters.DirFilter;
import com.lowagie.toolbox.swing.PdfInformationPanel;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class FileArgument
extends AbstractArgument {
    protected FileFilter filter;
    protected boolean newFile;
    PdfInformationPanel label = null;

    public FileArgument() {
    }

    public FileArgument(AbstractTool tool, String name, String description, boolean newFile, FileFilter filter) {
        super(tool, name, description, null);
        this.newFile = newFile;
        this.filter = filter;
    }

    public FileArgument(AbstractTool tool, String name, String description, boolean newFile) {
        this(tool, name, description, newFile, null);
    }

    @Override
    public Object getArgument() throws InstantiationException {
        if (this.value == null) {
            return null;
        }
        try {
            return new File(this.value.toString());
        }
        catch (Exception e) {
            throw new InstantiationException(e.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser();
        if (this.filter != null) {
            fc.setFileFilter(this.filter);
            if (this.filter instanceof DirFilter) {
                fc.setFileSelectionMode(1);
            }
        }
        if (this.label != null) {
            fc.setAccessory(this.label);
            fc.addPropertyChangeListener("SelectedFileChangedProperty", this.label);
        }
        if (this.newFile) {
            fc.showSaveDialog(this.tool.getInternalFrame());
        } else {
            fc.showOpenDialog(this.tool.getInternalFrame());
        }
        try {
            this.setValue(fc.getSelectedFile());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public FileFilter getFilter() {
        return this.filter;
    }

    public void setFilter(FileFilter filter) {
        this.filter = filter;
    }

    public PdfInformationPanel getLabel() {
        return this.label;
    }

    public void setLabel(PdfInformationPanel label) {
        this.label = label;
    }
}

