/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.rups.model;

import com.lowagie.rups.model.BackgroundTask;
import com.lowagie.rups.model.IndirectObjectFactory;
import com.lowagie.rups.model.ProgressDialog;
import com.lowagie.rups.model.TreeNodeFactory;
import com.lowagie.text.pdf.PdfReader;
import java.util.Observable;

public class ObjectLoader
extends BackgroundTask {
    protected Observable observable;
    protected PdfReader reader;
    protected IndirectObjectFactory objects;
    protected TreeNodeFactory nodes;

    public ObjectLoader(Observable observable, PdfReader reader) {
        this.observable = observable;
        this.reader = reader;
        this.start();
    }

    public PdfReader getReader() {
        return this.reader;
    }

    public IndirectObjectFactory getObjects() {
        return this.objects;
    }

    public TreeNodeFactory getNodes() {
        return this.nodes;
    }

    @Override
    public void doTask() {
        ProgressDialog progress = new ProgressDialog(null, "Reading PDF file");
        this.objects = new IndirectObjectFactory(this.reader);
        int n = this.objects.getXRefMaximum();
        progress.setMessage("Reading the Cross-Reference table");
        progress.setTotal(n);
        while (this.objects.storeNextObject()) {
            progress.setValue(this.objects.getCurrent());
        }
        progress.setTotal(0);
        this.nodes = new TreeNodeFactory(this.objects);
        progress.setMessage("Updating GUI");
        this.observable.notifyObservers(this);
        progress.dispose();
    }
}

