/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swinghelper.layer.painter;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import org.jdesktop.swinghelper.layer.JXLayer;
import org.jdesktop.swinghelper.layer.effect.Effect;
import org.jdesktop.swinghelper.layer.painter.AbstractPainter;
import org.jdesktop.swinghelper.layer.painter.model.BufferedPainterModel;
import org.jdesktop.swinghelper.layer.painter.model.DefaultBufferedPainterModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBufferedPainter<V extends JComponent>
extends AbstractPainter<V> {
    private BufferedImage buffer;
    private Effect[] effects = new Effect[0];

    protected AbstractBufferedPainter() {
        this(new DefaultBufferedPainterModel());
    }

    protected AbstractBufferedPainter(BufferedPainterModel model) {
        super(model);
    }

    @Override
    public BufferedPainterModel getModel() {
        return (BufferedPainterModel)super.getModel();
    }

    public boolean isIncrementalUpdate(JXLayer<V> l) {
        return this.getModel().isIncrementalUpdate();
    }

    public BufferedImage getBuffer() {
        return this.buffer;
    }

    protected void setBuffer(BufferedImage buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("BufferedImage is null");
        }
        this.buffer = buffer;
    }

    public void setEffects(Effect ... effects) {
        if (effects == null) {
            effects = new Effect[]{};
        }
        for (Effect effect : this.getEffects()) {
            effect.removeLayerItemListener(this);
        }
        this.effects = new Effect[effects.length];
        System.arraycopy(effects, 0, this.effects, 0, effects.length);
        for (Effect effect : effects) {
            effect.addLayerItemListener(this);
        }
        this.fireLayerItemChanged();
    }

    public Effect[] getEffects() {
        Effect[] result = new Effect[this.effects.length];
        System.arraycopy(this.effects, 0, result, 0, result.length);
        return result;
    }

    protected void processEffects(Shape clip) {
        if (this.getBuffer() == null) {
            throw new IllegalStateException("Buffer is null");
        }
        for (Effect e : this.getEffects()) {
            if (!e.isEnabled()) continue;
            e.apply(this.getBuffer(), clip);
        }
    }

    @Override
    public void paint(Graphics2D g2, JXLayer<V> l) {
        if (this.isLayerValid(l) && this.isPainterValid()) {
            this.configure(g2, l);
            if (!this.isImageValid(g2, l)) {
                if (!this.isBufferValid(g2, l)) {
                    this.setBuffer(this.createBuffer(g2, l.getWidth(), l.getHeight()));
                }
                Graphics2D bufg = (Graphics2D)this.getBuffer().getGraphics();
                if (this.isIncrementalUpdate(l)) {
                    bufg.setClip(g2.getClip());
                }
                this.paintToBuffer(bufg, l);
                this.processEffects(bufg.getClip());
                bufg.dispose();
            }
            g2.drawImage((Image)this.getBuffer(), 0, 0, null);
        }
    }

    protected boolean isPainterValid() {
        return true;
    }

    protected boolean isBufferValid(Graphics2D g2, JXLayer<V> l) {
        return this.getBuffer() != null && this.getBuffer().getWidth() == l.getWidth() && this.getBuffer().getHeight() == l.getHeight();
    }

    protected boolean isImageValid(Graphics2D g2, JXLayer<V> l) {
        return !this.isIncrementalUpdate(l) && !l.getVisibleRect().equals(g2.getClipBounds());
    }

    protected boolean isLayerValid(JXLayer<V> l) {
        return l.getWidth() != 0 && l.getHeight() != 0;
    }

    protected void paintToBuffer(Graphics2D g2, JXLayer<V> l) {
    }

    protected BufferedImage createBuffer(Graphics2D g2, int width, int height) {
        return g2.getDeviceConfiguration().createCompatibleImage(width, height, 3);
    }
}

