/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.util.elem2D;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.geotools.geometry.iso.util.algorithm2D.AlgoPoint2D;
import org.geotools.geometry.iso.util.algorithm2D.AlgoRectangle2D;
import org.geotools.geometry.iso.util.elem2D.Edge2D;
import org.geotools.geometry.iso.util.elem2D.Node2D;

public abstract class Simplex2D {
    protected Node2D[] point;
    protected Object[] neighbour;
    public int id = -1;
    public Object object = null;

    protected Simplex2D(Node2D[] p) {
        this.initialize();
        int n = this.n();
        for (int i = 0; i < n; ++i) {
            this.point[i] = p[i];
        }
    }

    protected Simplex2D(Node2D[] p, int n) {
        this.initialize(n);
        for (int i = 0; i < n; ++i) {
            this.point[i] = new Node2D(p[i]);
        }
    }

    protected abstract int n();

    public abstract int sideBits(int var1);

    private void initialize() {
        this.point = new Node2D[this.n()];
        this.neighbour = new Object[this.n()];
    }

    private void initialize(int n) {
        this.point = new Node2D[n];
        this.neighbour = new Object[this.n()];
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Node2D[] getPoints() {
        return this.point;
    }

    public Node2D getPoint(int n) {
        return this.point[n];
    }

    public Node2D[] getPointFromSide(int side) {
        return new Node2D[]{this.point[side], this.point[(side + 1) % this.n()]};
    }

    public Object[] getNeighbours() {
        return this.neighbour;
    }

    public Rectangle2D getRectangle() {
        return AlgoRectangle2D.createRectangle(this.point);
    }

    public void setRectangle(Rectangle2D r) {
        AlgoRectangle2D.setValues(r, this.point);
    }

    public double getSizeSq() {
        double sizeSq = Double.MIN_VALUE;
        int n = this.n();
        for (int i = 0; i < n; ++i) {
            double distSq = this.point[i].distanceSq(this.point[(i + 1) % n]);
            if (!(distSq > sizeSq)) continue;
            sizeSq = distSq;
        }
        return sizeSq;
    }

    public double getSize() {
        return Math.sqrt(this.getSizeSq());
    }

    boolean hasNeighbour(int side) {
        return this.neighbour[side] != null;
    }

    boolean hasEdge(Edge2D e) {
        int n = this.n();
        for (int i = 0; i < n; ++i) {
            if (this.neighbour[i] != e) continue;
            return true;
        }
        return false;
    }

    public boolean hasPoint(Node2D p) {
        int n = this.n();
        for (int i = 0; i < n; ++i) {
            if (p != this.point[i]) continue;
            return true;
        }
        return false;
    }

    public boolean hasEqualPoint(Point2D p) {
        int n = this.n();
        for (int i = 0; i < n; ++i) {
            if (!p.equals(this.point[i])) continue;
            return true;
        }
        return false;
    }

    public int getSide(Point2D p0, Point2D p1) {
        int i;
        int flag = 0;
        int n = this.n();
        for (i = 0; i < n; ++i) {
            if (!p0.equals(this.point[i])) continue;
            flag |= 1 << i;
            break;
        }
        for (i = 0; i < n; ++i) {
            if (!p1.equals(this.point[i])) continue;
            flag |= 1 << i;
            break;
        }
        for (i = 0; i < n; ++i) {
            if (flag != this.sideBits(i)) continue;
            return i;
        }
        return -1;
    }

    public int[] getSides(Node2D node) {
        int n = this.n();
        if (node == this.point[0]) {
            return new int[]{n - 1, 0};
        }
        for (int i = 1; i < n; ++i) {
            if (node != this.point[i]) continue;
            return new int[]{(i - 1) % n, i};
        }
        return null;
    }

    public int getSide(Edge2D e) {
        return this.getSide(e.getP1(), e.getP2());
    }

    public int getSide(Simplex2D f) {
        if (f != this) {
            int n = this.n();
            for (int i = 0; i < n; ++i) {
                Edge2D e;
                if (this.neighbour[i] == f) {
                    return i;
                }
                if (!(this.neighbour[i] instanceof Edge2D) || !(e = (Edge2D)this.neighbour[i]).hasSimplex(f)) continue;
                return i;
            }
        }
        throw new IllegalArgumentException("getSide(Simplex2D f)");
    }

    public Simplex2D getNeighbourSimplex(int side) {
        if (this.neighbour[side] instanceof Simplex2D) {
            return (Simplex2D)this.neighbour[side];
        }
        Edge2D e = (Edge2D)this.neighbour[side];
        return e == null ? null : e.getNeighborSimplex(this);
    }

    public Edge2D getNeighbourEdge(int side) {
        return this.neighbour[side] instanceof Edge2D ? (Edge2D)this.neighbour[side] : null;
    }

    public Node2D getNextPoint(Point2D p0, Point2D p1) {
        int n = this.n();
        for (int i = 0; i < n; ++i) {
            if (this.point[i] != p0) continue;
            if (this.point[(i + 1) % n] == p1) {
                return this.point[(i + 2) % n];
            }
            if (this.point[(i + n - 1) % n] == p1) {
                return this.point[(i + n - 2) % n];
            }
            return null;
        }
        return null;
    }

    protected void linkSimplex(int side, Simplex2D s) {
        this.neighbour[side] = s;
    }

    protected boolean linkSimplex(Simplex2D other) {
        int thisN = this.n();
        for (int thisSide = 0; thisSide < thisN; ++thisSide) {
            int otherN = other.n();
            for (int otherSide = 0; otherSide < otherN; ++otherSide) {
                if ((this.point[thisSide] != other.point[otherSide] || this.point[(thisSide + 1) % thisN] != other.point[(otherSide + 1) % otherN]) && (this.point[thisSide] != other.point[(otherSide + 1) % otherN] || this.point[(thisSide + 1) % thisN] != other.point[otherSide])) continue;
                this.neighbour[thisSide] = other;
                other.neighbour[otherSide] = this;
                return true;
            }
        }
        return false;
    }

    protected void linkEdge(int side, Edge2D e) {
        this.neighbour[side] = e;
    }

    protected void linkEdge(Edge2D e) {
        this.linkEdge(this.getSide(e.getP1(), e.getP2()), e);
    }

    protected void unlinkEdge(int side, Edge2D e) {
        if (this.neighbour[side] != e) {
            throw new IllegalArgumentException("error on unlink_edge");
        }
        this.neighbour[side] = null;
    }

    protected void unlinkEdge(Edge2D e) {
        int n = this.n();
        for (int i = 0; i < n; ++i) {
            if (this.neighbour[i] != e) continue;
            this.neighbour[i] = null;
            return;
        }
    }

    protected void swapSide(Edge2D e, Simplex2D f) {
        for (int i = 0; i < this.n(); ++i) {
            if (this.neighbour[i] != e) continue;
            this.neighbour[i] = f;
        }
    }

    public ArrayList<Simplex2D> getAllSimpliciesOnSimplex() {
        int n = this.n();
        ArrayList<Simplex2D> result = new ArrayList<Simplex2D>(n);
        for (int i = 0; i < n; ++i) {
            Simplex2D s = this.getNeighbourSimplex(i);
            if (s == null) continue;
            result.add(s);
        }
        return result;
    }

    public ArrayList<Edge2D> getAllEdgesOnFace() {
        int n = this.n();
        ArrayList<Edge2D> result = new ArrayList<Edge2D>(n);
        for (int i = 0; i < n; ++i) {
            Edge2D e = this.getNeighbourEdge(i);
            if (e == null) continue;
            result.add(e);
        }
        return result;
    }

    public ArrayList<Node2D> getAllPointsOnFace() {
        int n = this.n();
        ArrayList<Node2D> result = new ArrayList<Node2D>(n);
        for (int i = 0; i < n; ++i) {
            result.add(this.point[i]);
        }
        return result;
    }

    public int getOrientation(Node2D n0, Node2D n1) {
        int n = this.n();
        for (int i = 0; i < n; ++i) {
            if (this.point[i] == n0 && this.point[(i + 1) % n] == n1) {
                return 1;
            }
            if (this.point[i] != n1 || this.point[(i + 1) % n] != n0) continue;
            return -1;
        }
        return 0;
    }

    public int getOrientation(int s0, int s1) {
        return s0 < s1 || s0 == this.n() && s1 == 0 ? 1 : -1;
    }

    public int getOrientation(Simplex2D f0, Simplex2D f1) {
        int s0 = this.getSide(f0);
        int s1 = this.getSide(f1);
        if (s0 == -1 || s1 == -1) {
            throw new IllegalArgumentException("error on get_side(GenVertex *v0, GenVertex *v1)");
        }
        return this.getOrientation(s0, s1);
    }

    public int getOrientation(Simplex2D f) {
        int s0 = this.getSide(f);
        int s1 = f.getSide(this);
        if (s0 == -1 || s1 == -1) {
            return 0;
        }
        if (this.point[s0] == f.point[s1]) {
            return -1;
        }
        return 1;
    }

    public Point2D getCentroid() {
        Point2D.Double result = new Point2D.Double(0.0, 0.0);
        int n = this.n();
        for (int i = 0; i < n; ++i) {
            AlgoPoint2D.add((Point2D)result, this.point[i]);
        }
        return AlgoPoint2D.scale(result, 1.0 / (double)n);
    }

    public boolean hasID() {
        return this.id != -1;
    }
}

