/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.topograph2D.index;

import java.util.ArrayList;
import java.util.List;
import org.geotools.geometry.iso.topograph2D.Coordinate;
import org.geotools.geometry.iso.topograph2D.Quadrant;

public class MonotoneChainIndexer {
    public static int[] toIntArray(List list) {
        int[] array = new int[list.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (Integer)list.get(i);
        }
        return array;
    }

    public int[] getChainStartIndices(Coordinate[] pts) {
        int last;
        int start = 0;
        ArrayList<Integer> startIndexList = new ArrayList<Integer>();
        startIndexList.add(new Integer(start));
        do {
            last = this.findChainEnd(pts, start);
            startIndexList.add(new Integer(last));
        } while ((start = last) < pts.length - 1);
        int[] startIndex = MonotoneChainIndexer.toIntArray(startIndexList);
        return startIndex;
    }

    private int findChainEnd(Coordinate[] pts, int start) {
        int quad;
        int last;
        int chainQuad = Quadrant.quadrant(pts[start], pts[start + 1]);
        for (last = start + 1; last < pts.length && (quad = Quadrant.quadrant(pts[last - 1], pts[last])) == chainQuad; ++last) {
        }
        return last - 1;
    }
}

