/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.primitive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.geotools.geometry.iso.complex.CompositeCurveImpl;
import org.geotools.geometry.iso.coordinate.DirectPositionImpl;
import org.geotools.geometry.iso.coordinate.GeometryFactoryImpl;
import org.geotools.geometry.iso.coordinate.LineStringImpl;
import org.geotools.geometry.iso.io.GeometryToString;
import org.geotools.geometry.iso.primitive.CurveImpl;
import org.geotools.geometry.iso.primitive.PrimitiveFactoryImpl;
import org.geotools.geometry.iso.primitive.SurfaceBoundaryImpl;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Geometry;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.TransfiniteSet;
import org.opengis.geometry.complex.Complex;
import org.opengis.geometry.coordinate.LineSegment;
import org.opengis.geometry.coordinate.LineString;
import org.opengis.geometry.primitive.Curve;
import org.opengis.geometry.primitive.CurveBoundary;
import org.opengis.geometry.primitive.CurveSegment;
import org.opengis.geometry.primitive.OrientableCurve;
import org.opengis.geometry.primitive.Primitive;
import org.opengis.geometry.primitive.Ring;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class RingImplUnsafe
extends CompositeCurveImpl
implements Ring {
    private SurfaceBoundaryImpl surfaceBoundary;

    public RingImplUnsafe(List<OrientableCurve> generator) {
        super(generator);
    }

    @Override
    public RingImplUnsafe clone() throws CloneNotSupportedException {
        Iterator elementIter = this.getElements().iterator();
        ArrayList<OrientableCurve> newElements = new ArrayList<OrientableCurve>();
        while (elementIter.hasNext()) {
            newElements.add((OrientableCurve)((Curve)((Primitive)elementIter.next()).clone()));
        }
        return new RingImplUnsafe((List<OrientableCurve>)newElements);
    }

    @Override
    public CurveBoundary getBoundary() {
        return null;
    }

    @Override
    public Set<Complex> createBoundary() {
        return null;
    }

    public SurfaceBoundaryImpl getSurfaceBoundary() {
        return this.surfaceBoundary;
    }

    public void setSurfaceBoundary(SurfaceBoundaryImpl surfaceBoundary) {
        this.surfaceBoundary = surfaceBoundary;
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    @Override
    public boolean isCycle() {
        return true;
    }

    public List<DirectPosition> asDirectPositions() {
        ArrayList<DirectPosition> rList = new ArrayList<DirectPosition>();
        for (int i = 0; i < this.elements.size(); ++i) {
            CurveImpl tCurve = (CurveImpl)this.elements.get(i);
            Iterator<CurveSegment> tCurveSegmentIter = tCurve.getSegments().iterator();
            CurveSegment tSegment = null;
            while (tCurveSegmentIter.hasNext()) {
                tSegment = tCurveSegmentIter.next();
                LineStringImpl tLineString = (LineStringImpl)tSegment;
                for (LineSegment tLineSegment : tLineString.asLineSegments()) {
                    rList.add(tLineSegment.getStartPoint());
                }
            }
            rList.add(tSegment.getEndPoint());
        }
        return rList;
    }

    @Override
    public DirectPosition getRepresentativePoint() {
        return ((CurveImpl)this.getGenerators().get(0)).getStartPoint();
    }

    @Override
    public String toString() {
        return GeometryToString.getString(this);
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.surfaceBoundary == null ? 0 : this.surfaceBoundary.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RingImplUnsafe other = (RingImplUnsafe)obj;
        return !(this.surfaceBoundary == null ? other.surfaceBoundary != null : !this.surfaceBoundary.equals((TransfiniteSet)other.surfaceBoundary));
    }

    @Override
    public Geometry transform(CoordinateReferenceSystem newCRS, MathTransform transform) throws MismatchedDimensionException, TransformException {
        PrimitiveFactoryImpl primitiveFactory = new PrimitiveFactoryImpl(newCRS, this.getPositionFactory());
        GeometryFactoryImpl geometryFactory = new GeometryFactoryImpl(newCRS, this.getPositionFactory());
        DirectPositionImpl dp1 = null;
        List<DirectPosition> currentpositions = this.asDirectPositions();
        Iterator<DirectPosition> iter = currentpositions.iterator();
        ArrayList<DirectPositionImpl> newpositions = new ArrayList<DirectPositionImpl>();
        while (iter.hasNext()) {
            DirectPosition thispos = iter.next();
            dp1 = new DirectPositionImpl(newCRS);
            dp1 = (DirectPositionImpl)transform.transform(thispos, (DirectPosition)dp1);
            newpositions.add(dp1);
        }
        LineString lineString = geometryFactory.createLineString(newpositions);
        List<LineString> curveSegmentList = Collections.singletonList(lineString);
        CurveImpl newCurve = (CurveImpl)primitiveFactory.createCurve(curveSegmentList);
        ArrayList<CurveImpl> curveList = new ArrayList<CurveImpl>();
        curveList.add(newCurve);
        Ring newRing = primitiveFactory.createRing(curveList);
        return newRing;
    }
}

