/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import java.util.Calendar;
import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.PngHelperInternal;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.chunks.ChunkRaw;
import jogamp.opengl.util.pngj.chunks.PngChunk;
import jogamp.opengl.util.pngj.chunks.PngChunkSingle;

public class PngChunkTIME
extends PngChunkSingle {
    public static final String ID = "tIME";
    private int year;
    private int mon;
    private int day;
    private int hour;
    private int min;
    private int sec;

    public PngChunkTIME(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    @Override
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.NONE;
    }

    @Override
    public ChunkRaw createRawChunk() {
        ChunkRaw chunkRaw = this.createEmptyChunk(7, true);
        PngHelperInternal.writeInt2tobytes(this.year, chunkRaw.data, 0);
        chunkRaw.data[2] = (byte)this.mon;
        chunkRaw.data[3] = (byte)this.day;
        chunkRaw.data[4] = (byte)this.hour;
        chunkRaw.data[5] = (byte)this.min;
        chunkRaw.data[6] = (byte)this.sec;
        return chunkRaw;
    }

    @Override
    public void parseFromRaw(ChunkRaw chunkRaw) {
        if (chunkRaw.len != 7) {
            throw new PngjException("bad chunk " + chunkRaw);
        }
        this.year = PngHelperInternal.readInt2fromBytes(chunkRaw.data, 0);
        this.mon = PngHelperInternal.readInt1fromByte(chunkRaw.data, 2);
        this.day = PngHelperInternal.readInt1fromByte(chunkRaw.data, 3);
        this.hour = PngHelperInternal.readInt1fromByte(chunkRaw.data, 4);
        this.min = PngHelperInternal.readInt1fromByte(chunkRaw.data, 5);
        this.sec = PngHelperInternal.readInt1fromByte(chunkRaw.data, 6);
    }

    @Override
    public void cloneDataFromRead(PngChunk pngChunk) {
        PngChunkTIME pngChunkTIME = (PngChunkTIME)pngChunk;
        this.year = pngChunkTIME.year;
        this.mon = pngChunkTIME.mon;
        this.day = pngChunkTIME.day;
        this.hour = pngChunkTIME.hour;
        this.min = pngChunkTIME.min;
        this.sec = pngChunkTIME.sec;
    }

    public void setNow(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis() - 1000L * (long)n);
        this.year = calendar.get(1);
        this.mon = calendar.get(2) + 1;
        this.day = calendar.get(5);
        this.hour = calendar.get(11);
        this.min = calendar.get(12);
        this.sec = calendar.get(13);
    }

    public void setYMDHMS(int n, int n2, int n3, int n4, int n5, int n6) {
        this.year = n;
        this.mon = n2;
        this.day = n3;
        this.hour = n4;
        this.min = n5;
        this.sec = n6;
    }

    public int[] getYMDHMS() {
        return new int[]{this.year, this.mon, this.day, this.hour, this.min, this.sec};
    }

    public String getAsString() {
        return String.format("%04d/%02d/%02d %02d:%02d:%02d", this.year, this.mon, this.day, this.hour, this.min, this.sec);
    }
}

