/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast;

import com.jogamp.common.util.IntObjectHashMap;
import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.geom.SVertex;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.opengl.math.geom.AABBox;
import jogamp.graph.font.typecast.TypecastGlyph;
import jogamp.graph.font.typecast.TypecastHMetrics;
import jogamp.graph.font.typecast.TypecastRenderer;
import jogamp.graph.font.typecast.ot.OTFont;
import jogamp.graph.font.typecast.ot.OTFontCollection;
import jogamp.graph.font.typecast.ot.OTGlyph;
import jogamp.graph.font.typecast.ot.table.CmapFormat;
import jogamp.graph.font.typecast.ot.table.CmapIndexEntry;
import jogamp.graph.font.typecast.ot.table.CmapTable;
import jogamp.graph.font.typecast.ot.table.HdmxTable;
import jogamp.graph.geom.plane.AffineTransform;

class TypecastFont
implements Font {
    static final boolean DEBUG = false;
    private static final Vertex.Factory<SVertex> vertexFactory = SVertex.factory();
    final OTFont font;
    private final CmapFormat cmapFormat;
    private final int cmapentries;
    private final IntObjectHashMap char2Glyph;
    private final TypecastHMetrics metrics;
    private final float[] tmpV3 = new float[3];

    public TypecastFont(OTFontCollection oTFontCollection) {
        int n;
        this.font = oTFontCollection.getFont(0);
        CmapTable cmapTable = this.font.getCmapTable();
        CmapFormat[] cmapFormatArray = new CmapFormat[]{null, null, null, null};
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        for (n = 0; n < cmapTable.getNumTables(); ++n) {
            CmapIndexEntry cmapIndexEntry = cmapTable.getCmapIndexEntry(n);
            int n5 = cmapIndexEntry.getPlatformId();
            CmapFormat cmapFormat = cmapIndexEntry.getFormat();
            if (cmapFormatArray[n5] != null && cmapFormatArray[n5].getLength() >= cmapFormat.getLength()) continue;
            cmapFormatArray[n5] = cmapFormat;
            if (cmapFormat.getLength() <= n3) continue;
            n3 = cmapFormat.getLength();
            n2 = n5;
            n4 = cmapIndexEntry.getEncodingId();
        }
        if (0 <= n2) {
            this.cmapFormat = cmapFormatArray[n2];
        } else {
            CmapFormat cmapFormat = null;
            if (null == cmapFormat) {
                n2 = 3;
                n4 = 1;
                cmapFormat = cmapTable.getCmapFormat((short)n2, (short)n4);
            }
            if (null == cmapFormat) {
                n2 = 3;
                n4 = 0;
                cmapFormat = cmapTable.getCmapFormat((short)n2, (short)n4);
            }
            if (null == cmapFormat) {
                throw new RuntimeException("Cannot find a suitable cmap table for font " + this.font);
            }
            this.cmapFormat = cmapFormat;
        }
        n = 0;
        for (int i = 0; i < this.cmapFormat.getRangeCount(); ++i) {
            CmapFormat.Range range = this.cmapFormat.getRange(i);
            n += range.getEndCode() - range.getStartCode() + 1;
        }
        this.cmapentries = n;
        this.char2Glyph = new IntObjectHashMap(this.cmapentries + this.cmapentries / 4);
        this.metrics = new TypecastHMetrics(this);
    }

    @Override
    public StringBuilder getName(StringBuilder stringBuilder, int n) {
        return this.font.getName(n, stringBuilder);
    }

    @Override
    public String getName(int n) {
        return this.getName(null, n).toString();
    }

    @Override
    public StringBuilder getAllNames(StringBuilder stringBuilder, String string) {
        return this.font.getAllNames(stringBuilder, string);
    }

    @Override
    public StringBuilder getFullFamilyName(StringBuilder stringBuilder) {
        stringBuilder = this.getName(stringBuilder, 1).append("-");
        this.getName(stringBuilder, 2);
        return stringBuilder;
    }

    @Override
    public float getAdvanceWidth(int n, float f) {
        return (float)this.font.getHmtxTable().getAdvanceWidth(n) * this.metrics.getScale(f);
    }

    @Override
    public final Font.Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public Font.Glyph getGlyph(char c) {
        TypecastGlyph typecastGlyph = (TypecastGlyph)this.char2Glyph.get((int)c);
        if (null == typecastGlyph) {
            OTGlyph oTGlyph;
            short s = (short)this.cmapFormat.mapCharCode(c);
            if (0 == s && '\u0000' != c) {
                switch (c) {
                    case ' ': {
                        s = 3;
                        break;
                    }
                    case '\n': {
                        s = 2;
                        break;
                    }
                    default: {
                        s = 0;
                    }
                }
            }
            if (null == (oTGlyph = this.font.getGlyph(s))) {
                oTGlyph = this.font.getGlyph(0);
            }
            if (null == oTGlyph) {
                throw new RuntimeException("Could not retrieve glyph for symbol: <" + c + "> " + c + " -> glyph id " + s);
            }
            OutlineShape outlineShape = TypecastRenderer.buildShape(c, oTGlyph, vertexFactory);
            typecastGlyph = new TypecastGlyph(this, c, s, oTGlyph.getBBox(), oTGlyph.getAdvanceWidth(), outlineShape);
            oTGlyph.clearPointData();
            HdmxTable hdmxTable = this.font.getHdmxTable();
            if (null != typecastGlyph && null != hdmxTable) {
                for (int i = 0; i < hdmxTable.getNumberOfRecords(); ++i) {
                    HdmxTable.DeviceRecord deviceRecord = hdmxTable.getRecord(i);
                    typecastGlyph.addAdvance(deviceRecord.getWidth(s), deviceRecord.getPixelSize());
                }
            }
            this.char2Glyph.put((int)c, (Object)typecastGlyph);
        }
        return typecastGlyph;
    }

    @Override
    public final float getPixelSize(float f, float f2) {
        return f * f2 / 72.0f;
    }

    @Override
    public float getLineHeight(float f) {
        Font.Metrics metrics = this.getMetrics();
        float f2 = metrics.getLineGap(f);
        float f3 = metrics.getAscent(f);
        float f4 = metrics.getDescent(f);
        float f5 = f2 - f4 + f3;
        return -f5;
    }

    @Override
    public float getMetricWidth(CharSequence charSequence, float f) {
        float f2 = 0.0f;
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if (c == '\n') {
                f2 = 0.0f;
                continue;
            }
            Font.Glyph glyph = this.getGlyph(c);
            f2 += glyph.getAdvance(f, false);
        }
        return (int)(f2 + 0.5f);
    }

    @Override
    public float getMetricHeight(CharSequence charSequence, float f, AABBox aABBox) {
        int n = 0;
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c == ' ') continue;
            Font.Glyph glyph = this.getGlyph(c);
            AABBox aABBox2 = glyph.getBBox(aABBox, f, this.tmpV3);
            n = (int)Math.ceil(Math.max(aABBox2.getHeight(), (float)n));
        }
        return n;
    }

    @Override
    public AABBox getMetricBounds(CharSequence charSequence, float f) {
        if (charSequence == null) {
            return new AABBox();
        }
        int n = charSequence.length();
        float f2 = this.getLineHeight(f);
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if (c == '\n') {
                f4 = Math.max(f5, f4);
                f5 = 0.0f;
                f3 += f2;
                continue;
            }
            Font.Glyph glyph = this.getGlyph(c);
            f5 += glyph.getAdvance(f, true);
        }
        if (f5 > 0.0f) {
            f3 += f2;
            f4 = Math.max(f5, f4);
        }
        return new AABBox(0.0f, 0.0f, 0.0f, f4, f3, 0.0f);
    }

    @Override
    public AABBox getPointsBounds(AffineTransform affineTransform, CharSequence charSequence, float f, AffineTransform affineTransform2, AffineTransform affineTransform3) {
        if (charSequence == null) {
            return new AABBox();
        }
        int n = charSequence.length();
        float f2 = this.getLineHeight(f);
        float f3 = this.getMetrics().getScale(f);
        AABBox aABBox = new AABBox();
        AABBox aABBox2 = new AABBox();
        float f4 = 0.0f;
        float f5 = 0.0f;
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if ('\n' == c) {
                f4 -= f2;
                f5 = 0.0f;
                continue;
            }
            if (c == ' ') {
                f5 += this.getAdvanceWidth(3, f);
                continue;
            }
            if (null != affineTransform) {
                affineTransform2.setTransform(affineTransform);
            } else {
                affineTransform2.setToIdentity();
            }
            affineTransform2.translate(f5, f4, affineTransform3);
            affineTransform2.scale(f3, f3, affineTransform3);
            aABBox.reset();
            Font.Glyph glyph = this.getGlyph(c);
            aABBox2.resize(affineTransform2.transform(glyph.getBBox(), aABBox));
            OutlineShape outlineShape = glyph.getShape();
            if (null == outlineShape) continue;
            f5 += glyph.getAdvance(f, true);
        }
        return aABBox2;
    }

    @Override
    public final int getNumGlyphs() {
        return this.font.getNumGlyphs();
    }

    @Override
    public boolean isPrintableChar(char c) {
        return FontFactory.isPrintableChar(c);
    }

    @Override
    public String toString() {
        return this.getFullFamilyName(null).toString();
    }
}

