/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.util;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.nativewindow.NativeWindowFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import jogamp.newt.Debug;
import jogamp.newt.NEWTJNILibLoader;

public class MainThread {
    private static final String MACOSXDisplayClassName = "jogamp.newt.driver.macosx.DisplayDriver";
    private static final Platform.OSType osType;
    private static final boolean isMacOSX;
    private static final ThreadGroup rootThreadGroup;
    public static final boolean HINT_USE_MAIN_THREAD;
    public static boolean useMainThread;
    protected static final boolean DEBUG;
    private static final MainThread singletonMainThread;
    private static UserApp mainAction;

    private static final ThreadGroup getRootThreadGroup() {
        ThreadGroup threadGroup;
        ThreadGroup threadGroup2 = Thread.currentThread().getThreadGroup();
        while ((threadGroup = threadGroup2.getParent()) != null) {
            threadGroup2 = threadGroup;
        }
        return threadGroup2;
    }

    private static final Thread[] getAllThreads(int[] nArray) {
        int n;
        Thread[] threadArray = new Thread[rootThreadGroup.activeCount()];
        while ((n = rootThreadGroup.enumerate(threadArray, true)) == threadArray.length) {
            threadArray = new Thread[threadArray.length * 2];
        }
        nArray[0] = n;
        return threadArray;
    }

    private static final List<Thread> getNonDaemonThreads() {
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        int[] nArray = new int[]{0};
        Thread[] threadArray = MainThread.getAllThreads(nArray);
        for (int i = nArray[0] - 1; i >= 0; --i) {
            Thread thread = threadArray[i];
            try {
                if (!thread.isAlive() || thread.isDaemon()) continue;
                arrayList.add(thread);
                if (!DEBUG) continue;
                System.err.println("XXX0: " + thread.getName() + ", " + thread);
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return arrayList;
    }

    private static final int getNonDaemonThreadCount(List<Thread> list) {
        int n = 0;
        int[] nArray = new int[]{0};
        Thread[] threadArray = MainThread.getAllThreads(nArray);
        for (int i = nArray[0] - 1; i >= 0; --i) {
            Thread thread = threadArray[i];
            try {
                if (!thread.isAlive() || thread.isDaemon() || list.contains(thread)) continue;
                ++n;
                if (!DEBUG) continue;
                System.err.println("MainAction.run(): non daemon thread: " + thread);
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return n;
    }

    public static void main(String[] stringArray) throws SecurityException, NoSuchMethodException, ClassNotFoundException {
        Thread thread = Thread.currentThread();
        useMainThread = HINT_USE_MAIN_THREAD;
        if (DEBUG) {
            System.err.println("MainThread.main(): " + thread.getName() + ", useMainThread " + useMainThread + ", HINT_USE_MAIN_THREAD " + HINT_USE_MAIN_THREAD + ", isAWTAvailable " + NativeWindowFactory.isAWTAvailable() + ", ostype " + osType + ", isMacOSX " + isMacOSX);
        }
        if (!useMainThread && !NativeWindowFactory.isAWTAvailable()) {
            throw new RuntimeException("!USE_MAIN_THREAD and no AWT available");
        }
        if (stringArray.length == 0) {
            return;
        }
        String string = stringArray[0];
        String[] stringArray2 = new String[stringArray.length - 1];
        if (stringArray.length > 1) {
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
        }
        mainAction = new UserApp(string, stringArray2);
        if (isMacOSX) {
            ReflectionUtil.callStaticMethod((String)MACOSXDisplayClassName, (String)"initSingleton", null, null, (ClassLoader)MainThread.class.getClassLoader());
        }
        if (useMainThread) {
            try {
                thread.setName(thread.getName() + "-MainThread");
            }
            catch (Exception exception) {
                // empty catch block
            }
            mainAction.start();
            if (isMacOSX) {
                try {
                    if (DEBUG) {
                        System.err.println("MainThread.main(): " + thread.getName() + "- runNSApp");
                    }
                    ReflectionUtil.callStaticMethod((String)MACOSXDisplayClassName, (String)"runNSApplication", null, null, (ClassLoader)MainThread.class.getClassLoader());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (DEBUG) {
                System.err.println("MainThread - wait until last non daemon thread ends ...");
            }
        } else {
            mainAction.run();
        }
    }

    public static MainThread getSingleton() {
        return singletonMainThread;
    }

    static {
        NativeWindowFactory.initSingleton();
        NEWTJNILibLoader.loadNEWT();
        HINT_USE_MAIN_THREAD = !NativeWindowFactory.isAWTAvailable() || PropertyAccess.getBooleanProperty((String)"newt.MainThread.force", (boolean)true);
        osType = Platform.getOSType();
        isMacOSX = osType == Platform.OSType.MACOS;
        rootThreadGroup = MainThread.getRootThreadGroup();
        useMainThread = false;
        DEBUG = Debug.debug("MainThread");
        singletonMainThread = new MainThread();
    }

    static class UserApp
    extends InterruptSource.Thread {
        private final String mainClassNameShort;
        private final String mainClassName;
        private final String[] mainClassArgs;
        private final Method mainClassMain;
        private List<Thread> nonDaemonThreadsAtStart;

        public UserApp(String string, String[] stringArray) throws SecurityException, NoSuchMethodException, ClassNotFoundException {
            this.mainClassName = string;
            this.mainClassArgs = stringArray;
            Class clazz = ReflectionUtil.getClass((String)string, (boolean)true, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
            if (null == clazz) {
                throw new ClassNotFoundException("MainAction couldn't find main class " + string);
            }
            this.mainClassNameShort = clazz.getSimpleName();
            this.mainClassMain = clazz.getDeclaredMethod("main", String[].class);
            this.mainClassMain.setAccessible(true);
            this.setName(this.getName() + "-UserApp-" + this.mainClassNameShort);
            this.setDaemon(false);
            if (DEBUG) {
                System.err.println("MainAction(): instantiated: " + this.getName() + ", is daemon " + this.isDaemon() + ", main-class: " + clazz.getName());
            }
        }

        public void run() {
            int n;
            this.nonDaemonThreadsAtStart = MainThread.getNonDaemonThreads();
            if (DEBUG) {
                System.err.println("MainAction.run(): " + Thread.currentThread().getName() + " start, nonDaemonThreadsAtStart " + this.nonDaemonThreadsAtStart);
            }
            try {
                if (DEBUG) {
                    System.err.println("MainAction.run(): " + Thread.currentThread().getName() + " invoke " + this.mainClassName);
                }
                this.mainClassMain.invoke(null, new Object[]{this.mainClassArgs});
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.getTargetException().printStackTrace();
                return;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return;
            }
            while (0 < (n = MainThread.getNonDaemonThreadCount(this.nonDaemonThreadsAtStart))) {
                if (DEBUG) {
                    System.err.println("MainAction.run(): post user app, non daemon threads alive: " + n);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            if (DEBUG) {
                System.err.println("MainAction.run(): " + Thread.currentThread().getName() + " user app fin: " + n);
            }
            if (useMainThread) {
                if (isMacOSX) {
                    try {
                        if (DEBUG) {
                            System.err.println("MainAction.main(): " + Thread.currentThread() + " MainAction fin - stopNSApp.0");
                        }
                        ReflectionUtil.callStaticMethod((String)MainThread.MACOSXDisplayClassName, (String)"stopNSApplication", null, null, (ClassLoader)MainThread.class.getClassLoader());
                        if (DEBUG) {
                            System.err.println("MainAction.main(): " + Thread.currentThread() + " MainAction fin - stopNSApp.X");
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    if (DEBUG) {
                        System.err.println("MainAction.run(): " + Thread.currentThread().getName() + " MainAction fin - System.exit(0)");
                    }
                    System.exit(0);
                }
            }
        }
    }
}

