/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.plaf.UIResource;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.combo.SubstanceComboBoxButton;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.decoration.SubstanceDecorationUtilities;
import org.jvnet.substance.scroll.SubstanceScrollButton;
import org.jvnet.substance.theme.SubstanceShiftTheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.theme.ThemeInfo;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSpinnerButton;
import org.jvnet.substance.utils.SubstanceTitleButton;

public class SubstanceThemeUtilities {
    public static SubstanceTheme getDecorationTheme(Component component) {
        SubstanceTheme globalTheme = SubstanceLookAndFeel.getTheme();
        for (Component c = component; c != null; c = c.getParent()) {
            DecorationAreaType decorationType = SubstanceDecorationUtilities.getImmediateDecorationType(c);
            if (decorationType == null || !globalTheme.toUseDecorationPainter(decorationType)) continue;
            return globalTheme.getDecorationTheme(decorationType);
        }
        return null;
    }

    public static SubstanceTheme getNonColorizedTheme(Component component, boolean toReturnCurrent) {
        JComponent jcomp;
        Object controlThemeObj;
        Component comp;
        SubstanceTheme notColorized = null;
        if (component != null && (comp = component) instanceof JComponent && (controlThemeObj = (jcomp = (JComponent)comp).getClientProperty("substancelaf.theme")) != null) {
            if (controlThemeObj instanceof String) {
                notColorized = SubstanceTheme.getTheme((String)controlThemeObj);
            }
            if (controlThemeObj instanceof ThemeInfo) {
                notColorized = SubstanceTheme.createInstance((ThemeInfo)controlThemeObj);
            }
            if (controlThemeObj instanceof SubstanceTheme) {
                notColorized = (SubstanceTheme)controlThemeObj;
            }
        }
        if (notColorized == null && toReturnCurrent) {
            return SubstanceLookAndFeel.getTheme();
        }
        return notColorized;
    }

    public static SubstanceTheme getTheme(Component component) {
        SubstanceTheme theme = SubstanceThemeUtilities.getDecorationTheme(component);
        if (theme == null) {
            theme = SubstanceThemeUtilities.getNonColorizedTheme(component, true);
        }
        if (theme == null) {
            theme = SubstanceLookAndFeel.getTheme();
        }
        return SubstanceThemeUtilities.getColorizedTheme(component, theme);
    }

    public static SubstanceTheme getColorizedTheme(Component component, SubstanceTheme theme, ColorizationSupport support) {
        if (component != null) {
            double colorization;
            Color bk = support.getBackground(component);
            Color fg = support.getForeground(component);
            if (component instanceof SubstanceTitleButton && fg != null && bk != null) {
                fg = SubstanceColorUtilities.getInterpolatedColor(fg, bk, 0.5);
            }
            if (bk instanceof UIResource) {
                bk = null;
            }
            if (fg instanceof UIResource) {
                fg = null;
            }
            if ((bk != null || fg != null) && (colorization = SubstanceCoreUtilities.getColorizationFactor(component)) > 0.0) {
                return SubstanceShiftTheme.getShiftedTheme(theme, bk, colorization, fg, colorization);
            }
        }
        return theme;
    }

    public static SubstanceTheme getColorizedTheme(Component component, SubstanceTheme theme) {
        ColorizationSupport support = new ColorizationSupport(){

            private boolean toTakeFromParent(Component component) {
                return component.getParent() != null && (component instanceof SubstanceScrollButton || component instanceof SubstanceSpinnerButton || component instanceof SubstanceComboBoxButton || component instanceof SubstanceTitleButton);
            }

            public Color getBackground(Component component) {
                return this.toTakeFromParent(component) ? component.getParent().getBackground() : component.getBackground();
            }

            public Color getForeground(Component component) {
                return this.toTakeFromParent(component) ? component.getParent().getBackground() : component.getBackground();
            }
        };
        if (component != null) {
            double colorization;
            Color fg;
            boolean takeFromParent = component instanceof SubstanceScrollButton || component instanceof SubstanceSpinnerButton || component instanceof SubstanceComboBoxButton || component instanceof SubstanceTitleButton;
            takeFromParent = takeFromParent && component.getParent() != null;
            Color bk = takeFromParent ? component.getParent().getBackground() : component.getBackground();
            Color color = fg = takeFromParent ? component.getParent().getForeground() : component.getForeground();
            if (component instanceof SubstanceTitleButton && fg != null && bk != null) {
                fg = SubstanceColorUtilities.getInterpolatedColor(fg, bk, 0.5);
            }
            if (bk instanceof UIResource) {
                bk = null;
            }
            if (fg instanceof UIResource) {
                fg = null;
            }
            if ((bk != null || fg != null) && (colorization = SubstanceCoreUtilities.getColorizationFactor(component)) > 0.0) {
                return SubstanceShiftTheme.getShiftedTheme(theme, bk, colorization, fg, colorization);
            }
        }
        return theme;
    }

    public static SubstanceTheme getNonColorizedTheme(JTabbedPane jtp, int tabIndex) {
        SubstanceTheme compTheme = SubstanceThemeUtilities.getNonColorizedTheme(jtp.getComponentAt(tabIndex), false);
        if (compTheme != null) {
            return compTheme;
        }
        SubstanceTheme paneTheme = SubstanceThemeUtilities.getNonColorizedTheme((Component)jtp, true);
        return paneTheme;
    }

    public static SubstanceTheme getTheme(final JTabbedPane jtp, final int tabIndex, ComponentState componentState) {
        Component component = jtp.getComponent(tabIndex);
        SubstanceTheme nonColorized = SubstanceThemeUtilities.getNonColorizedTheme(jtp, tabIndex);
        if (SubstanceCoreUtilities.isControlAlwaysPaintedActive(component, true)) {
            componentState = componentState.isKindActive(FadeKind.ENABLE) ? ComponentState.SELECTED : ComponentState.DISABLED_SELECTED;
        }
        SubstanceTheme colorized = SubstanceThemeUtilities.getColorizedTheme(component, nonColorized, new ColorizationSupport(){

            public Color getBackground(Component component) {
                return jtp.getBackgroundAt(tabIndex);
            }

            public Color getForeground(Component component) {
                return jtp.getForegroundAt(tabIndex);
            }
        });
        return colorized.getTheme(component, componentState);
    }

    public static SubstanceTheme getTheme(Component component, ComponentState componentState) {
        return SubstanceThemeUtilities.getTheme(component, componentState, false);
    }

    public static SubstanceTheme getTheme(Component component, ComponentState componentState, boolean toIgnoreHighlights) {
        boolean isControlActive;
        if (component != null && SubstanceCoreUtilities.isControlAlwaysPaintedActive(component, true) && !componentState.isKindActive(FadeKind.PRESS) && componentState.isKindActive(FadeKind.ENABLE)) {
            componentState = ComponentState.ACTIVE;
        }
        SubstanceTheme theme = null;
        boolean bl = isControlActive = componentState.isKindActive(FadeKind.ENABLE) && componentState != ComponentState.DEFAULT;
        if (SubstanceCoreUtilities.hasFlatAppearance(component, false) && componentState == ComponentState.DEFAULT) {
            component = component.getParent();
        }
        boolean toUseDecorationTheme = false;
        DecorationAreaType decorationType = SubstanceDecorationUtilities.getDecorationType(component);
        if (decorationType != null) {
            toUseDecorationTheme = SubstanceLookAndFeel.getTheme().toUseDecorationThemeOnActiveControls(decorationType);
        }
        if (!isControlActive || toUseDecorationTheme) {
            theme = SubstanceThemeUtilities.getTheme(component);
        } else {
            theme = SubstanceThemeUtilities.getNonColorizedTheme(component, true);
            if (theme != null) {
                theme = SubstanceThemeUtilities.getColorizedTheme(component, theme);
            }
        }
        if (theme != null) {
            return theme.getTheme(component, componentState, toIgnoreHighlights);
        }
        return SubstanceLookAndFeel.getTheme();
    }

    public static SubstanceTheme getHighlightTheme(Component component, ComponentState componentState) {
        SubstanceTheme nonColorized = SubstanceThemeUtilities.getNonColorizedTheme(component, true);
        SubstanceTheme theme = SubstanceThemeUtilities.getColorizedTheme(component, nonColorized);
        if (theme != null) {
            return theme.getHighlightTheme(component, componentState);
        }
        return null;
    }

    public static float getHighlightAlpha(Component component, ComponentState componentState) {
        SubstanceTheme nonColorized = SubstanceThemeUtilities.getNonColorizedTheme(component, true);
        SubstanceTheme theme = SubstanceThemeUtilities.getColorizedTheme(component, nonColorized);
        if (theme != null) {
            return theme.getHighlightThemeAlpha(component, componentState);
        }
        return 0.0f;
    }

    public static SubstanceTheme getConstantTheme(SubstanceTheme theme) {
        return new ConstantThemeWrapper(theme);
    }

    private static class ConstantThemeWrapper
    extends SubstanceTheme {
        private SubstanceTheme delegate;

        public ConstantThemeWrapper(SubstanceTheme delegate) {
            super(delegate.getColorScheme(), "Wrapper " + delegate.getDisplayName(), delegate.getKind());
            this.delegate = delegate;
        }

        public SubstanceTheme getActiveTheme() {
            return this.delegate;
        }

        public SubstanceTheme getActiveTitlePaneTheme() {
            return this.delegate;
        }

        public SubstanceTheme getBorderTheme() {
            return this.delegate;
        }

        public SubstanceTheme getDecorationTheme(DecorationAreaType decorationType) {
            return this.delegate;
        }

        public SubstanceTheme getDefaultTheme() {
            return this.delegate;
        }

        public SubstanceTheme getDefaultTitlePaneTheme() {
            return this.delegate;
        }

        public SubstanceTheme getDisabledTheme() {
            return this.delegate.getDisabledTheme();
        }

        public SubstanceTheme getFirstTheme() {
            return this.delegate;
        }

        public SubstanceTheme getHighlightTheme(Component comp, ComponentState componentState) {
            return this.delegate;
        }

        public SubstanceTheme getSecondTheme() {
            return this.delegate;
        }

        public SubstanceTheme getTheme(Component comp, ComponentState componentState) {
            if (!componentState.isKindActive(FadeKind.ENABLE)) {
                return this.delegate.getDisabledTheme();
            }
            return this.delegate;
        }

        public SubstanceTheme getTheme(Component comp, ComponentState componentState, boolean toIgnoreHighlights) {
            if (!componentState.isKindActive(FadeKind.ENABLE)) {
                return this.delegate.getDisabledTheme();
            }
            return this.delegate;
        }

        public float getThemeAlpha(Component comp, ComponentState componentState) {
            return this.delegate.getThemeAlpha(comp, componentState);
        }

        public SubstanceTheme getWatermarkTheme() {
            return this.delegate;
        }
    }

    public static interface ColorizationSupport {
        public Color getBackground(Component var1);

        public Color getForeground(Component var1);
    }
}

