/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.theme;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.jvnet.substance.color.ShiftColorScheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.theme.SubstanceWrapperTheme;

public class SubstanceShiftTheme
extends SubstanceWrapperTheme {
    private double backgroundShiftFactor;
    private Color backgroundShiftColor;
    private double foregroundShiftFactor;
    private Color foregroundShiftColor;
    protected static Map<String, SubstanceTheme> shiftedCache = new HashMap<String, SubstanceTheme>();

    SubstanceShiftTheme(SubstanceTheme substanceTheme, Color backgroundShiftColor, double backgroundShiftFactor, Color foregroundShiftColor, double foregroundShiftFactor) {
        super(substanceTheme, new ShiftColorScheme(substanceTheme.getColorScheme(), backgroundShiftColor, backgroundShiftFactor, foregroundShiftColor, foregroundShiftFactor, true), "Shift " + substanceTheme.getDisplayName() + " to [" + backgroundShiftColor + "] " + (int)(100.0 * backgroundShiftFactor) + "% * [" + foregroundShiftColor + "]" + (int)(100.0 * foregroundShiftFactor) + "%", substanceTheme.getKind());
        this.backgroundShiftColor = backgroundShiftColor;
        this.backgroundShiftFactor = backgroundShiftFactor;
        this.foregroundShiftColor = foregroundShiftColor;
        this.foregroundShiftFactor = foregroundShiftFactor;
    }

    public SubstanceTheme getDefaultTheme() {
        if (this.defaultTheme == null) {
            this.defaultTheme = this.originalTheme.getDefaultTheme().shift(this.backgroundShiftColor, this.backgroundShiftFactor, this.foregroundShiftColor, this.foregroundShiftFactor);
        }
        return this.defaultTheme;
    }

    public SubstanceTheme getDisabledTheme() {
        if (this.disabledTheme == null) {
            this.disabledTheme = this.originalTheme.getDisabledTheme().shift(this.backgroundShiftColor, this.backgroundShiftFactor / 2.0, this.foregroundShiftColor, this.foregroundShiftFactor / 2.0);
        }
        return this.disabledTheme;
    }

    public static synchronized SubstanceTheme getShiftedTheme(SubstanceTheme orig, Color backgroundShiftColor, double backgroundShiftFactor, Color foregroundShiftColor, double foregroundShiftFactor) {
        String key = orig.getDisplayName() + ":" + backgroundShiftColor + ":" + backgroundShiftFactor + ":" + foregroundShiftColor + ":" + foregroundShiftFactor;
        SubstanceTheme result = shiftedCache.get(key);
        if (result == null) {
            result = orig.shift(backgroundShiftColor, backgroundShiftFactor, foregroundShiftColor, foregroundShiftFactor);
            shiftedCache.put(key, result);
        }
        return result;
    }
}

