/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painter.text;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.painter.text.AbstractTextPainter;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class DefaultTextPainter
extends AbstractTextPainter {
    public boolean needsBackgroundImage() {
        return false;
    }

    public void setBackgroundFill(JComponent comp, Color backgroundFillColor, boolean toOverlayWatermark, int watermarkOffsetX, int watermarkOffsetY) {
    }

    public void renderSurface(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        SubstanceCoreUtilities.workaroundBug6576507(g2d);
        RenderingUtils.installDesktopHints(g2d);
        for (AbstractTextPainter.TextLineInfo lineInfo : this.textLines) {
            String text;
            g2d.setFont(lineInfo.font);
            g2d.setColor(lineInfo.color);
            if (lineInfo.clip != null) {
                g2d.setClip(lineInfo.clip);
            }
            AffineTransform currTransform = g2d.getTransform();
            if (lineInfo.transform != null) {
                g2d.transform(lineInfo.transform);
            }
            if ((text = lineInfo.text) != null && text.length() > 0) {
                BasicGraphicsUtils.drawStringUnderlineCharAt(g2d, lineInfo.text, lineInfo.mnemonicIndex, lineInfo.textRect.x, lineInfo.textRect.y + g2d.getFontMetrics().getAscent());
            }
            g2d.setTransform(currTransform);
        }
        g2d.dispose();
    }

    public void attachVerticalText(JComponent comp, Rectangle textRect, String text, int mnemonicIndex, Font font, Color color, Rectangle clip, boolean isFromBottomToTop) {
        AffineTransform at = null;
        if (!isFromBottomToTop) {
            at = AffineTransform.getTranslateInstance(textRect.x + textRect.width, textRect.y);
            at.rotate(1.5707963267948966);
        } else {
            at = AffineTransform.getTranslateInstance(textRect.x, textRect.y + textRect.height);
            at.rotate(-1.5707963267948966);
        }
        Rectangle newRect = new Rectangle(0, 0, textRect.width, textRect.height);
        this.textLines.add(new AbstractTextPainter.TextLineInfo(newRect, text, mnemonicIndex, font, color, clip, at));
    }

    public boolean isNative() {
        return false;
    }

    public void dispose() {
    }

    public Dimension getTextBounds(Component comp, Font font, String text) {
        FontMetrics fm = comp.getFontMetrics(font);
        return new Dimension(fm.stringWidth(text), fm.getHeight());
    }
}

