/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painter.highlight;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.border.SubstanceBorderPainter;
import org.jvnet.substance.button.BaseButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.painter.ClassicGradientPainter;
import org.jvnet.substance.painter.highlight.SubstanceHighlightPainter;
import org.jvnet.substance.utils.SoftHashMap;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassicHighlightPainter
implements SubstanceHighlightPainter {
    public static final String DISPLAY_NAME = "Classic";
    protected static Map<String, BufferedImage> smallImageCache = new SoftHashMap<String, BufferedImage>();
    protected ClassicGradientPainter painter = new ClassicGradientPainter();

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintHighlight(Graphics2D graphics, Component comp, int width, int height, float borderAlpha, Set<SubstanceConstants.Side> openSides, ColorScheme colorScheme1, ColorScheme colorScheme2, float cyclePos) {
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(comp);
        int size = Math.max(width, height);
        if (openSides == null) {
            openSides = new HashSet<SubstanceConstants.Side>();
        }
        if (size < 150) {
            ClassicHighlightPainter classicHighlightPainter = this;
            synchronized (classicHighlightPainter) {
                String openKey = "";
                for (SubstanceConstants.Side oSide : openSides) {
                    openKey = openKey + oSide.name() + "-";
                }
                String key = width + "*" + height + "*" + SubstanceCoreUtilities.getSchemeId(colorScheme1) + "*" + SubstanceCoreUtilities.getSchemeId(colorScheme2) + "*" + cyclePos + "*" + borderAlpha + "*" + openKey + "*" + borderPainter.getDisplayName();
                BufferedImage result = smallImageCache.get(key);
                if (result == null) {
                    result = SubstanceCoreUtilities.getBlankImage(width, height);
                    this.internalPaint((Graphics2D)result.getGraphics(), comp, width, height, colorScheme1, colorScheme2, cyclePos, borderPainter, borderAlpha, openSides);
                    smallImageCache.put(key, result);
                }
                graphics.drawImage((Image)result, 0, 0, null);
                return;
            }
        }
        this.internalPaint(graphics, comp, width, height, colorScheme1, colorScheme2, cyclePos, borderPainter, borderAlpha, openSides);
    }

    protected void internalPaint(Graphics2D graphics, Component comp, int width, int height, ColorScheme colorScheme1, ColorScheme colorScheme2, float cyclePos, SubstanceBorderPainter borderPainter, float borderAlpha, Set<SubstanceConstants.Side> openSides) {
        graphics.drawImage((Image)this.painter.getContourBackground(width + 6, height + 6, new Rectangle(width + 6, height + 6), false, colorScheme1, colorScheme2, cyclePos, false, true), -3, -3, null);
        if (borderAlpha > 0.0f) {
            int openDelta = 3 + (int)Math.ceil(3.0 * (double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(comp)));
            int deltaLeft = openSides.contains((Object)SubstanceConstants.Side.LEFT) ? openDelta : 0;
            int deltaRight = openSides.contains((Object)SubstanceConstants.Side.RIGHT) ? openDelta : 0;
            int deltaTop = openSides.contains((Object)SubstanceConstants.Side.TOP) ? openDelta : 0;
            int deltaBottom = openSides.contains((Object)SubstanceConstants.Side.BOTTOM) ? openDelta : 0;
            int borderDelta = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(comp)) / 2.0);
            GeneralPath contour = BaseButtonShaper.getBaseOutline(width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, 0.0f, null, borderDelta);
            graphics.translate(-deltaLeft, -deltaTop);
            if (borderAlpha > 0.0f) {
                Graphics2D g2d = (Graphics2D)graphics.create();
                g2d.setComposite(TransitionLayout.getAlphaComposite(null, borderAlpha, graphics));
                int borderThickness = (int)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(comp));
                GeneralPath contourInner = BaseButtonShaper.getBaseOutline(width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, 0.0f, null, borderDelta + borderThickness);
                borderPainter.paintBorder(g2d, comp, width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, contour, contourInner, colorScheme1, colorScheme2, cyclePos, true);
                g2d.dispose();
            }
        }
    }

    public static synchronized void reset() {
        smallImageCache.clear();
    }

    public static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("ClassicHighlightPainter: \n");
        sb.append("\t" + smallImageCache.size() + " regular");
        return sb.toString();
    }
}

