/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painter.decoration;

import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.decoration.SubstanceDecorationPainter;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class ArcDecorationPainter
implements SubstanceDecorationPainter {
    public static final String DISPLAY_NAME = "Arc";

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public void paintDecorationArea(Graphics2D graphics, Component comp, DecorationAreaType decorationAreaType, int width, int height, SubstanceTheme theme) {
        switch (decorationAreaType) {
            case PRIMARY_TITLE_PANE: 
            case SECONDARY_TITLE_PANE: {
                this.paintTitleBackground(graphics, comp, width, height, theme);
                break;
            }
            default: {
                this.paintExtraBackground(graphics, SubstanceCoreUtilities.getHeaderParent(comp), comp, width, height, theme);
            }
        }
    }

    private void paintTitleBackground(Graphics2D graphics, Component comp, int width, int height, SubstanceTheme theme) {
        BufferedImage rectangular = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D rgraphics = (Graphics2D)rectangular.getGraphics();
        rgraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ColorScheme scheme = theme.getColorScheme();
        GeneralPath clipTop = new GeneralPath();
        clipTop.moveTo(0.0f, 0.0f);
        clipTop.lineTo(width, 0.0f);
        clipTop.lineTo(width, height / 2);
        clipTop.quadTo(width / 2, height / 4, 0.0f, height / 2);
        clipTop.lineTo(0.0f, 0.0f);
        rgraphics.setClip(clipTop);
        GradientPaint gradientTopLeft = new GradientPaint(0.0f, 0.0f, scheme.getLightColor(), width / 2, 0.0f, scheme.getUltraLightColor());
        rgraphics.setPaint(gradientTopLeft);
        rgraphics.fillRect(0, 0, width / 2, height);
        GradientPaint gradientTopRight = new GradientPaint(width / 2, 0.0f, scheme.getUltraLightColor(), width, 0.0f, scheme.getLightColor());
        rgraphics.setPaint(gradientTopRight);
        rgraphics.fillRect(width / 2, 0, width - width / 2, height);
        GradientPaint gradientBottomLeft = new GradientPaint(0.0f, height / 2, scheme.getMidColor(), width / 2, height / 2, scheme.getLightColor());
        GradientPaint gradientBottomRight = new GradientPaint(width / 2, height / 2, scheme.getLightColor(), width, height / 2, scheme.getMidColor());
        GeneralPath clipBottom = new GeneralPath();
        clipBottom.moveTo(0.0f, height);
        clipBottom.lineTo(width, height);
        clipBottom.lineTo(width, height / 2);
        clipBottom.quadTo(width / 2, height / 4, 0.0f, height / 2);
        clipBottom.lineTo(0.0f, height);
        rgraphics.setClip(clipBottom);
        rgraphics.setPaint(gradientBottomLeft);
        rgraphics.fillRect(0, 0, width / 2, height);
        rgraphics.setPaint(gradientBottomRight);
        rgraphics.fillRect(width / 2, 0, width - width / 2, height);
        GeneralPath mid = new GeneralPath();
        mid.moveTo(width, height / 2);
        mid.quadTo(width / 2, height / 4, 0.0f, height / 2);
        rgraphics.setPaint(gradientBottomLeft);
        rgraphics.setClip(new Rectangle(0, 0, width / 2, height));
        rgraphics.draw(mid);
        rgraphics.setPaint(gradientBottomRight);
        rgraphics.setClip(new Rectangle(width / 2, 0, width - width / 2, height));
        rgraphics.draw(mid);
        graphics.drawImage((Image)rectangular, 0, 0, null);
    }

    private void paintExtraBackground(Graphics2D graphics, Container parent, Component comp, int width, int height, SubstanceTheme theme) {
        JRootPane rootPane = SwingUtilities.getRootPane(parent);
        int dx = 0;
        JComponent titlePane = null;
        if (rootPane != null && (titlePane = SubstanceCoreUtilities.getTitlePane(rootPane)) != null) {
            if (comp.isShowing() && titlePane.isShowing()) {
                dx += comp.getLocationOnScreen().x - titlePane.getLocationOnScreen().x;
            } else {
                Component c;
                dx = 0;
                for (c = comp; c != rootPane; c = c.getParent()) {
                    dx += c.getX();
                }
                for (c = titlePane; c != rootPane; c = c.getParent()) {
                    dx -= c.getX();
                }
            }
        }
        int pWidth = titlePane == null ? parent.getWidth() : titlePane.getWidth();
        ColorScheme scheme = theme.getColorScheme();
        GradientPaint gradientBottomLeft = new GradientPaint(-dx, 0.0f, scheme.getMidColor(), -dx + pWidth / 2, 0.0f, scheme.getLightColor());
        GradientPaint gradientBottomRight = new GradientPaint(-dx + pWidth / 2, 0.0f, scheme.getLightColor(), -dx + pWidth, 0.0f, scheme.getMidColor());
        graphics.setPaint(gradientBottomLeft);
        graphics.fillRect(-dx, 0, pWidth / 2, height);
        graphics.setPaint(gradientBottomRight);
        graphics.fillRect(-dx + pWidth / 2, 0, pWidth - pWidth / 2, height);
    }
}

