/*
 * Decompiled with CFR 0.152.
 */
package contrib.ch.randelshofer.quaqua;

import contrib.ch.randelshofer.quaqua.colorchooser.ColorChooserMainPanel;
import contrib.ch.randelshofer.quaqua.colorchooser.QuaquaColorPreviewPanel;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ColorChooserUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.RenderingUtils;

public class Quaqua13ColorChooserUI
extends ColorChooserUI {
    protected Set lafWidgets;
    protected ColorChooserMainPanel mainPanel;
    protected JColorChooser chooser;
    protected ChangeListener previewListener;
    protected PropertyChangeListener propertyChangeListener;
    protected AbstractColorChooserPanel[] defaultChoosers;
    protected JComponent previewPanel;

    public void __contrib__ch__randelshofer__quaqua__Quaqua13ColorChooserUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, f));
        object = RenderingUtils.installDesktopHints(graphics2D);
        this.__contrib__ch__randelshofer__quaqua__Quaqua13ColorChooserUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__contrib__ch__randelshofer__quaqua__Quaqua13ColorChooserUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.__contrib__ch__randelshofer__quaqua__Quaqua13ColorChooserUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    public void installListeners() {
        this.__contrib__ch__randelshofer__quaqua__Quaqua13ColorChooserUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    public void installDefaults() {
        this.__contrib__ch__randelshofer__quaqua__Quaqua13ColorChooserUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    public void uninstallListeners() {
        this.__contrib__ch__randelshofer__quaqua__Quaqua13ColorChooserUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void uninstallDefaults() {
        this.__contrib__ch__randelshofer__quaqua__Quaqua13ColorChooserUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new Quaqua13ColorChooserUI();
    }

    public void __contrib__ch__randelshofer__quaqua__Quaqua13ColorChooserUI__installUI(JComponent c) {
        this.chooser = (JColorChooser)c;
        this.installDefaults();
        this.installListeners();
        this.chooser.setLayout(new BorderLayout());
        this.mainPanel = new ColorChooserMainPanel();
        this.chooser.add(this.mainPanel);
        this.defaultChoosers = this.createDefaultChoosers();
        this.chooser.setChooserPanels(this.defaultChoosers);
        this.installPreviewPanel();
    }

    protected AbstractColorChooserPanel[] createDefaultChoosers() {
        String[] defaultChoosers = (String[])UIManager.get("ColorChooser.defaultChoosers");
        ArrayList panels = new ArrayList(defaultChoosers.length);
        for (int i = 0; i < defaultChoosers.length; ++i) {
            try {
                panels.add(Class.forName(defaultChoosers[i]).newInstance());
                continue;
            }
            catch (AccessControlException e) {
                System.err.println("Quaqua13ColorChooserUI warning: unable to instantiate " + defaultChoosers[i]);
                continue;
            }
            catch (Exception e) {
                throw new InternalError("Unable to instantiate " + defaultChoosers[i]);
            }
            catch (UnsupportedClassVersionError e) {
                System.err.println("Quaqua13ColorChooserUI warning: unable to instantiate " + defaultChoosers[i]);
            }
        }
        return panels.toArray(new AbstractColorChooserPanel[panels.size()]);
    }

    public void __contrib__ch__randelshofer__quaqua__Quaqua13ColorChooserUI__uninstallUI(JComponent c) {
        this.chooser.remove(this.mainPanel);
        this.uninstallListeners();
        this.uninstallDefaultChoosers();
        this.uninstallDefaults();
        this.mainPanel.setPreviewPanel(null);
        if (this.previewPanel instanceof UIResource) {
            this.chooser.setPreviewPanel(null);
        }
        this.mainPanel = null;
        this.previewPanel = null;
        this.defaultChoosers = null;
        this.chooser = null;
    }

    protected void __contrib__ch__randelshofer__quaqua__Quaqua13ColorChooserUI__installDefaults() {
        LookAndFeel.installColorsAndFont(this.chooser, "ColorChooser.background", "ColorChooser.foreground", "ColorChooser.font");
    }

    protected void __contrib__ch__randelshofer__quaqua__Quaqua13ColorChooserUI__uninstallDefaults() {
    }

    protected void __contrib__ch__randelshofer__quaqua__Quaqua13ColorChooserUI__installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.chooser.addPropertyChangeListener(this.propertyChangeListener);
        this.previewListener = new PreviewListener();
        this.chooser.getSelectionModel().addChangeListener(this.previewListener);
    }

    protected void __contrib__ch__randelshofer__quaqua__Quaqua13ColorChooserUI__uninstallListeners() {
        this.chooser.removePropertyChangeListener(this.propertyChangeListener);
        this.chooser.getSelectionModel().removeChangeListener(this.previewListener);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyHandler();
    }

    protected void installPreviewPanel() {
        if (this.previewPanel != null) {
            this.mainPanel.setPreviewPanel(null);
        }
        this.previewPanel = this.chooser.getPreviewPanel();
        if (this.previewPanel != null && this.mainPanel != null && this.chooser != null && this.previewPanel.getSize().getHeight() + this.previewPanel.getSize().getWidth() == 0.0) {
            this.mainPanel.setPreviewPanel(null);
            return;
        }
        if (this.previewPanel == null || this.previewPanel instanceof UIResource) {
            this.previewPanel = new QuaquaColorPreviewPanel();
            this.chooser.setPreviewPanel(this.previewPanel);
        }
        this.previewPanel.setForeground(this.chooser.getColor());
        this.mainPanel.setPreviewPanel(this.previewPanel);
    }

    protected void uninstallDefaultChoosers() {
        for (int i = 0; i < this.defaultChoosers.length; ++i) {
            this.chooser.removeChooserPanel(this.defaultChoosers[i]);
        }
    }

    public class PropertyHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("chooserPanels")) {
                int i;
                AbstractColorChooserPanel[] oldPanels = (AbstractColorChooserPanel[])e.getOldValue();
                AbstractColorChooserPanel[] newPanels = (AbstractColorChooserPanel[])e.getNewValue();
                for (i = 0; i < oldPanels.length; ++i) {
                    Container wrapper = oldPanels[i].getParent();
                    if (wrapper == null) continue;
                    Container parent = wrapper.getParent();
                    if (parent != null) {
                        parent.remove(wrapper);
                    }
                    oldPanels[i].uninstallChooserPanel(Quaqua13ColorChooserUI.this.chooser);
                }
                Quaqua13ColorChooserUI.this.mainPanel.removeAllColorChooserPanels();
                for (i = 0; i < newPanels.length; ++i) {
                    if (newPanels[i] == null) continue;
                    Quaqua13ColorChooserUI.this.mainPanel.addColorChooserPanel(newPanels[i]);
                }
                for (i = 0; i < newPanels.length; ++i) {
                    if (newPanels[i] == null) continue;
                    newPanels[i].installChooserPanel(Quaqua13ColorChooserUI.this.chooser);
                }
            }
            if (e.getPropertyName().equals("previewPanel") && e.getNewValue() != Quaqua13ColorChooserUI.this.previewPanel) {
                Quaqua13ColorChooserUI.this.installPreviewPanel();
            }
        }
    }

    class PreviewListener
    implements ChangeListener {
        PreviewListener() {
        }

        public void stateChanged(ChangeEvent e) {
            ColorSelectionModel model = (ColorSelectionModel)e.getSource();
            if (Quaqua13ColorChooserUI.this.previewPanel != null) {
                Quaqua13ColorChooserUI.this.previewPanel.setForeground(model.getSelectedColor());
                Quaqua13ColorChooserUI.this.previewPanel.repaint();
            }
        }
    }
}

