/*
 * Decompiled with CFR 0.152.
 */
package tests.detailed.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.cef.callback.CefWebPluginInfoVisitor;
import org.cef.network.CefWebPluginInfo;
import org.cef.network.CefWebPluginManager;

public class WebPluginManagerDialog
extends JDialog {
    private final CefWebPluginManager manager = CefWebPluginManager.getGlobalManager();
    private final PluginTableModel tblModel = new PluginTableModel();

    public WebPluginManagerDialog(Frame owner, String title) {
        super(owner, title, false);
        this.setLayout(new BorderLayout());
        this.setSize(800, 600);
        JTable pluginTable = new JTable(this.tblModel);
        pluginTable.setFillsViewportHeight(true);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        JButton delButton = new JButton("Remove selected plugins");
        delButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebPluginManagerDialog.this.tblModel.removeSelected();
            }
        });
        controlPanel.add(delButton);
        JButton doneButton = new JButton("Done");
        doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebPluginManagerDialog.this.setVisible(false);
            }
        });
        controlPanel.add(doneButton);
        this.add(new JScrollPane(pluginTable));
        this.add((Component)controlPanel, "South");
        if (this.manager == null) {
            throw new NullPointerException("Plugin manager is null");
        }
        this.manager.visitPlugins((CefWebPluginInfoVisitor)this.tblModel);
    }

    private class PluginTableModel
    extends AbstractTableModel
    implements CefWebPluginInfoVisitor {
        private final String[] columnNames;
        private Vector<Object[]> rowData = new Vector();

        public PluginTableModel() {
            this.columnNames = new String[]{"Name", "Path", "Version", "Description", ""};
        }

        public boolean visit(CefWebPluginInfo info, int count, int total) {
            Object[] entry = new Object[]{info.getName(), info.getPath(), info.getVersion(), info.getDescription(), new Boolean(false)};
            int row = this.rowData.size();
            this.rowData.addElement(entry);
            this.fireTableRowsInserted(row, row);
            return true;
        }

        public void removeSelected() {
            for (int i = 0; i < this.rowData.size(); ++i) {
                if (!((Boolean)this.rowData.get(i)[4]).booleanValue()) continue;
                String path = (String)this.rowData.get(i)[1];
                this.rowData.remove(i);
                this.fireTableRowsDeleted(i, i);
                --i;
            }
            WebPluginManagerDialog.this.manager.refreshPlugins();
        }

        @Override
        public int getRowCount() {
            return this.rowData.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (this.rowData.size() > 0) {
                return this.rowData.get(0)[columnIndex].getClass();
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 4;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.rowData.get(rowIndex)[columnIndex];
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.rowData.get((int)rowIndex)[columnIndex] = aValue;
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }
}

