/*
 * Decompiled with CFR 0.152.
 */
package tests.detailed.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.cef.callback.CefAuthCallback;
import org.cef.callback.CefURLRequestClient;
import org.cef.network.CefRequest;
import org.cef.network.CefResponse;
import org.cef.network.CefURLRequest;
import tests.detailed.dialog.PasswordDialog;

public class UrlRequestDialogReply
extends JDialog
implements CefURLRequestClient {
    private long nativeRef_ = 0L;
    private final JLabel statusLabel_ = new JLabel("HTTP-Request status: ");
    private final JTextArea sentRequest_ = new JTextArea();
    private final JTextArea repliedResult_ = new JTextArea();
    private final JButton cancelButton_ = new JButton("Cancel");
    private CefURLRequest urlRequest_ = null;
    private final Frame owner_;
    private ByteArrayOutputStream byteStream_ = new ByteArrayOutputStream();

    public UrlRequestDialogReply(Frame owner, String title) {
        super(owner, title, false);
        this.setLayout(new BorderLayout());
        this.setSize(800, 600);
        this.owner_ = owner;
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        JButton doneButton = new JButton("Done");
        doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UrlRequestDialogReply.this.urlRequest_.dispose();
                UrlRequestDialogReply.this.setVisible(false);
                UrlRequestDialogReply.this.dispose();
            }
        });
        controlPanel.add(doneButton);
        this.cancelButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UrlRequestDialogReply.this.urlRequest_ != null) {
                    UrlRequestDialogReply.this.urlRequest_.cancel();
                }
            }
        });
        this.cancelButton_.setEnabled(false);
        controlPanel.add(this.cancelButton_);
        JPanel requestPane = this.createPanelWithTitle("Sent HTTP-Request", 1, 0);
        requestPane.add(new JScrollPane(this.sentRequest_));
        JPanel replyPane = this.createPanelWithTitle("Reply from the server", 1, 0);
        replyPane.add(new JScrollPane(this.repliedResult_));
        JPanel contentPane = new JPanel(new GridLayout(2, 0));
        contentPane.add(requestPane);
        contentPane.add(replyPane);
        this.add((Component)this.statusLabel_, "First");
        this.add((Component)contentPane, "Center");
        this.add((Component)controlPanel, "Last");
    }

    private JPanel createPanelWithTitle(String title, int rows, int cols) {
        JPanel result = new JPanel(new GridLayout(rows, cols));
        result.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(title), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        return result;
    }

    public void send(CefRequest request) {
        if (request == null) {
            this.statusLabel_.setText("HTTP-Request status: FAILED");
            this.sentRequest_.append("Can't send CefRequest because it is NULL");
            this.cancelButton_.setEnabled(false);
            return;
        }
        this.urlRequest_ = CefURLRequest.create((CefRequest)request, (CefURLRequestClient)this);
        if (this.urlRequest_ == null) {
            this.statusLabel_.setText("HTTP-Request status: FAILED");
            this.sentRequest_.append("Can't send CefRequest because creation of CefURLRequest failed.");
            this.repliedResult_.append("The native code (CEF) returned a NULL-Pointer for CefURLRequest.");
            this.cancelButton_.setEnabled(false);
        } else {
            this.sentRequest_.append(request.toString());
            this.cancelButton_.setEnabled(true);
            this.updateStatus("", false);
        }
    }

    private void updateStatus(final String updateMsg, final boolean printByteStream) {
        final CefURLRequest.Status status = this.urlRequest_.getRequestStatus();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                UrlRequestDialogReply.this.statusLabel_.setText("HTTP-Request status: " + status);
                if (status != CefURLRequest.Status.UR_UNKNOWN && status != CefURLRequest.Status.UR_IO_PENDING) {
                    UrlRequestDialogReply.this.cancelButton_.setEnabled(false);
                }
                UrlRequestDialogReply.this.repliedResult_.append(updateMsg);
                if (printByteStream) {
                    try {
                        UrlRequestDialogReply.this.repliedResult_.append("\n\n" + UrlRequestDialogReply.this.byteStream_.toString("UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        UrlRequestDialogReply.this.repliedResult_.append("\n\n" + UrlRequestDialogReply.this.byteStream_.toString());
                    }
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void setNativeRef(String identifer, long nativeRef) {
        this.nativeRef_ = nativeRef;
    }

    public long getNativeRef(String identifer) {
        return this.nativeRef_;
    }

    public void onRequestComplete(CefURLRequest request) {
        String updateStr = "onRequestCompleted\n\n";
        CefResponse response = request.getResponse();
        boolean isText = response.getHeaderByName("Content-Type").startsWith("text");
        updateStr = updateStr + response.toString();
        this.updateStatus(updateStr, isText);
    }

    public void onUploadProgress(CefURLRequest request, int current, int total) {
        this.updateStatus("onUploadProgress: " + current + "/" + total + " bytes\n", false);
    }

    public void onDownloadProgress(CefURLRequest request, int current, int total) {
        this.updateStatus("onDownloadProgress: " + current + "/" + total + " bytes\n", false);
    }

    public void onDownloadData(CefURLRequest request, byte[] data, int data_length) {
        this.byteStream_.write(data, 0, data_length);
        this.updateStatus("onDownloadData: " + data_length + " bytes\n", false);
    }

    public boolean getAuthCredentials(boolean isProxy, String host, int port, String realm, String scheme, CefAuthCallback callback) {
        SwingUtilities.invokeLater(new PasswordDialog(this.owner_, callback));
        return true;
    }
}

