/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.font.OutlineFont;
import com.sun.pdfview.font.PDFFont;
import com.sun.pdfview.font.PDFGlyph;
import com.sun.pdfview.font.Type3Font;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontToy
extends JPanel {
    JComboBox comboBox;
    private JMenuItem exitMenuItem = new JMenuItem("Exit");
    private JFileChooser openFileChooser = null;
    private JMenu fileMenu = new JMenu("File");
    private Set fonts;
    private PDFFont font;
    private JFrame jf = new JFrame("Font Toy");
    private Font gfont;
    private PDFGlyph glyph;
    private JComboBox glyphBox;
    private SpinnerListModel glyphModel = new SpinnerListModel();
    private JLabel glyphName = new JLabel();
    private JSpinner glyphSpinner = new JSpinner(this.glyphModel);
    private File inputFile = null;
    private JMenuBar menuBar = new JMenuBar();
    private JMenuItem openMenuItem = new JMenuItem("Open");
    private PDFFile pdf = null;

    public FontToy(String[] args) throws IOException {
        Box controlPanel = Box.createHorizontalBox();
        this.glyphBox = new JComboBox();
        this.glyphBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    Integer value = (Integer)ie.getItem();
                    FontToy.this.glyphSelected(value);
                    FontToy.this.glyphSpinner.setValue(value);
                }
            }
        });
        this.comboBox = new JComboBox();
        this.comboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    FontToy.this.fontSelected((PDFFont)ie.getItem());
                }
            }
        });
        this.comboBox.setMaximumSize(new Dimension(200, 50));
        controlPanel.add(new JLabel("Fonts:"));
        controlPanel.add(this.comboBox);
        controlPanel.add(Box.createHorizontalStrut(15));
        controlPanel.add(new JLabel("Glyphs:"));
        controlPanel.add(this.glyphBox);
        controlPanel.add(this.glyphName);
        controlPanel.add(this.glyphSpinner);
        JPanel ftPanel = new JPanel();
        ftPanel.setLayout(new BorderLayout());
        ftPanel.add((Component)controlPanel, "North");
        ftPanel.add((Component)this, "Center");
        ftPanel.setFocusable(true);
        ftPanel.requestFocus();
        ftPanel.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent k) {
                this.keyPressed(k);
            }
        });
        this.jf.setContentPane(ftPanel);
        this.jf.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                System.exit(-1);
            }
        });
        this.jf.setSize(640, 480);
        this.jf.setVisible(true);
        this.jf.setJMenuBar(this.menuBar);
        this.menuBar.add(this.fileMenu);
        this.fileMenu.add(this.openMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exitMenuItem);
        this.openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FontToy.this.openPDF();
            }
        });
        this.glyphSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Integer value = (Integer)FontToy.this.glyphSpinner.getValue();
                FontToy.this.glyphSelected(value);
                FontToy.this.glyphBox.setSelectedItem(value);
            }
        });
        if (args.length > 0) {
            this.initialize(args[0]);
        }
    }

    private void drawShape(Graphics2D g2, GeneralPath gp, int w, int h) {
        double scaleY;
        float curX = 0.0f;
        float curY = 0.0f;
        float startX = 0.0f;
        float startY = 0.0f;
        Rectangle2D border = gp.getBounds2D();
        double scaleX = (double)(w - 20) / border.getWidth();
        if (scaleX < (scaleY = (double)(h - 20) / border.getHeight())) {
            scaleY = scaleX;
        } else {
            scaleX = scaleY;
        }
        double transX = 10.0 - border.getX() * scaleX;
        double transY = (double)(h - 10) + border.getY() * scaleY;
        AffineTransform at = new AffineTransform(scaleX, 0.0, 0.0, -scaleY, transX, transY);
        Rectangle2D borderTrans = gp.createTransformedShape(at).getBounds2D();
        g2.setColor(Color.CYAN);
        g2.fill(gp.createTransformedShape(at));
        g2.setColor(Color.BLACK);
        int num = 0;
        PathIterator pi = gp.getPathIterator(at);
        while (!pi.isDone()) {
            float[] coords = new float[6];
            switch (pi.currentSegment(coords)) {
                case 0: {
                    curX = coords[0];
                    curY = coords[1];
                    this.drawPoint(g2, num++, curX, curY, false);
                    startX = curX;
                    startY = curY;
                    break;
                }
                case 1: {
                    Line2D.Float line = new Line2D.Float(curX, curY, coords[0], coords[1]);
                    g2.draw(line);
                    this.drawPoint(g2, num++, coords[0], coords[1], false);
                    curX = coords[0];
                    curY = coords[1];
                    break;
                }
                case 3: {
                    CubicCurve2D.Float curve = new CubicCurve2D.Float(curX, curY, coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    g2.draw(curve);
                    this.drawPoint(g2, num++, coords[0], coords[1], true);
                    this.drawPoint(g2, num++, coords[2], coords[3], true);
                    this.drawPoint(g2, num++, coords[4], coords[5], false);
                    curX = coords[4];
                    curY = coords[5];
                    break;
                }
                case 2: {
                    QuadCurve2D.Float curveQ = new QuadCurve2D.Float(curX, curY, coords[0], coords[1], coords[2], coords[3]);
                    g2.draw(curveQ);
                    this.drawPoint(g2, num++, coords[0], coords[1], true);
                    this.drawPoint(g2, num++, coords[2], coords[3], false);
                    curX = coords[2];
                    curY = coords[3];
                    break;
                }
                case 4: {
                    Line2D.Float line2 = new Line2D.Float(curX, curY, startX, startY);
                    g2.draw(line2);
                    curX = startX;
                    curY = startY;
                }
            }
            pi.next();
        }
    }

    public void drawPoint(Graphics2D g, int num, float x, float y, boolean curvectl) {
        GeneralPath gp = new GeneralPath();
        if (curvectl) {
            gp.moveTo(x - 1.0f, y - 1.0f);
            gp.lineTo(x + 1.0f, y + 1.0f);
            gp.moveTo(x - 1.0f, y + 1.0f);
            gp.lineTo(x + 1.0f, y - 1.0f);
        } else {
            gp.moveTo(x - 1.0f, y - 1.0f);
            gp.lineTo(x - 1.0f, y + 1.0f);
            gp.lineTo(x + 1.0f, y + 1.0f);
            gp.lineTo(x + 1.0f, y - 1.0f);
            gp.closePath();
        }
        g.setColor(Color.red);
        g.draw(gp);
        g.setColor(Color.blue);
        g.setFont(this.gfont);
        g.drawString(String.valueOf(num), x + 3.0f, y + 3.0f);
    }

    private void drawPage(Graphics2D g2, PDFPage page, int w, int h) {
        Dimension pageSize = page.getUnstretchedSize(w - 20, h - 20, null);
        Image image = page.getImage(pageSize.width, pageSize.height, null, null, true, true);
        g2.drawImage(image, 0, 0, null);
    }

    private Set<PDFFont> findFonts(PDFObject pagedict, Map<String, PDFObject> resources) throws IOException {
        PDFObject kidsObj;
        HashSet outSet = new HashSet();
        PDFObject rsrcObj = pagedict.getDictRef("Resources");
        if (rsrcObj != null) {
            String key;
            Iterator i;
            HashMap<String, PDFObject> rsrcMap = new HashMap<String, PDFObject>();
            rsrcMap.putAll(resources);
            HashMap<String, PDFObject> rsrc = rsrcObj.getDictionary();
            rsrcMap.putAll(rsrc);
            if (rsrc.containsKey("Font")) {
                PDFObject fontsObj = (PDFObject)rsrc.get("Font");
                i = fontsObj.getDictKeys();
                while (i.hasNext()) {
                    key = (String)i.next();
                    PDFObject fontObj = fontsObj.getDictRef(key);
                    try {
                        PDFFont font = PDFFont.getFont(fontObj, rsrcMap);
                        outSet.add(font);
                    }
                    catch (Exception ex) {
                        System.out.println("Error finding font from " + fontObj);
                        ex.printStackTrace();
                    }
                }
            }
            if (rsrc.containsKey("XObject")) {
                PDFObject xobjsObj = (PDFObject)rsrc.get("XObject");
                i = xobjsObj.getDictKeys();
                while (i.hasNext()) {
                    key = (String)i.next();
                    PDFObject xobj = xobjsObj.getDictRef(key);
                    outSet.addAll(this.findFonts(xobj, new HashMap<String, PDFObject>()));
                }
            }
            resources = rsrcMap;
        }
        if ((kidsObj = pagedict.getDictRef("Kids")) != null) {
            PDFObject[] kids = kidsObj.getArray();
            for (int i = 0; i < kids.length; ++i) {
                outSet.addAll(this.findFonts(kids[i], resources));
            }
        }
        return outSet;
    }

    private void fontSelected(PDFFont font) {
        this.setCurrentFont(font);
        int start = 0;
        int end = 255;
        if (font instanceof OutlineFont) {
            start = ((OutlineFont)font).getFirstChar();
            end = ((OutlineFont)font).getLastChar();
        } else if (font instanceof Type3Font) {
            start = ((Type3Font)font).getFirstChar();
            end = ((Type3Font)font).getLastChar();
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 255;
        }
        Vector<Integer> objs = new Vector<Integer>(end - start + 1);
        for (int i = start; i <= end; ++i) {
            objs.add(new Integer(i));
        }
        this.glyphBox.setModel(new DefaultComboBoxModel(objs));
        this.glyphModel = new SpinnerListModel(objs);
        this.glyphSpinner.setModel(this.glyphModel);
        Integer select = new Integer(start);
        this.glyphSelected(select);
    }

    public Set getFonts() {
        return this.fonts;
    }

    public PDFFont getCurrentFont() {
        return this.font;
    }

    private void glyphSelected(Integer glyphID) {
        char glyphChar = (char)glyphID.intValue();
        String s = String.valueOf(glyphChar);
        PDFFont font = this.getCurrentFont();
        List<PDFGlyph> l = font.getGlyphs(s);
        PDFGlyph glyph = (PDFGlyph)l.get(0);
        this.setCurrentGlyph(glyph);
        this.repaint();
    }

    private void initialize(String fileName) throws IOException {
        this.jf.setTitle("PDFRenderer Font Toy - " + fileName);
        try {
            this.inputFile = new File(fileName);
            FileInputStream istr = new FileInputStream(this.inputFile);
            byte[] buf = new byte[(int)this.inputFile.length()];
            int read = 0;
            int offset = 0;
            while (read >= 0) {
                read = istr.read(buf, offset, buf.length - offset);
            }
            istr.close();
            ByteBuffer byteBuf = ByteBuffer.allocate(buf.length);
            byteBuf.put(buf);
            this.pdf = new PDFFile(byteBuf);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        PDFObject root = this.pdf.getRoot();
        PDFObject pagesObj = root.getDictRef("Pages");
        this.fonts = this.findFonts(pagesObj, new HashMap<String, PDFObject>());
        this.gfont = new Font("Sans-serif", 0, 10);
        Object[] fontObjs = this.getFonts().toArray();
        this.comboBox.setModel(new DefaultComboBoxModel<Object>(fontObjs));
        this.fontSelected((PDFFont)fontObjs[0]);
        this.validate();
    }

    public PDFGlyph getCurrentGlyph() {
        return this.glyph;
    }

    private void keyPressed(KeyEvent k) {
        int curIndex;
        int nextIndex = curIndex = this.glyphBox.getSelectedIndex();
        if (k.getKeyCode() == 37) {
            if (--nextIndex < 0) {
                nextIndex = this.glyphBox.getItemCount() - 1;
            }
        } else if (k.getKeyCode() == 39 && ++nextIndex >= this.glyphBox.getItemCount()) {
            nextIndex = 0;
        }
        if (nextIndex != curIndex) {
            this.glyphBox.setSelectedIndex(nextIndex);
        }
    }

    public static void main(String[] args) {
        try {
            FontToy toy = new FontToy(args);
        }
        catch (IOException ex) {
            Logger.getLogger(FontToy.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void openPDF() {
        if (this.openFileChooser == null) {
            this.openFileChooser = new JFileChooser(this.inputFile);
            this.openFileChooser.setAcceptAllFileFilterUsed(false);
            this.openFileChooser.addChoosableFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(".pdf");
                }

                public String getDescription() {
                    return "PDF Files (*.pdf)";
                }
            });
        }
        switch (this.openFileChooser.showOpenDialog(this)) {
            case 0: {
                try {
                    this.initialize(this.openFileChooser.getSelectedFile().getPath());
                }
                catch (IOException ex) {
                    Logger.getLogger(FontToy.class.getName()).log(Level.SEVERE, null, ex);
                }
                break;
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        int width = this.getWidth();
        int height = this.getHeight();
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, width, height);
        g2.setColor(Color.BLACK);
        if (this.glyph == null) {
            return;
        }
        GeneralPath gp = this.glyph.getShape();
        PDFPage page = this.glyph.getPage();
        if (gp != null) {
            this.drawShape(g2, gp, width, height);
        } else if (page != null) {
            this.drawPage(g2, page, width, height);
        }
    }

    public void setCurrentFont(PDFFont font) {
        this.font = font;
    }

    public void setCurrentGlyph(PDFGlyph glyph) {
        this.glyph = glyph;
        this.glyphName.setText(glyph.getName());
    }
}

