/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaMenuPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;

public class AquaMenuUI
extends BasicMenuUI
implements AquaMenuPainter.Client {
    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaMenuUI();
    }

    @Override
    protected ChangeListener createChangeListener(JComponent jComponent) {
        return new BasicMenuUI.ChangeHandler(this, (JMenu)jComponent, this);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        ((JMenu)this.menuItem).setDelay(133);
    }

    @Override
    protected void paintMenuItem(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n) {
        AquaMenuPainter.sPainter.paintMenuItem(this, graphics, jComponent, icon, icon2, color, color2, this.disabledForeground, this.selectionForeground, n, this.acceleratorFont);
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n) {
        Dimension dimension = AquaMenuPainter.sPainter.getPreferredMenuItemSize(jComponent, icon, icon2, n, this.acceleratorFont);
        if (jComponent.getParent() instanceof JMenuBar) {
            dimension.height = Math.max(dimension.height, 21);
        }
        return dimension;
    }

    @Override
    public void paintBackground(Graphics graphics, JComponent jComponent, int n, int n2) {
        Container container = jComponent.getParent();
        boolean bl = container instanceof JMenuBar;
        ButtonModel buttonModel = ((JMenuItem)jComponent).getModel();
        if (buttonModel.isArmed() || buttonModel.isSelected()) {
            if (bl) {
                AquaMenuPainter.sPainter.paintSelectedMenuTitleBackground(graphics, n, n2);
            } else {
                AquaMenuPainter.sPainter.paintSelectedMenuItemBackground(graphics, n, n2);
            }
        } else if (bl) {
            AquaMenuPainter.sPainter.paintMenuBarBackground(graphics, n, n2, jComponent);
        } else {
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(0, 0, n, n2);
        }
    }

    @Override
    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new AquaMouseInputHandler();
    }

    @Override
    protected MenuDragMouseListener createMenuDragMouseListener(JComponent jComponent) {
        return new MenuDragMouseHandler();
    }

    static void appendPath(MenuElement[] menuElementArray, MenuElement menuElement) {
        MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 1];
        System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
        menuElementArray2[menuElementArray.length] = menuElement;
        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
    }

    protected class AquaMouseInputHandler
    extends BasicMenuUI.MouseInputHandler {
        protected AquaMouseInputHandler() {
            super(AquaMenuUI.this);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)AquaMenuUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (menuElementArray.length <= 0 || menuElementArray[menuElementArray.length - 1] != jMenu.getPopupMenu()) {
                if (jMenu.getDelay() == 0) {
                    AquaMenuUI.appendPath(AquaMenuUI.this.getPath(), jMenu.getPopupMenu());
                } else {
                    menuSelectionManager.setSelectedPath(AquaMenuUI.this.getPath());
                    AquaMenuUI.this.setupPostTimer(jMenu);
                }
            }
        }
    }

    class MenuDragMouseHandler
    implements MenuDragMouseListener {
        MenuDragMouseHandler() {
        }

        @Override
        public void menuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
            Component component;
            if (!AquaMenuUI.this.menuItem.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            Point point = menuDragMouseEvent.getPoint();
            if (point.x >= 0 && point.x < AquaMenuUI.this.menuItem.getWidth() && point.y >= 0 && point.y < AquaMenuUI.this.menuItem.getHeight()) {
                JMenu jMenu = (JMenu)AquaMenuUI.this.menuItem;
                MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
                if (menuElementArray2.length <= 0 || menuElementArray2[menuElementArray2.length - 1] != jMenu.getPopupMenu()) {
                    if (jMenu.getDelay() == 0) {
                        AquaMenuUI.appendPath(menuElementArray, jMenu.getPopupMenu());
                    } else {
                        menuSelectionManager.setSelectedPath(menuElementArray);
                        AquaMenuUI.this.setupPostTimer(jMenu);
                    }
                }
            } else if (menuDragMouseEvent.getID() == 502 && (component = menuSelectionManager.componentForPoint(menuDragMouseEvent.getComponent(), menuDragMouseEvent.getPoint())) == null) {
                menuSelectionManager.clearSelectedPath();
            }
        }

        @Override
        public void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
        }

        @Override
        public void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        }

        @Override
        public void menuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
        }
    }
}

