/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import com.apple.laf.AquaBorder;
import com.apple.laf.AquaButtonBorder;
import com.apple.laf.AquaUtilControlSize;
import com.apple.laf.AquaUtils;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class AquaButtonExtendedTypes {
    protected static final AquaUtils.LazySingleton<Map<String, TypeSpecifier>> typeDefinitions = new AquaUtils.LazySingleton<Map<String, TypeSpecifier>>(){

        @Override
        protected Map<String, TypeSpecifier> getInstance() {
            return AquaButtonExtendedTypes.getAllTypes();
        }
    };

    protected static Border getBorderForPosition(AbstractButton abstractButton, Object object, Object object2) {
        String string = object2 == null ? (String)object : object + "-" + object2;
        TypeSpecifier typeSpecifier = AquaButtonExtendedTypes.getSpecifierByName(string);
        if (typeSpecifier == null) {
            return null;
        }
        Border border = typeSpecifier.getBorder();
        if (!(border instanceof AquaBorder)) {
            return border;
        }
        return ((AquaBorder)border).deriveBorderForSize(AquaUtilControlSize.getUserSizeFrom(abstractButton));
    }

    protected static TypeSpecifier getSpecifierByName(String string) {
        return typeDefinitions.get().get(string);
    }

    protected static Map<String, TypeSpecifier> getAllTypes() {
        TypeSpecifier[] typeSpecifierArray;
        HashMap<String, TypeSpecifier> hashMap = new HashMap<String, TypeSpecifier>();
        Insets insets = new Insets(4, 4, 4, 4);
        for (TypeSpecifier typeSpecifier : typeSpecifierArray = new TypeSpecifier[]{new TypeSpecifier("toolbar", true){

            @Override
            Border getBorder() {
                return AquaButtonBorder.getToolBarButtonBorder();
            }
        }, new TypeSpecifier("icon", true){

            @Override
            Border getBorder() {
                return AquaButtonBorder.getToggleButtonBorder();
            }
        }, new TypeSpecifier("text", false){

            @Override
            Border getBorder() {
                return UIManager.getBorder("Button.border");
            }
        }, new TypeSpecifier("toggle", false){

            @Override
            Border getBorder() {
                return AquaButtonBorder.getToggleButtonBorder();
            }
        }, new BorderDefinedTypeSpecifier("combobox", JRSUIConstants.Widget.BUTTON_POP_DOWN, new AquaUtilControlSize.SizeVariant().alterMargins(7, 10, 6, 30).alterInsets(1, 2, 0, 2).alterMinSize(0, 29), 0, -3, 0, -6){

            @Override
            void patchUp(AquaUtilControlSize.SizeDescriptor sizeDescriptor) {
                sizeDescriptor.small.alterMargins(0, 0, 0, -4);
                sizeDescriptor.mini.alterMargins(0, 0, 0, -6);
            }
        }, new BorderDefinedTypeSpecifier("comboboxInternal", JRSUIConstants.Widget.BUTTON_POP_DOWN, new AquaUtilControlSize.SizeVariant().alterInsets(1, 2, 0, 2).alterMinSize(0, 29), 0, -3, 0, -6), new BorderDefinedTypeSpecifier("comboboxEndCap", JRSUIConstants.Widget.BUTTON_COMBO_BOX, new AquaUtilControlSize.SizeVariant().alterMargins(5, 10, 6, 10).alterInsets(1, 2, 0, 2).alterMinSize(0, 29), 0, -3, 0, -6){

            @Override
            void patchUp(AquaUtilControlSize.SizeDescriptor sizeDescriptor) {
                ((JRSUIState)this.border.painter.state).set(JRSUIConstants.IndicatorOnly.YES);
            }
        }, new BorderDefinedTypeSpecifier("square", JRSUIConstants.Widget.BUTTON_BEVEL, new AquaUtilControlSize.SizeVariant(16, 16).alterMargins(5, 7, 5, 7).replaceInsets(insets)), new BorderDefinedTypeSpecifier("gradient", JRSUIConstants.Widget.BUTTON_BEVEL_INSET, new AquaUtilControlSize.SizeVariant(18, 18).alterMargins(8, 9, 8, 9).replaceInsets(insets)){

            @Override
            void patchUp(AquaUtilControlSize.SizeDescriptor sizeDescriptor) {
                sizeDescriptor.small.alterMargins(0, 0, 0, 0);
            }
        }, new BorderDefinedTypeSpecifier("bevel", JRSUIConstants.Widget.BUTTON_BEVEL_ROUND, new AquaUtilControlSize.SizeVariant(22, 22).alterMargins(7, 8, 9, 8).alterInsets(0, 0, 0, 0)), new BorderDefinedTypeSpecifier("textured", JRSUIConstants.Widget.BUTTON_PUSH_TEXTURED, new AquaUtilControlSize.SizeVariant(28, 28).alterMargins(5, 10, 6, 10).alterInsets(1, 2, 0, 2)), new BorderDefinedTypeSpecifier("roundRect", JRSUIConstants.Widget.BUTTON_PUSH_INSET, new AquaUtilControlSize.SizeVariant(28, 28).alterMargins(4, 14, 4, 14).replaceInsets(insets)), new BorderDefinedTypeSpecifier("recessed", JRSUIConstants.Widget.BUTTON_PUSH_SCOPE, new AquaUtilControlSize.SizeVariant(28, 28).alterMargins(4, 14, 4, 14).replaceInsets(insets)), new BorderDefinedTypeSpecifier("well", JRSUIConstants.Widget.FRAME_WELL, new AquaUtilControlSize.SizeVariant(32, 32)), new BorderDefinedTypeSpecifier("help", JRSUIConstants.Widget.BUTTON_ROUND_HELP, new AquaUtilControlSize.SizeVariant().alterInsets(2, 0, 0, 0).alterMinSize(28, 28), -3, -3, -3, -3), new BorderDefinedTypeSpecifier("round", JRSUIConstants.Widget.BUTTON_ROUND, new AquaUtilControlSize.SizeVariant().alterInsets(2, 0, 0, 0).alterMinSize(28, 28), -3, -3, -3, -3), new BorderDefinedTypeSpecifier("texturedRound", JRSUIConstants.Widget.BUTTON_ROUND_INSET, new AquaUtilControlSize.SizeVariant().alterInsets(0, 0, 0, 0).alterMinSize(26, 26), -2, -2, 0, 0), new SegmentedBorderDefinedTypeSpecifier("segmented-first", JRSUIConstants.Widget.BUTTON_SEGMENTED, JRSUIConstants.SegmentPosition.FIRST, new AquaUtilControlSize.SizeVariant().alterMargins(6, 16, 6, 10).alterInsets(5, 3, 5, 0).alterMinSize(0, 28), 0, -3, 0, -3), new SegmentedBorderDefinedTypeSpecifier("segmented-middle", JRSUIConstants.Widget.BUTTON_SEGMENTED, JRSUIConstants.SegmentPosition.MIDDLE, new AquaUtilControlSize.SizeVariant().alterMargins(6, 9, 6, 10).alterInsets(5, 0, 5, 0).alterMinSize(0, 28), 0, -3, 0, -3), new SegmentedBorderDefinedTypeSpecifier("segmented-last", JRSUIConstants.Widget.BUTTON_SEGMENTED, JRSUIConstants.SegmentPosition.LAST, new AquaUtilControlSize.SizeVariant().alterMargins(6, 9, 6, 16).alterInsets(5, 0, 5, 3).alterMinSize(0, 28), 0, -3, 0, -3), new SegmentedBorderDefinedTypeSpecifier("segmented-only", JRSUIConstants.Widget.BUTTON_SEGMENTED, JRSUIConstants.SegmentPosition.ONLY, new AquaUtilControlSize.SizeVariant().alterMargins(6, 16, 6, 16).alterInsets(5, 3, 5, 3).alterMinSize(34, 28), 0, -3, 0, -3), new SegmentedBorderDefinedTypeSpecifier("segmentedRoundRect-first", JRSUIConstants.Widget.BUTTON_SEGMENTED_INSET, JRSUIConstants.SegmentPosition.FIRST, new AquaUtilControlSize.SizeVariant().alterMargins(6, 12, 6, 8).alterInsets(5, 2, 5, 0).alterMinSize(0, 28), 0, -3, 0, -3), new SegmentedBorderDefinedTypeSpecifier("segmentedRoundRect-middle", JRSUIConstants.Widget.BUTTON_SEGMENTED_INSET, JRSUIConstants.SegmentPosition.MIDDLE, new AquaUtilControlSize.SizeVariant().alterMargins(6, 8, 6, 8).alterInsets(5, 0, 5, 0).alterMinSize(0, 28), 0, -3, 0, -3), new SegmentedBorderDefinedTypeSpecifier("segmentedRoundRect-last", JRSUIConstants.Widget.BUTTON_SEGMENTED_INSET, JRSUIConstants.SegmentPosition.LAST, new AquaUtilControlSize.SizeVariant().alterMargins(6, 8, 6, 12).alterInsets(5, 0, 5, 2).alterMinSize(0, 28), 0, -3, 0, -3), new SegmentedBorderDefinedTypeSpecifier("segmentedRoundRect-only", JRSUIConstants.Widget.BUTTON_SEGMENTED_INSET, JRSUIConstants.SegmentPosition.ONLY, new AquaUtilControlSize.SizeVariant().alterMargins(6, 12, 6, 12).alterInsets(5, 2, 5, 2).alterMinSize(0, 28), 0, -3, 0, -3), new SegmentedBorderDefinedTypeSpecifier("segmentedTexturedRounded-first", JRSUIConstants.Widget.BUTTON_SEGMENTED_SCURVE, JRSUIConstants.SegmentPosition.FIRST, new AquaUtilControlSize.SizeVariant().alterMargins(6, 12, 6, 8).alterInsets(5, 2, 5, 0).alterMinSize(0, 28), 0, -3, 0, -3), new SegmentedBorderDefinedTypeSpecifier("segmentedTexturedRounded-middle", JRSUIConstants.Widget.BUTTON_SEGMENTED_SCURVE, JRSUIConstants.SegmentPosition.MIDDLE, new AquaUtilControlSize.SizeVariant().alterMargins(6, 8, 6, 8).alterInsets(5, 0, 5, 0).alterMinSize(0, 28), 0, -3, 0, -3), new SegmentedBorderDefinedTypeSpecifier("segmentedTexturedRounded-last", JRSUIConstants.Widget.BUTTON_SEGMENTED_SCURVE, JRSUIConstants.SegmentPosition.LAST, new AquaUtilControlSize.SizeVariant().alterMargins(6, 8, 6, 12).alterInsets(5, 0, 5, 2).alterMinSize(0, 28), 0, -3, 0, -3), new SegmentedBorderDefinedTypeSpecifier("segmentedTexturedRounded-only", JRSUIConstants.Widget.BUTTON_SEGMENTED_SCURVE, JRSUIConstants.SegmentPosition.ONLY, new AquaUtilControlSize.SizeVariant().alterMargins(6, 12, 6, 12).alterInsets(5, 2, 5, 2).alterMinSize(0, 28), 0, -3, 0, -3), new SegmentedBorderDefinedTypeSpecifier("segmentedTextured-first", JRSUIConstants.Widget.BUTTON_SEGMENTED_TEXTURED, JRSUIConstants.SegmentPosition.FIRST, new AquaUtilControlSize.SizeVariant().alterMargins(6, 12, 6, 8).alterInsets(6, 3, 6, 0).alterMinSize(0, 28), 0, -3, 0, -3), new SegmentedBorderDefinedTypeSpecifier("segmentedTextured-middle", JRSUIConstants.Widget.BUTTON_SEGMENTED_TEXTURED, JRSUIConstants.SegmentPosition.MIDDLE, new AquaUtilControlSize.SizeVariant().alterMargins(6, 8, 6, 8).alterInsets(6, 0, 6, 0).alterMinSize(0, 28), 0, -3, 0, -3), new SegmentedBorderDefinedTypeSpecifier("segmentedTextured-last", JRSUIConstants.Widget.BUTTON_SEGMENTED_TEXTURED, JRSUIConstants.SegmentPosition.LAST, new AquaUtilControlSize.SizeVariant().alterMargins(6, 8, 6, 12).alterInsets(6, 0, 6, 3).alterMinSize(0, 28), 0, -3, 0, -3), new SegmentedBorderDefinedTypeSpecifier("segmentedTextured-only", JRSUIConstants.Widget.BUTTON_SEGMENTED_TEXTURED, JRSUIConstants.SegmentPosition.ONLY, new AquaUtilControlSize.SizeVariant().alterMargins(6, 12, 6, 12).alterInsets(6, 3, 6, 3).alterMinSize(0, 28), 0, -3, 0, -3), new SegmentedBorderDefinedTypeSpecifier("segmentedCapsule-first", JRSUIConstants.Widget.BUTTON_SEGMENTED_TOOLBAR, JRSUIConstants.SegmentPosition.FIRST, new AquaUtilControlSize.SizeVariant().alterMargins(6, 12, 6, 8).alterInsets(5, 2, 5, 0).alterMinSize(0, 28), 0, 0, 0, 0), new SegmentedBorderDefinedTypeSpecifier("segmentedCapsule-middle", JRSUIConstants.Widget.BUTTON_SEGMENTED_TOOLBAR, JRSUIConstants.SegmentPosition.MIDDLE, new AquaUtilControlSize.SizeVariant().alterMargins(6, 8, 6, 8).alterInsets(5, 0, 5, 0).alterMinSize(0, 28), 0, 0, 0, 0), new SegmentedBorderDefinedTypeSpecifier("segmentedCapsule-last", JRSUIConstants.Widget.BUTTON_SEGMENTED_TOOLBAR, JRSUIConstants.SegmentPosition.LAST, new AquaUtilControlSize.SizeVariant().alterMargins(6, 8, 6, 12).alterInsets(5, 0, 5, 2).alterMinSize(0, 28), 0, 0, 0, 0), new SegmentedBorderDefinedTypeSpecifier("segmentedCapsule-only", JRSUIConstants.Widget.BUTTON_SEGMENTED_TOOLBAR, JRSUIConstants.SegmentPosition.ONLY, new AquaUtilControlSize.SizeVariant().alterMargins(6, 12, 6, 12).alterInsets(5, 2, 5, 2).alterMinSize(34, 28), 0, 0, 0, 0), new BorderDefinedTypeSpecifier("segmentedGradient-first", JRSUIConstants.Widget.BUTTON_BEVEL_INSET, new AquaUtilControlSize.SizeVariant(18, 18).alterMargins(4, 5, 4, 5).replaceInsets(new Insets(-2, 0, -2, 0))), new BorderDefinedTypeSpecifier("segmentedGradient-middle", JRSUIConstants.Widget.BUTTON_BEVEL_INSET, new AquaUtilControlSize.SizeVariant(18, 18).alterMargins(4, 5, 4, 5).replaceInsets(new Insets(-2, -1, -2, 0))), new BorderDefinedTypeSpecifier("segmentedGradient-last", JRSUIConstants.Widget.BUTTON_BEVEL_INSET, new AquaUtilControlSize.SizeVariant(18, 18).alterMargins(4, 5, 4, 5).replaceInsets(new Insets(-2, -1, -2, 0))), new BorderDefinedTypeSpecifier("segmentedGradient-only", JRSUIConstants.Widget.BUTTON_BEVEL_INSET, new AquaUtilControlSize.SizeVariant(18, 18).alterMargins(4, 5, 4, 5).replaceInsets(new Insets(-2, -1, -2, -1))), new BorderDefinedTypeSpecifier("disclosure", JRSUIConstants.Widget.BUTTON_DISCLOSURE, new AquaUtilControlSize.SizeVariant().alterMargins(10, 10, 10, 10).replaceInsets(insets).alterMinSize(27, 27), -1, -1, -1, -1), new BorderDefinedTypeSpecifier("scrollColumnSizer", JRSUIConstants.Widget.SCROLL_COLUMN_SIZER, new AquaUtilControlSize.SizeVariant(14, 14))}) {
            hashMap.put(typeSpecifier.name, typeSpecifier);
        }
        return hashMap;
    }

    public static class SegmentedNamedBorder
    extends AquaButtonBorder.Named {
        public SegmentedNamedBorder(SegmentedNamedBorder segmentedNamedBorder) {
            super(segmentedNamedBorder);
        }

        public SegmentedNamedBorder(JRSUIConstants.Widget widget, AquaUtilControlSize.SizeDescriptor sizeDescriptor) {
            super(widget, sizeDescriptor);
        }

        @Override
        protected boolean isSelectionPressing() {
            return false;
        }
    }

    static class SegmentedBorderDefinedTypeSpecifier
    extends BorderDefinedTypeSpecifier {
        public SegmentedBorderDefinedTypeSpecifier(String string, JRSUIConstants.Widget widget, JRSUIConstants.SegmentPosition segmentPosition, AquaUtilControlSize.SizeVariant sizeVariant) {
            this(string, widget, segmentPosition, sizeVariant, 0, 0, 0, 0);
        }

        public SegmentedBorderDefinedTypeSpecifier(String string, JRSUIConstants.Widget widget, JRSUIConstants.SegmentPosition segmentPosition, AquaUtilControlSize.SizeVariant sizeVariant, int n, int n2, int n3, int n4) {
            super(string, widget, sizeVariant, n, n2, n3, n4);
            ((JRSUIState)this.border.painter.state).set(JRSUIConstants.SegmentTrailingSeparator.YES);
            ((JRSUIState)this.border.painter.state).set(segmentPosition);
        }

        @Override
        AquaBorder initBorder(JRSUIConstants.Widget widget, AquaUtilControlSize.SizeDescriptor sizeDescriptor) {
            return new SegmentedNamedBorder(widget, sizeDescriptor);
        }
    }

    static class BorderDefinedTypeSpecifier
    extends TypeSpecifier {
        final AquaBorder border;

        BorderDefinedTypeSpecifier(String string, JRSUIConstants.Widget widget, AquaUtilControlSize.SizeVariant sizeVariant) {
            this(string, widget, sizeVariant, 0, 0, 0, 0);
        }

        BorderDefinedTypeSpecifier(String string, JRSUIConstants.Widget widget, AquaUtilControlSize.SizeVariant sizeVariant, final int n, final int n2, final int n3, final int n4) {
            super(string, false);
            this.border = this.initBorder(widget, new AquaUtilControlSize.SizeDescriptor(sizeVariant){

                @Override
                public AquaUtilControlSize.SizeVariant deriveSmall(AquaUtilControlSize.SizeVariant sizeVariant) {
                    sizeVariant.alterMinSize(n, n2);
                    return super.deriveSmall(sizeVariant);
                }

                @Override
                public AquaUtilControlSize.SizeVariant deriveMini(AquaUtilControlSize.SizeVariant sizeVariant) {
                    sizeVariant.alterMinSize(n3, n4);
                    return super.deriveMini(sizeVariant);
                }
            });
            this.patchUp(this.border.sizeDescriptor);
        }

        @Override
        Border getBorder() {
            return this.border;
        }

        void patchUp(AquaUtilControlSize.SizeDescriptor sizeDescriptor) {
        }

        AquaBorder initBorder(JRSUIConstants.Widget widget, AquaUtilControlSize.SizeDescriptor sizeDescriptor) {
            return new AquaButtonBorder.Named(widget, sizeDescriptor);
        }
    }

    static abstract class TypeSpecifier {
        final String name;
        final boolean setIconFont;

        TypeSpecifier(String string, boolean bl) {
            this.name = string;
            this.setIconFont = bl;
        }

        abstract Border getBorder();
    }
}

