/*
 * Decompiled with CFR 0.152.
 */
package tests.junittests;

import java.util.Vector;
import org.cef.callback.CefDragData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import tests.junittests.TestSetupExtension;

@ExtendWith(value={TestSetupExtension.class})
class DragDataTest {
    DragDataTest() {
    }

    @Test
    void createEmpty() {
        CefDragData dragData = CefDragData.create();
        Assertions.assertNotNull((Object)dragData);
        Assertions.assertFalse((boolean)dragData.isReadOnly());
        Assertions.assertFalse((boolean)dragData.isLink());
        Assertions.assertFalse((boolean)dragData.isFile());
        Assertions.assertTrue((boolean)dragData.isFragment());
        Assertions.assertEquals((Object)"", (Object)dragData.getLinkURL());
        Assertions.assertEquals((Object)"", (Object)dragData.getLinkTitle());
        Assertions.assertEquals((Object)"", (Object)dragData.getLinkMetadata());
        Assertions.assertEquals((Object)"", (Object)dragData.getFragmentText());
        Assertions.assertEquals((Object)"", (Object)dragData.getFragmentHtml());
        Assertions.assertEquals((Object)"", (Object)dragData.getFragmentBaseURL());
        Assertions.assertEquals((int)0, (int)dragData.getFileContents(null));
        Assertions.assertEquals((Object)"", (Object)dragData.getFileName());
        Assertions.assertFalse((boolean)dragData.getFileNames(null));
        dragData.dispose();
    }

    @Test
    void createLink() {
        CefDragData dragData = CefDragData.create();
        Assertions.assertNotNull((Object)dragData);
        Assertions.assertFalse((boolean)dragData.isReadOnly());
        String linkURL = "http://test.com/test.html";
        dragData.setLinkURL("http://test.com/test.html");
        Assertions.assertEquals((Object)"http://test.com/test.html", (Object)dragData.getLinkURL());
        String linkTitle = "Test Title";
        dragData.setLinkTitle("Test Title");
        Assertions.assertEquals((Object)"Test Title", (Object)dragData.getLinkTitle());
        String linkMetadata = "something";
        dragData.setLinkMetadata("something");
        Assertions.assertEquals((Object)"something", (Object)dragData.getLinkMetadata());
        Assertions.assertTrue((boolean)dragData.isLink());
        Assertions.assertFalse((boolean)dragData.isFile());
        Assertions.assertFalse((boolean)dragData.isFragment());
        dragData.dispose();
    }

    @Test
    void createFile() {
        CefDragData dragData = CefDragData.create();
        Assertions.assertNotNull((Object)dragData);
        Assertions.assertFalse((boolean)dragData.isReadOnly());
        String path1 = "/path/to/file1.txt";
        String path2 = "/path/to/file2.txt";
        dragData.addFile("/path/to/file1.txt", "File 1");
        dragData.addFile("/path/to/file2.txt", "File 2");
        Vector fileNames = new Vector();
        Assertions.assertTrue((boolean)dragData.getFileNames(fileNames));
        Assertions.assertEquals((int)2, (int)fileNames.size());
        Assertions.assertEquals((Object)"/path/to/file1.txt", fileNames.get(0));
        Assertions.assertEquals((Object)"/path/to/file2.txt", fileNames.get(1));
        Assertions.assertFalse((boolean)dragData.isLink());
        Assertions.assertTrue((boolean)dragData.isFile());
        Assertions.assertFalse((boolean)dragData.isFragment());
        dragData.dispose();
    }

    @Test
    void createFragment() {
        CefDragData dragData = CefDragData.create();
        Assertions.assertNotNull((Object)dragData);
        Assertions.assertFalse((boolean)dragData.isReadOnly());
        String fragmentText = "something";
        dragData.setFragmentText("something");
        Assertions.assertEquals((Object)"something", (Object)dragData.getFragmentText());
        String fragmentHtml = "<span>something</span>";
        dragData.setFragmentHtml("<span>something</span>");
        Assertions.assertEquals((Object)"<span>something</span>", (Object)dragData.getFragmentHtml());
        String fragmentBaseURL = "http://test.com/test.html";
        dragData.setFragmentBaseURL("http://test.com/test.html");
        Assertions.assertEquals((Object)"http://test.com/test.html", (Object)dragData.getFragmentBaseURL());
        Assertions.assertFalse((boolean)dragData.isLink());
        Assertions.assertFalse((boolean)dragData.isFile());
        Assertions.assertTrue((boolean)dragData.isFragment());
        dragData.dispose();
    }

    @Test
    void cloneObject() {
        CefDragData dragData = CefDragData.create();
        Assertions.assertNotNull((Object)dragData);
        Assertions.assertFalse((boolean)dragData.isReadOnly());
        String fragmentText = "something";
        String fragmentBaseURL = "http://test.com/test.html";
        dragData.setFragmentText("something");
        dragData.setFragmentBaseURL("http://test.com/test.html");
        CefDragData dragData2 = dragData.clone();
        Assertions.assertFalse((boolean)dragData2.isReadOnly());
        Assertions.assertEquals((Object)"something", (Object)dragData2.getFragmentText());
        Assertions.assertEquals((Object)"http://test.com/test.html", (Object)dragData2.getFragmentBaseURL());
        Assertions.assertFalse((boolean)dragData2.isLink());
        Assertions.assertFalse((boolean)dragData2.isFile());
        Assertions.assertTrue((boolean)dragData2.isFragment());
        dragData.dispose();
        dragData2.dispose();
    }

    @Test
    void disposeObject() {
        CefDragData dragData = CefDragData.create();
        Assertions.assertNotNull((Object)dragData);
        Assertions.assertFalse((boolean)dragData.isReadOnly());
        String fragmentText = "something";
        dragData.setFragmentText("something");
        Assertions.assertEquals((Object)"something", (Object)dragData.getFragmentText());
        dragData.dispose();
        Assertions.assertEquals(null, (Object)dragData.getFragmentText());
    }
}

