/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import java.math.BigInteger;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;

public class RSAEngine
implements AsymmetricBlockCipher {
    private RSAKeyParameters key;
    private boolean forEncryption;

    public void init(boolean bl, CipherParameters cipherParameters) {
        this.key = (RSAKeyParameters)cipherParameters;
        this.forEncryption = bl;
    }

    public int getInputBlockSize() {
        int n = this.key.getModulus().bitLength();
        if (this.forEncryption) {
            return (n + 7) / 8 - 1;
        }
        return (n + 7) / 8;
    }

    public int getOutputBlockSize() {
        int n = this.key.getModulus().bitLength();
        if (this.forEncryption) {
            return (n + 7) / 8;
        }
        return (n + 7) / 8 - 1;
    }

    public byte[] processBlock(byte[] byArray, int n, int n2) {
        byte[] byArray2;
        Object object;
        byte[] byArray3;
        if (n2 > this.getInputBlockSize() + 1) {
            throw new DataLengthException("input too large for RSA cipher.\n");
        }
        if (n2 == this.getInputBlockSize() + 1 && (byArray[n] & 0x80) != 0) {
            throw new DataLengthException("input too large for RSA cipher.\n");
        }
        if (n != 0 || n2 != byArray.length) {
            byArray3 = new byte[n2];
            System.arraycopy(byArray, n, byArray3, 0, n2);
        } else {
            byArray3 = byArray;
        }
        BigInteger bigInteger = new BigInteger(1, byArray3);
        if (this.key instanceof RSAPrivateCrtKeyParameters) {
            object = (RSAPrivateCrtKeyParameters)this.key;
            ((RSAKeyParameters)object).getExponent();
            BigInteger bigInteger2 = ((RSAPrivateCrtKeyParameters)object).getP();
            BigInteger bigInteger3 = ((RSAPrivateCrtKeyParameters)object).getQ();
            BigInteger bigInteger4 = ((RSAPrivateCrtKeyParameters)object).getDP();
            BigInteger bigInteger5 = ((RSAPrivateCrtKeyParameters)object).getDQ();
            BigInteger bigInteger6 = ((RSAPrivateCrtKeyParameters)object).getQInv();
            BigInteger bigInteger7 = bigInteger.remainder(bigInteger2).modPow(bigInteger4, bigInteger2);
            BigInteger bigInteger8 = bigInteger.remainder(bigInteger3).modPow(bigInteger5, bigInteger3);
            BigInteger bigInteger9 = bigInteger7.subtract(bigInteger8);
            bigInteger9 = bigInteger9.multiply(bigInteger6);
            bigInteger9 = bigInteger9.mod(bigInteger2);
            BigInteger bigInteger10 = bigInteger9.multiply(bigInteger3);
            bigInteger10 = bigInteger10.add(bigInteger8);
            byArray2 = bigInteger10.toByteArray();
        } else {
            byArray2 = bigInteger.modPow(this.key.getExponent(), this.key.getModulus()).toByteArray();
        }
        if (this.forEncryption) {
            if (byArray2[0] == 0 && byArray2.length > this.getOutputBlockSize()) {
                object = new byte[byArray2.length - 1];
                System.arraycopy(byArray2, 1, object, 0, ((Object)object).length);
                return object;
            }
            if (byArray2.length < this.getOutputBlockSize()) {
                object = new byte[this.getOutputBlockSize()];
                System.arraycopy(byArray2, 0, object, ((Object)object).length - byArray2.length, byArray2.length);
                return object;
            }
        } else if (byArray2[0] == 0) {
            object = new byte[byArray2.length - 1];
            System.arraycopy(byArray2, 1, object, 0, ((Object)object).length);
            return object;
        }
        return byArray2;
    }
}

