/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.ReasonFlags;
import org.bouncycastle.asn1.x509.TBSCertList;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;

public class V2TBSCertListGenerator {
    DERInteger version = new DERInteger(1);
    AlgorithmIdentifier signature;
    X509Name issuer;
    DERUTCTime thisUpdate;
    DERUTCTime nextUpdate;
    X509Extensions extensions;
    private Vector crlentries;

    public void setSignature(AlgorithmIdentifier algorithmIdentifier) {
        this.signature = algorithmIdentifier;
    }

    public void setIssuer(X509Name x509Name) {
        this.issuer = x509Name;
    }

    public void setThisUpdate(DERUTCTime dERUTCTime) {
        this.thisUpdate = dERUTCTime;
    }

    public void setNextUpdate(DERUTCTime dERUTCTime) {
        this.nextUpdate = dERUTCTime;
    }

    public void addCRLEntry(DERConstructedSequence dERConstructedSequence) {
        if (this.crlentries == null) {
            this.crlentries = new Vector();
        }
        this.crlentries.addElement(dERConstructedSequence);
    }

    public void addCRLEntry(DERInteger dERInteger, DERUTCTime dERUTCTime, int n) {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(dERInteger);
        dERConstructedSequence.addObject(dERUTCTime);
        if (n != 0) {
            ReasonFlags reasonFlags = new ReasonFlags(n);
            DERConstructedSequence dERConstructedSequence2 = new DERConstructedSequence();
            dERConstructedSequence2.addObject(X509Extensions.ReasonCode);
            dERConstructedSequence2.addObject(reasonFlags);
            X509Extensions x509Extensions = new X509Extensions(dERConstructedSequence2);
            dERConstructedSequence.addObject(x509Extensions);
        }
        if (this.crlentries == null) {
            this.crlentries = new Vector();
        }
        this.crlentries.addElement(dERConstructedSequence);
    }

    public void setExtensions(X509Extensions x509Extensions) {
        this.extensions = x509Extensions;
    }

    public TBSCertList generateTBSCertList() {
        if (this.signature == null || this.issuer == null || this.thisUpdate == null) {
            throw new IllegalStateException("Not all mandatory fields set in V2 TBSCertList generator.");
        }
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(this.version);
        dERConstructedSequence.addObject(this.signature);
        dERConstructedSequence.addObject(this.issuer);
        dERConstructedSequence.addObject(this.thisUpdate);
        if (this.nextUpdate != null) {
            dERConstructedSequence.addObject(this.nextUpdate);
        }
        if (this.crlentries != null) {
            DERConstructedSequence dERConstructedSequence2 = new DERConstructedSequence();
            Enumeration enumeration = this.crlentries.elements();
            while (enumeration.hasMoreElements()) {
                dERConstructedSequence2.addObject((DERConstructedSequence)enumeration.nextElement());
            }
            dERConstructedSequence.addObject(dERConstructedSequence2);
        }
        if (this.extensions != null) {
            dERConstructedSequence.addObject(new DERTaggedObject(0, this.extensions));
        }
        return new TBSCertList(dERConstructedSequence);
    }
}

