/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.util.Vector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.CMSObject;

public class UnprotectedAttributes
extends CMSObject {
    private ASN1Set attributes;

    public UnprotectedAttributes(Vector vector) {
        this.setAttributes(vector);
    }

    public UnprotectedAttributes(ASN1Set aSN1Set) {
        this.attributes = aSN1Set;
    }

    public UnprotectedAttributes(UnprotectedAttributes unprotectedAttributes) {
        this.attributes = unprotectedAttributes.attributes;
    }

    public static UnprotectedAttributes getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return UnprotectedAttributes.getInstance(ASN1Set.getInstance(aSN1TaggedObject, bl));
    }

    public static UnprotectedAttributes getInstance(Object object) {
        if (object == null || object instanceof UnprotectedAttributes) {
            return (UnprotectedAttributes)object;
        }
        if (object instanceof ASN1Set) {
            return new UnprotectedAttributes((ASN1Set)object);
        }
        if (object instanceof Vector) {
            return new UnprotectedAttributes((Vector)object);
        }
        throw new IllegalArgumentException("Invalid UnprotectedAttributes: " + object.getClass().getName());
    }

    public Vector getAttributes() {
        int n = this.attributes.getSize();
        Vector<Attribute> vector = new Vector<Attribute>();
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(Attribute.getInstance(this.attributes.getObjectAt(n2)));
            ++n2;
        }
        return vector;
    }

    public DERObject getDERObject() {
        return this.attributes;
    }

    private void setAttributes(Vector vector) {
        int n = vector.size();
        this.attributes = new DERConstructedSet();
        int n2 = 0;
        while (n2 < n) {
            this.attributes.addObject(Attribute.getInstance(vector.elementAt(n2)));
            ++n2;
        }
    }
}

