/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.util.Vector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.cms.RecipientInfo;

public class RecipientInfos
extends CMSObject {
    private ASN1Set infos;

    public RecipientInfos(Vector vector) {
        this.setInfos(vector);
    }

    public RecipientInfos(ASN1Set aSN1Set) {
        this.infos = aSN1Set;
    }

    public RecipientInfos(RecipientInfos recipientInfos) {
        this.infos = recipientInfos.infos;
    }

    public static RecipientInfos getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return RecipientInfos.getInstance(ASN1Set.getInstance(aSN1TaggedObject, bl));
    }

    public static RecipientInfos getInstance(Object object) {
        if (object == null || object instanceof RecipientInfos) {
            return (RecipientInfos)object;
        }
        if (object instanceof ASN1Set) {
            return new RecipientInfos((ASN1Set)object);
        }
        throw new IllegalArgumentException("Invalid RecipientInfos: " + object.getClass().getName());
    }

    public Vector getInfos() {
        int n = this.infos.getSize();
        Vector<RecipientInfo> vector = new Vector<RecipientInfo>();
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(RecipientInfo.getInstance(this.infos.getObjectAt(n2)));
            ++n2;
        }
        return vector;
    }

    public DERObject getDERObject() {
        return this.infos;
    }

    private void setInfos(Vector vector) {
        int n = vector.size();
        this.infos = new DERConstructedSet();
        int n2 = 0;
        while (n2 < n) {
            this.infos.addObject(RecipientInfo.getInstance(vector.elementAt(n2)));
            ++n2;
        }
    }
}

