/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class OriginatorPublicKey
extends CMSObject {
    private AlgorithmIdentifier algorithm;
    private DERBitString publicKey;

    public OriginatorPublicKey(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        this.setAlgorithm(algorithmIdentifier);
        this.setPublicKey(byArray);
    }

    public OriginatorPublicKey(ASN1Sequence aSN1Sequence) {
        DEREncodable dEREncodable = aSN1Sequence.getObjectAt(0);
        if (dEREncodable instanceof AlgorithmIdentifier) {
            this.algorithm = (AlgorithmIdentifier)dEREncodable;
        } else if (dEREncodable instanceof DERObjectIdentifier) {
            this.algorithm = new AlgorithmIdentifier((DERObjectIdentifier)dEREncodable);
        } else if (dEREncodable instanceof ASN1Sequence) {
            this.algorithm = new AlgorithmIdentifier((ASN1Sequence)dEREncodable);
        } else {
            throw new IllegalArgumentException("Invalid AlgorithmIdentifier");
        }
        this.publicKey = (DERBitString)aSN1Sequence.getObjectAt(1);
    }

    public OriginatorPublicKey(OriginatorPublicKey originatorPublicKey) {
        this.algorithm = originatorPublicKey.algorithm;
        this.publicKey = originatorPublicKey.publicKey;
    }

    public static OriginatorPublicKey getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return OriginatorPublicKey.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static OriginatorPublicKey getInstance(Object object) {
        if (object == null || object instanceof OriginatorPublicKey) {
            return (OriginatorPublicKey)object;
        }
        if (object instanceof ASN1Sequence) {
            return new OriginatorPublicKey((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid OriginatorPublicKey: " + object.getClass().getName());
    }

    public AlgorithmIdentifier getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getPublicKey() {
        return this.publicKey.getBytes();
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.algorithm);
        bERConstructedSequence.addObject(this.publicKey);
        return bERConstructedSequence;
    }

    private void setAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        this.algorithm = algorithmIdentifier;
    }

    private void setPublicKey(byte[] byArray) {
        this.publicKey = new DERBitString(byArray);
    }
}

