/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.cms.ContentEncryptionAlgorithmIdentifier;
import org.bouncycastle.asn1.cms.ContentType;
import org.bouncycastle.asn1.cms.EncryptedContent;

public class EncryptedContentInfo
extends CMSObject {
    private ContentType contentType;
    private ContentEncryptionAlgorithmIdentifier contentEncryptionAlgorithm;
    private EncryptedContent encryptedContent;

    public EncryptedContentInfo(ContentType contentType, ContentEncryptionAlgorithmIdentifier contentEncryptionAlgorithmIdentifier, EncryptedContent encryptedContent) {
        this.setContentType(contentType);
        this.setContentEncryptionAlgorithm(contentEncryptionAlgorithmIdentifier);
        this.setEncryptedContent(encryptedContent);
    }

    public EncryptedContentInfo(ASN1Sequence aSN1Sequence) {
        this.contentType = ContentType.getInstance(aSN1Sequence.getObjectAt(0));
        this.contentEncryptionAlgorithm = ContentEncryptionAlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
        if (aSN1Sequence.getSize() > 2) {
            this.encryptedContent = EncryptedContent.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(2), false);
        }
    }

    public EncryptedContentInfo(EncryptedContentInfo encryptedContentInfo) {
        this.contentType = encryptedContentInfo.contentType;
        this.contentEncryptionAlgorithm = encryptedContentInfo.contentEncryptionAlgorithm;
        this.encryptedContent = encryptedContentInfo.encryptedContent;
    }

    public static EncryptedContentInfo getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return EncryptedContentInfo.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static EncryptedContentInfo getInstance(Object object) {
        if (object == null || object instanceof EncryptedContentInfo) {
            return (EncryptedContentInfo)object;
        }
        if (object instanceof ASN1Sequence) {
            return new EncryptedContentInfo((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid EncryptedContentInfo: " + object.getClass().getName());
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public ContentEncryptionAlgorithmIdentifier getContentEncryptionAlgorithm() {
        return this.contentEncryptionAlgorithm;
    }

    public EncryptedContent getEncryptedContent() {
        return this.encryptedContent;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.contentType);
        bERConstructedSequence.addObject(this.contentEncryptionAlgorithm);
        if (this.encryptedContent != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(false, 0, this.encryptedContent.getDERObject()));
        }
        return bERConstructedSequence;
    }

    private void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    private void setContentEncryptionAlgorithm(ContentEncryptionAlgorithmIdentifier contentEncryptionAlgorithmIdentifier) {
        this.contentEncryptionAlgorithm = contentEncryptionAlgorithmIdentifier;
    }

    private void setEncryptedContent(EncryptedContent encryptedContent) {
        this.encryptedContent = encryptedContent;
    }
}

