/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.util.Vector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.x509.CertificateList;

public class CertificateRevocationLists
extends CMSObject {
    private ASN1Set crls;

    public CertificateRevocationLists(Vector vector) {
        this.setCrls(vector);
    }

    public CertificateRevocationLists(ASN1Set aSN1Set) {
        this.crls = aSN1Set;
    }

    public CertificateRevocationLists(CertificateRevocationLists certificateRevocationLists) {
        this.crls = certificateRevocationLists.crls;
    }

    public static CertificateRevocationLists getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return CertificateRevocationLists.getInstance(ASN1Set.getInstance(aSN1TaggedObject, bl));
    }

    public static CertificateRevocationLists getInstance(Object object) {
        if (object == null || object instanceof CertificateRevocationLists) {
            return (CertificateRevocationLists)object;
        }
        if (object instanceof ASN1Set) {
            return new CertificateRevocationLists((ASN1Set)object);
        }
        if (object instanceof Vector) {
            return new CertificateRevocationLists((Vector)object);
        }
        throw new IllegalArgumentException("Invalid CertificateRevocationLists: " + object.getClass().getName());
    }

    public Vector getCrls() {
        int n = this.crls.getSize();
        Vector<CertificateList> vector = new Vector<CertificateList>();
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(CertificateList.getInstance(this.crls.getObjectAt(n2)));
            ++n2;
        }
        return vector;
    }

    public DERObject getDERObject() {
        return this.crls;
    }

    private void setCrls(Vector vector) {
        int n = vector.size();
        this.crls = new DERConstructedSet();
        int n2 = 0;
        while (n2 < n) {
            this.crls.addObject(CertificateList.getInstance(vector.elementAt(n2)));
            ++n2;
        }
    }
}

