/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.BERInputStream;
import org.bouncycastle.asn1.BEROutputStream;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;

public abstract class CMSObject
implements DEREncodable {
    protected static final int BER = 0;
    protected static final int DER = 1;

    public boolean validate() {
        return true;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = this.getOutputStream(byteArrayOutputStream);
        aSN1OutputStream.writeObject(this);
        aSN1OutputStream.close();
        ((OutputStream)byteArrayOutputStream).close();
        return byteArrayOutputStream.toByteArray();
    }

    public ASN1OutputStream getOutputStream(OutputStream outputStream) throws IOException {
        switch (CMSObject.getASN1Type()) {
            case 0: {
                return new BEROutputStream(outputStream);
            }
            case 1: {
                return new DEROutputStream(outputStream);
            }
        }
        throw new IOException("Invalid encoding");
    }

    public static ASN1InputStream getInputStream(InputStream inputStream) throws IOException {
        switch (CMSObject.getASN1Type()) {
            case 0: {
                return new BERInputStream(inputStream);
            }
            case 1: {
                return new DERInputStream(inputStream);
            }
        }
        throw new IOException("Invalid encoding");
    }

    protected static int getASN1Type() {
        return 0;
    }

    public abstract DERObject getDERObject();
}

