/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.cert.CRLException;
import java.security.cert.X509Extension;
import java.util.Date;
import java.util.Set;

public abstract class X509CRLEntry
implements X509Extension {
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof X509CRLEntry)) {
            return false;
        }
        try {
            byte[] byArray = this.getEncoded();
            byte[] byArray2 = ((X509CRLEntry)object).getEncoded();
            return MessageDigest.isEqual(byArray, byArray2);
        }
        catch (CRLException cRLException) {
            return false;
        }
    }

    public int hashCode() {
        int n = 0;
        try {
            byte[] byArray = this.getEncoded();
            int n2 = 1;
            while (n2 < byArray.length) {
                n += byArray[n2] * n2;
                ++n2;
            }
        }
        catch (CRLException cRLException) {
            return n;
        }
        return n;
    }

    public abstract byte[] getEncoded() throws CRLException;

    public abstract Date getRevocationDate();

    public abstract BigInteger getSerialNumber();

    public abstract boolean hasExtensions();

    public abstract String toString();

    public abstract Set getCriticalExtensionOIDs();

    public abstract byte[] getExtensionValue(String var1);

    public abstract Set getNonCriticalExtensionOIDs();

    public abstract boolean hasUnsupportedCriticalExtension();
}

