/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;

public abstract class Certificate {
    private String type;

    protected Certificate(String string) {
        this.type = string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Certificate)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        try {
            byte[] byArray = this.getEncoded();
            byte[] byArray2 = ((Certificate)object).getEncoded();
            return MessageDigest.isEqual(byArray, byArray2);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return false;
        }
    }

    public final String getType() {
        return this.type;
    }

    public int hashCode() {
        try {
            byte[] byArray = this.getEncoded();
            int n = 0;
            int n2 = 0;
            while (n2 < byArray.length) {
                n += byArray[n2];
                ++n2;
            }
            return n;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return 0;
        }
    }

    public abstract byte[] getEncoded() throws CertificateEncodingException;

    public abstract PublicKey getPublicKey();

    public abstract String toString();

    public abstract void verify(PublicKey var1) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract void verify(PublicKey var1, String var2) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;
}

