/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.util;

import java.awt.Color;
import java.awt.image.RGBImageFilter;

public class HSBFilter
extends RGBImageFilter {
    private float[] hsbvals = new float[3];
    float fgHue;
    float fgSaturation;
    float fgBrightness;

    public HSBFilter(Color fg) {
        Color.RGBtoHSB(fg.getRed(), fg.getGreen(), fg.getBlue(), this.hsbvals);
        this.fgHue = this.hsbvals[0];
        this.fgSaturation = this.hsbvals[1];
        this.fgBrightness = this.hsbvals[2];
        this.canFilterIndexColorModel = true;
    }

    public int filterRGB(int x, int y, int rgb) {
        int alpha = rgb >> 24 & 0xFF;
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        Color.RGBtoHSB(red, green, blue, this.hsbvals);
        float newHue = this.fgHue;
        float newSaturation = this.hsbvals[1] * this.fgSaturation;
        float newBrightness = this.hsbvals[2] * (this.hsbvals[1] * this.fgBrightness + (1.0f - this.hsbvals[1]));
        rgb = Color.HSBtoRGB(newHue, newSaturation, newBrightness);
        return rgb & 0xFFFFFF | alpha << 24;
    }
}

