/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swinghelper.layer.painter;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import org.jdesktop.swinghelper.layer.JXLayer;
import org.jdesktop.swinghelper.layer.effect.Effect;
import org.jdesktop.swinghelper.layer.painter.AbstractBufferedPainter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentPainter<V extends JComponent>
extends AbstractBufferedPainter<V> {
    private JComponent component;

    public ComponentPainter() {
        this(null, null);
    }

    public ComponentPainter(JComponent component) {
        this(component, null);
    }

    public ComponentPainter(JComponent component, Effect ... effects) {
        this.setComponent(component);
        this.setEffects(effects);
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void setComponent(JComponent component) {
        this.component = component;
        this.fireLayerItemChanged();
    }

    public void repaint() {
        if (this.isPainterValid()) {
            if (this.getBuffer() == null || this.getBuffer().getWidth() != this.component.getWidth() || this.getBuffer().getHeight() != this.component.getHeight()) {
                this.setBuffer(this.createBuffer(this.component.getWidth(), this.component.getHeight()));
            }
            Graphics g = this.getBuffer().getGraphics();
            this.component.paint(g);
            g.dispose();
            this.processEffects(null);
        }
    }

    @Override
    protected boolean isPainterValid() {
        return this.component != null && this.component.getWidth() != 0 && this.component.getHeight() != 0;
    }

    @Override
    protected boolean isImageValid(Graphics2D g2, JXLayer<V> l) {
        return true;
    }

    protected BufferedImage createBuffer(int width, int height) {
        return new BufferedImage(width, height, 2);
    }
}

