/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import java.util.Arrays;
import java.util.Optional;
import org.junit.jupiter.api.condition.EnabledOnJre;
import org.junit.jupiter.api.condition.JRE;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;

class EnabledOnJreCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED_BY_DEFAULT = ConditionEvaluationResult.enabled("@EnabledOnJre is not present");
    static final ConditionEvaluationResult ENABLED_ON_CURRENT_JRE = ConditionEvaluationResult.enabled("Enabled on JRE version: " + System.getProperty("java.version"));
    static final ConditionEvaluationResult DISABLED_ON_CURRENT_JRE = ConditionEvaluationResult.disabled("Disabled on JRE version: " + System.getProperty("java.version"));

    EnabledOnJreCondition() {
    }

    @Override
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional<EnabledOnJre> optional = AnnotationUtils.findAnnotation(context.getElement(), EnabledOnJre.class);
        if (optional.isPresent()) {
            JRE[] versions = optional.get().value();
            Preconditions.condition(versions.length > 0, "You must declare at least one JRE in @EnabledOnJre");
            return Arrays.stream(versions).anyMatch(JRE::isCurrentVersion) ? ENABLED_ON_CURRENT_JRE : DISABLED_ON_CURRENT_JRE;
        }
        return ENABLED_BY_DEFAULT;
    }
}

