/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins;

import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNameTree;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import com.lowagie.toolbox.swing.PdfInformationPanel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.JInternalFrame;

public class ExtractAttachments
extends AbstractTool {
    static {
        ExtractAttachments.addVersion("$Id: ExtractAttachments.java 3712 2009-02-20 20:11:31Z xlv $");
    }

    public ExtractAttachments() {
        FileArgument f = new FileArgument(this, "srcfile", "The file you want to operate on", false, new PdfFilter());
        f.setLabel(new PdfInformationPanel());
        this.arguments.add(f);
    }

    @Override
    protected void createFrame() {
        this.internalFrame = new JInternalFrame("ExtractAttachments", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== ExtractAttachments OPENED ===");
    }

    @Override
    public void execute() {
        try {
            PdfDictionary embFiles;
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File src = (File)this.getValue("srcfile");
            PdfReader reader = new PdfReader(src.getAbsolutePath());
            File parentFile = src.getParentFile();
            String outPath = parentFile != null ? parentFile.getAbsolutePath() : "";
            PdfDictionary catalog = reader.getCatalog();
            PdfDictionary names = catalog.getAsDict(PdfName.NAMES);
            if (names != null && (embFiles = names.getAsDict(new PdfName("EmbeddedFiles"))) != null) {
                HashMap<String, PdfObject> embMap = PdfNameTree.readTree(embFiles);
                for (PdfObject pdfObject : embMap.values()) {
                    PdfDictionary filespec = (PdfDictionary)PdfReader.getPdfObject(pdfObject);
                    ExtractAttachments.unpackFile(reader, filespec, outPath);
                }
            }
            int k = 1;
            while (k <= reader.getNumberOfPages()) {
                PdfArray annots = reader.getPageN(k).getAsArray(PdfName.ANNOTS);
                if (annots != null) {
                    for (PdfObject pdfObject : annots.getElements()) {
                        PdfDictionary annot = (PdfDictionary)PdfReader.getPdfObject(pdfObject);
                        PdfName subType = annot.getAsName(PdfName.SUBTYPE);
                        if (!PdfName.FILEATTACHMENT.equals(subType)) continue;
                        PdfDictionary filespec = annot.getAsDict(PdfName.FS);
                        ExtractAttachments.unpackFile(reader, filespec, outPath);
                    }
                }
                ++k;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void valueHasChanged(AbstractArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] args) {
        ExtractAttachments tool = new ExtractAttachments();
        if (args.length < 1) {
            System.err.println(tool.getUsage());
        }
        tool.setMainArguments(args);
        tool.execute();
    }

    @Override
    protected File getDestPathPDF() throws InstantiationException {
        throw new InstantiationException("There is more than one destfile.");
    }

    public static void unpackFile(PdfReader reader, PdfDictionary filespec, String outPath) throws IOException {
        if (filespec == null) {
            return;
        }
        PdfName type = filespec.getAsName(PdfName.TYPE);
        if (!PdfName.F.equals(type) && !PdfName.FILESPEC.equals(type)) {
            return;
        }
        PdfDictionary ef = filespec.getAsDict(PdfName.EF);
        if (ef == null) {
            return;
        }
        PdfString fn = filespec.getAsString(PdfName.F);
        System.out.println("Unpacking file '" + fn + "' to " + outPath);
        if (fn == null) {
            return;
        }
        File fLast = new File(fn.toUnicodeString());
        File fullPath = new File(outPath, fLast.getName());
        if (fullPath.exists()) {
            return;
        }
        PRStream prs = (PRStream)PdfReader.getPdfObject(ef.get(PdfName.F));
        if (prs == null) {
            return;
        }
        byte[] b = PdfReader.getStreamBytes(prs);
        FileOutputStream fout = new FileOutputStream(fullPath);
        fout.write(b);
        fout.close();
    }
}

